/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Bucket;
import freenet.support.FileBucket;
import freenet.support.RandomAccessFileBucket;
import java.io.IOException;

public class StripedBucketArray {
    private RandomAccessFileBucket[] Buckets = null;
    private BucketData[] srcData = null;

    public Bucket[] allocate(Bucket[] src) throws IOException {
        if (this.srcData != null) {
            throw new IllegalStateException("Release the previously allocated buckets!");
        }
        long size = src[0].size();
        Bucket[] ret = new Bucket[src.length];
        try {
            this.srcData = new BucketData[src.length];
            for (int i = 0; i < src.length; ++i) {
                this.srcData[i] = StripedBucketArray.makeBucketData(src[i]);
                ret[i] = this.srcData[i].rafb;
            }
        }
        catch (IOException ioe) {
            this.srcData = null;
            throw ioe;
        }
        return ret;
    }

    public void release() {
        if (this.srcData == null) {
            return;
        }
        for (int i = 0; i < this.srcData.length; ++i) {
            try {
                this.srcData[i].release();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.srcData = null;
    }

    public void setRange(long offset, long len) throws IOException {
        for (int i = 0; i < this.srcData.length; ++i) {
            this.srcData[i].rafb.setRange(this.srcData[i].offset + offset, len);
        }
    }

    private static BucketData makeBucketData(Bucket b) throws IOException {
        if (b instanceof RandomAccessFileBucket) {
            return new BucketData((RandomAccessFileBucket)b);
        }
        if (b instanceof FileBucket) {
            return new BucketData((FileBucket)b);
        }
        throw new IllegalArgumentException("Bucket must be of type FileBucket or RandomAccessFileBucket.");
    }

    private static class BucketData {
        long offset = 0L;
        long len = 0L;
        boolean fromRAFB = false;
        RandomAccessFileBucket rafb = null;

        BucketData(RandomAccessFileBucket rafb) {
            RandomAccessFileBucket.Range r = rafb.getRange();
            this.offset = r.offset;
            this.len = r.len;
            this.fromRAFB = true;
            this.rafb = rafb;
        }

        BucketData(FileBucket fb) throws IOException {
            this.offset = 0L;
            this.len = fb.size();
            this.fromRAFB = false;
            this.rafb = new RandomAccessFileBucket(fb.getFile(), 0L, fb.size(), false);
        }

        void release() {
            if (this.fromRAFB) {
                try {
                    this.rafb.setRange(this.offset, this.len);
                }
                catch (Exception exception) {}
            } else {
                this.rafb.release();
            }
            this.rafb = null;
        }
    }
}

