/*
 * Decompiled with CFR 0.152.
 */
package fecimpl;

import com.onionnetworks.fec.DefaultFECCodeFactory;
import com.onionnetworks.fec.FECCode;
import com.onionnetworks.util.Buffer;
import freenet.support.Bucket;
import freenet.support.BucketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class FECUtils {
    private static Logger logger = Logger.getLogger(FECUtils.class.getName());

    public static final void disableNativeCode() {
        Properties systemProps = System.getProperties();
        systemProps.setProperty("com.onionnetworks.fec.keys", "pure8,pure16");
        System.setProperties(systemProps);
        logger.info("Native code off. Using Java FEC implementaion.");
    }

    static final void encode(FECCode code, int n, int k, Bucket[] blocks, Bucket[] checkBlocks, int[] requested) throws IOException {
        int BLOCK_SIZE = (int)blocks[0].size();
        int l = n - k;
        int[] index = null;
        if (requested != null) {
            index = requested;
        } else {
            index = new int[l];
            int i = 0;
            for (i = 0; i < l; ++i) {
                index[i] = k + i;
            }
        }
        if (requested.length != index.length) {
            throw new IOException("Illegal arguments: requested.length != checkBlocks.length");
        }
        long start = System.currentTimeMillis();
        Buffer[] src = FECUtils.readBuffers(blocks, BLOCK_SIZE);
        Buffer[] repair = FECUtils.allocateBuffers(index.length, BLOCK_SIZE);
        long start2 = System.currentTimeMillis();
        code.encode(src, repair, index);
        long end2 = System.currentTimeMillis();
        int i = 0;
        for (i = 0; i < repair.length; ++i) {
            FECUtils.dumpBlock(repair[i], checkBlocks[i]);
        }
        logger.fine("Made " + index.length + " " + BLOCK_SIZE + " byte check blocks in " + (System.currentTimeMillis() - start) + "ms (" + (end2 - start2) + "ms for computing).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Bucket[] decode(Bucket[] blocks, int k, BucketFactory bucketFactory) throws IOException {
        DefaultFECCodeFactory factory = new DefaultFECCodeFactory();
        int n = blocks.length;
        FECCode code = factory.createFECCode(k, n);
        NonNulls nn = FECUtils.findNonNullBuckets(blocks, k);
        int blockSize = (int)nn.buckets[0].size();
        Bucket[] ret = null;
        Bucket[] decoded = null;
        try {
            decoded = FECUtils.makeBuckets(bucketFactory, nn.missingIndices.length, blockSize, false);
            FECUtils.decode(code, nn.buckets, nn.indices, k, nn.missingIndices, decoded);
            int index = 0;
            ret = new Bucket[k];
            for (int i = 0; i < k; ++i) {
                if (blocks[i] != null) {
                    ret[i] = blocks[i];
                    continue;
                }
                ret[i] = decoded[index];
                ++index;
            }
            decoded = null;
        }
        catch (Throwable throwable) {
            FECUtils.freeBuckets(bucketFactory, decoded);
            throw throwable;
        }
        FECUtils.freeBuckets(bucketFactory, decoded);
        return ret;
    }

    static final NonNulls findNonNullBuckets(Bucket[] blocks, int k) {
        int missingDataBlocks = 0;
        int count = 0;
        int i = 0;
        for (i = 0; i < blocks.length; ++i) {
            if (blocks[i] != null) {
                ++count;
                continue;
            }
            if (i >= k) continue;
            ++missingDataBlocks;
        }
        NonNulls ret = new NonNulls();
        ret.buckets = new Bucket[count];
        ret.indices = new int[count];
        ret.missingIndices = new int[missingDataBlocks];
        int index = 0;
        int missingIndex = 0;
        for (i = 0; i < blocks.length; ++i) {
            if (blocks[i] != null) {
                ret.buckets[index] = blocks[i];
                ret.indices[index] = i;
                ++index;
                continue;
            }
            if (i >= k) continue;
            ret.missingIndices[missingIndex] = i;
            ++missingIndex;
        }
        return ret;
    }

    static final void decode(FECCode code, Bucket[] blocks, int[] indices, int k, int[] decodeIndices, Bucket[] decoded) throws IOException {
        if (blocks.length < k) {
            throw new IllegalArgumentException("Not enough packets to decode.");
        }
        long blockSize = blocks[0].size();
        Buffer[] packets = FECUtils.readBuffers(blocks, (int)blockSize);
        long start = System.currentTimeMillis();
        int[] copyOfIndices = new int[indices.length];
        System.arraycopy(indices, 0, copyOfIndices, 0, indices.length);
        code.decode(packets, copyOfIndices);
        logger.fine("FEC decode took " + (System.currentTimeMillis() - start) + "ms.");
        for (int i = 0; i < decodeIndices.length; ++i) {
            FECUtils.dumpBlock(packets[decodeIndices[i]], decoded[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Bucket[] makeBuckets(BucketFactory factory, int n, int blockSize, boolean zero) throws IOException {
        Bucket[] ret = null;
        Bucket[] buckets = new Bucket[n];
        byte[] buf = null;
        int i = 0;
        if (zero) {
            buf = new byte[4096];
            for (i = 0; i < buf.length; ++i) {
                buf[i] = 0;
            }
        }
        try {
            for (i = 0; i < n; ++i) {
                buckets[i] = factory.makeBucket(blockSize);
                if (!zero) continue;
                OutputStream out = null;
                try {
                    int nBytes;
                    out = buckets[i].getOutputStream();
                    for (int byteCount = blockSize; byteCount > 0; byteCount -= nBytes) {
                        nBytes = buf.length;
                        if (nBytes > byteCount) {
                            nBytes = byteCount;
                        }
                        out.write(buf, 0, nBytes);
                    }
                    continue;
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            ret = buckets;
            buckets = null;
        }
        finally {
            FECUtils.freeBuckets(factory, buckets);
        }
        return ret;
    }

    public static void freeBuckets(BucketFactory bucketFactory, Bucket[] buckets) {
        if (buckets == null || bucketFactory == null) {
            return;
        }
        for (int i = 0; i < buckets.length; ++i) {
            if (buckets[i] == null) continue;
            try {
                bucketFactory.freeBucket(buckets[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            buckets[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void read(Bucket b, byte[] buf, int bufOffset) throws IOException {
        int length = (int)b.size();
        int offset = 0;
        InputStream in = null;
        try {
            in = b.getInputStream();
            while (length > 0) {
                int nRead = in.read(buf, offset + bufOffset, length);
                if (nRead < 0) {
                    throw new IOException("unexpected !");
                }
                length -= nRead;
                offset += nRead;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private static final Buffer[] readBuffers(Bucket[] buckets, int blockSize) throws IOException {
        Buffer[] ret = new Buffer[buckets.length];
        for (int i = 0; i < buckets.length; ++i) {
            byte[] buf = new byte[blockSize];
            int bucketSize = (int)buckets[i].size();
            if (bucketSize > 0) {
                FECUtils.read(buckets[i], buf, 0);
            } else {
                bucketSize = 0;
            }
            if (bucketSize < blockSize) {
                for (int z = bucketSize; z < blockSize; ++z) {
                    buf[z] = 0;
                }
            }
            ret[i] = new Buffer(buf);
        }
        return ret;
    }

    private static final Buffer[] allocateBuffers(int size, int blockSize) {
        Buffer[] ret = new Buffer[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = new Buffer(new byte[blockSize]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void dumpBlock(Buffer block, Bucket b) throws IOException {
        OutputStream out = null;
        try {
            b.resetWrite();
            out = b.getOutputStream();
            byte[] bytes = block.getBytes();
            int length = bytes.length;
            int offset = 0;
            out.write(bytes, offset, length);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final Bucket[] dumpBlocks(Buffer[] blocks, BucketFactory factory, int blockSize, int nBlocks) throws IOException {
        int count = blocks.length;
        if (count > nBlocks) {
            count = nBlocks;
        }
        Bucket[] ret = new Bucket[count];
        try {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = factory.makeBucket(blockSize);
                FECUtils.dumpBlock(blocks[i], ret[i]);
            }
        }
        catch (IOException ioe) {
            for (int i = 0; i < ret.length; ++i) {
                if (ret[i] == null) continue;
                try {
                    factory.freeBucket(ret[i]);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw ioe;
        }
        return ret;
    }

    private static final void read(Bucket[] buckets, byte[] buf) throws IOException {
        int i;
        int length = 0;
        for (i = 0; i < buckets.length; ++i) {
            length = (int)((long)length + buckets[i].size());
        }
        if (length > buf.length) {
            throw new IllegalArgumentException("The buffer is too small.");
        }
        length = 0;
        for (i = 0; i < buckets.length; ++i) {
            FECUtils.read(buckets[i], buf, length);
            length = (int)((long)length + buckets[i].size());
        }
    }

    static class NonNulls {
        Bucket[] buckets = null;
        int[] indices = null;
        int[] missingIndices = null;

        NonNulls() {
        }
    }
}

