/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec;

import com.onionnetworks.fec.FECCode;
import com.onionnetworks.fec.Native8Code;
import com.onionnetworks.util.NativeDeployer;
import java.util.logging.Logger;

public class Native16Code
extends FECCode {
    private static Logger logger = Logger.getLogger(Native16Code.class.getName());
    private int code;

    public Native16Code(int k, int n) {
        super(k, n);
        this.code = this.nativeNewFEC(k, n);
    }

    protected void encode(byte[][] src, int[] srcOff, byte[][] repair, int[] repairOff, int[] index, int packetLength) {
        if (packetLength % 2 != 0) {
            throw new IllegalArgumentException("For 16 bit codes, buffers must be 16 bit aligned.");
        }
        this.nativeEncode(this.code, src, srcOff, index, repair, repairOff, this.k, packetLength);
    }

    protected void decode(byte[][] pkts, int[] pktsOff, int[] index, int packetLength, boolean inOrder) {
        if (packetLength % 2 != 0) {
            throw new IllegalArgumentException("For 16 bit codes, buffers must be 16 bit aligned.");
        }
        if (!inOrder) {
            Native16Code.shuffle(pkts, pktsOff, index, this.k);
        }
        this.nativeDecode(this.code, pkts, pktsOff, index, this.k, packetLength);
    }

    protected native void nativeEncode(int var1, byte[][] var2, int[] var3, int[] var4, byte[][] var5, int[] var6, int var7, int var8);

    protected native void nativeDecode(int var1, byte[][] var2, int[] var3, int[] var4, int var5, int var6);

    protected synchronized native int nativeNewFEC(int var1, int var2);

    protected synchronized native void nativeFreeFEC(int var1);

    protected void finalize() throws Throwable {
        this.nativeFreeFEC(this.code);
    }

    public String toString() {
        return new String("Native16Code[k=" + this.k + ",n=" + this.n + "]");
    }

    static {
        String path = NativeDeployer.getLibraryPath(Native8Code.class.getClassLoader(), "fec16");
        if (path != null) {
            System.load(path);
        } else {
            logger.severe("Unable to find native library for fec16");
        }
    }
}

