/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec;

import com.onionnetworks.util.Buffer;

public abstract class FECCode {
    protected int k;
    protected int n;

    protected FECCode(int k, int n) {
        this.k = k;
        this.n = n;
    }

    protected abstract void encode(byte[][] var1, int[] var2, byte[][] var3, int[] var4, int[] var5, int var6);

    protected abstract void decode(byte[][] var1, int[] var2, int[] var3, int var4, boolean var5);

    public void encode(Buffer[] src, Buffer[] repair, int[] index) {
        int i;
        byte[][] srcBufs = new byte[src.length][];
        int[] srcOffs = new int[src.length];
        byte[][] repairBufs = new byte[repair.length][];
        int[] repairOffs = new int[repair.length];
        for (i = 0; i < srcBufs.length; ++i) {
            srcBufs[i] = src[i].b;
            srcOffs[i] = src[i].off;
        }
        for (i = 0; i < repairBufs.length; ++i) {
            repairBufs[i] = repair[i].b;
            repairOffs[i] = repair[i].off;
        }
        this.encode(srcBufs, srcOffs, repairBufs, repairOffs, index, src[0].len);
    }

    public void decode(Buffer[] pkts, int[] index) {
        FECCode.copyShuffle(pkts, index, this.k);
        byte[][] bufs = new byte[pkts.length][];
        int[] offs = new int[pkts.length];
        for (int i = 0; i < bufs.length; ++i) {
            bufs[i] = pkts[i].b;
            offs[i] = pkts[i].off;
        }
        this.decode(bufs, offs, index, pkts[0].len, true);
    }

    protected static final void copyShuffle(Buffer[] pkts, int[] index, int k) {
        byte[] b = null;
        int i = 0;
        while (i < k) {
            if (index[i] >= k || index[i] == i) {
                ++i;
                continue;
            }
            int c = index[i];
            if (index[c] == c) {
                throw new IllegalArgumentException("Shuffle Error: Duplicate indexes at " + i);
            }
            int tmp = index[i];
            index[i] = index[c];
            index[c] = tmp;
            if (b == null) {
                b = new byte[pkts[0].len];
            }
            System.arraycopy(pkts[i].b, pkts[i].off, b, 0, b.length);
            System.arraycopy(pkts[c].b, pkts[c].off, pkts[i].b, pkts[i].off, b.length);
            System.arraycopy(b, 0, pkts[c].b, pkts[c].off, b.length);
        }
    }

    protected static final void shuffle(byte[][] pkts, int[] pktsOff, int[] index, int k) {
        int i = 0;
        while (i < k) {
            if (index[i] >= k || index[i] == i) {
                ++i;
                continue;
            }
            int c = index[i];
            if (index[c] == c) {
                throw new IllegalArgumentException("Shuffle error at " + i);
            }
            byte[] tmp = pkts[i];
            pkts[i] = pkts[c];
            pkts[c] = tmp;
            int tmp2 = pktsOff[i];
            pktsOff[i] = pktsOff[c];
            pktsOff[c] = tmp2;
            tmp2 = index[i];
            index[i] = index[c];
            index[c] = tmp2;
        }
    }
}

