/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WriteOutputStream
extends FilterOutputStream {
    public WriteOutputStream(OutputStream out) {
        super(out);
    }

    public void writeUTF(String s) throws IOException {
        super.write(s.getBytes("UTF8"));
    }

    public void writeUTF(String s, char term) throws IOException {
        this.writeUTF(s);
        super.write(this.encodeUTF(term));
    }

    public void writeUTF(String s, char pre, char term) throws IOException {
        this.writeUTF(s);
        super.write(this.encodeUTF(pre));
        super.write(this.encodeUTF(term));
    }

    public void print(String s) {
        try {
            this.writeUTF(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void println(String s) {
        try {
            this.writeUTF(s, '\n');
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] encodeUTF(char c) {
        byte[] byArray;
        if (c <= '\u007f') {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = (byte)(c & 0xFF);
        } else if (c <= '\u07ff') {
            byte[] byArray3 = new byte[2];
            byArray3[0] = (byte)(0xC0 | c >> 6);
            byArray = byArray3;
            byArray3[1] = (byte)(0x80 | c & 0x3F);
        } else {
            byte[] byArray4 = new byte[3];
            byArray4[0] = (byte)(0xE0 | c >> 12);
            byArray4[1] = (byte)(0xC0 | c >> 6);
            byArray = byArray4;
            byArray4[2] = (byte)(0x80 | c & 0x3F);
        }
        return byArray;
    }
}

