/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt.ciphers;

import freenet.crypt.BlockCipher;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Twofish_Algorithm;
import java.security.InvalidKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Twofish
implements BlockCipher {
    private static Logger logger = Logger.getLogger(Twofish.class.getName());
    private Object sessionKey;
    private int keysize;

    public Twofish(Integer keysize) throws UnsupportedCipherException {
        this((int)keysize);
    }

    public Twofish(int keysize) throws UnsupportedCipherException {
        if (keysize != 64 && keysize != 128 && keysize != 192 && keysize != 256) {
            throw new UnsupportedCipherException("Invalid keysize");
        }
        this.keysize = keysize;
    }

    public Twofish() {
        this.keysize = 128;
    }

    public final int getBlockSize() {
        return 128;
    }

    public final int getKeySize() {
        return this.keysize;
    }

    public final void initialize(byte[] key) {
        try {
            byte[] nkey = new byte[this.keysize >> 3];
            System.arraycopy(key, 0, nkey, 0, nkey.length);
            this.sessionKey = Twofish_Algorithm.makeKey(nkey);
        }
        catch (InvalidKeyException e) {
            logger.log(Level.SEVERE, "Exception thrown in initialize(byte[] key)", e);
        }
    }

    public final void encipher(byte[] block, byte[] result) {
        Twofish_Algorithm.blockEncrypt(block, result, 0, this.sessionKey);
    }

    public final void decipher(byte[] block, byte[] result) {
        Twofish_Algorithm.blockDecrypt(block, result, 0, this.sessionKey);
    }
}

