/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.Digest;
import freenet.crypt.EntropySource;
import freenet.crypt.RandFile;
import freenet.crypt.RandomSource;
import freenet.crypt.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;

public final class Yarrow
extends RandomSource {
    private static Logger logger = Logger.getLogger(Yarrow.class.getName());
    private static final int Pg = 10;
    private File seedfile;
    private BlockCipher cipher_ctx;
    private byte[] output_buffer;
    private byte[] counter;
    private byte[] allZeroString;
    private byte[] tmp;
    private int output_count;
    private int fetch_counter;
    private int block_bytes;
    static final int[][] bitTable = new int[][]{{0, 0}, {1, 1}, {1, 3}, {1, 7}, {1, 15}, {1, 31}, {1, 63}, {1, 127}, {1, 255}, {2, 511}, {2, 1023}, {2, 2047}, {2, 4095}, {2, 8191}, {2, 16383}, {2, Short.MAX_VALUE}, {2, 65535}, {3, 131071}, {3, 262143}, {3, 524287}, {3, 1048575}, {3, 0x1FFFFF}, {3, 0x3FFFFF}, {3, 0x7FFFFF}, {3, 0xFFFFFF}, {4, 0x1FFFFFF}, {4, 0x3FFFFFF}, {4, 0x7FFFFFF}, {4, 0xFFFFFFF}, {4, 0x1FFFFFFF}, {4, 0x3FFFFFFF}, {4, Integer.MAX_VALUE}, {4, -1}};
    private Digest fast_pool;
    private Digest slow_pool;
    private int fast_entropy;
    private int slow_entropy;
    private int digestSize;
    private boolean fast_select;
    private byte[] long_buffer = new byte[8];
    private Hashtable entropySeen;
    private static final int Pt = 5;
    private Digest reseed_ctx;
    private static final int FAST_THRESHOLD = 100;
    private static final int SLOW_THRESHOLD = 160;
    private static final int SLOW_K = 2;

    public Yarrow() {
        this("prng.seed", "SHA1", "Rijndael");
    }

    public Yarrow(String seed, String digest, String cipher) {
        this(new File(seed), digest, cipher);
    }

    public Yarrow(File seed, String digest, String cipher) {
        this.accumulator_init(digest);
        this.reseed_init(digest);
        this.seedfile = seed;
        this.generator_init(cipher);
        this.entropy_init(seed);
    }

    private void entropy_init(File seed) {
        Properties sys = System.getProperties();
        EntropySource startupEntropy = new EntropySource();
        Enumeration<?> enumeration = sys.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.consumeString(key);
            this.consumeString(sys.getProperty(key));
        }
        try {
            this.consumeString(InetAddress.getLocalHost().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.acceptEntropy(startupEntropy, System.currentTimeMillis(), 0);
        this.acceptEntropy(startupEntropy, Runtime.getRuntime().freeMemory(), 0);
        this.acceptEntropy(startupEntropy, Runtime.getRuntime().totalMemory(), 0);
        this.read_seed(seed);
    }

    private void read_seed(File filename) {
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(filename));
            EntropySource seedFile = new EntropySource();
            try {
                for (int i = 0; i < 32; ++i) {
                    this.acceptEntropy(seedFile, dis.readLong(), 64);
                }
            }
            catch (EOFException f) {
                // empty catch block
            }
            dis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fast_pool_reseed();
    }

    private void write_seed(File filename) {
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(filename));
            for (int i = 0; i < 32; ++i) {
                dos.writeLong(this.nextLong());
            }
            dos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void generator_init(String cipher) {
        this.cipher_ctx = Util.getCipherByName(cipher);
        this.output_buffer = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.counter = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.allZeroString = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.tmp = new byte[this.cipher_ctx.getKeySize() / 8];
        this.fetch_counter = this.output_buffer.length;
    }

    private final void counterInc() {
        int i = this.counter.length - 1;
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] != 0) break;
        }
    }

    private final void generateOutput() {
        this.counterInc();
        this.output_buffer = new byte[this.counter.length];
        this.cipher_ctx.encipher(this.counter, this.output_buffer);
        if (this.output_count++ > 10) {
            this.output_count = 0;
            this.nextBytes(this.tmp);
            this.rekey(this.tmp);
        }
    }

    private void rekey(byte[] key) {
        this.cipher_ctx.initialize(key);
        this.counter = new byte[this.allZeroString.length];
        this.cipher_ctx.encipher(this.allZeroString, this.counter);
        Util.wipe(key);
    }

    private synchronized int getBytes(int count) {
        if (this.fetch_counter + count > this.output_buffer.length) {
            this.fetch_counter = 0;
            this.generateOutput();
            return this.getBytes(count);
        }
        int rv = this.fetch_counter;
        this.fetch_counter += count;
        return rv;
    }

    protected synchronized int next(int bits) {
        int[] parameters = bitTable[bits];
        int offset = this.getBytes(parameters[0]);
        int val = this.output_buffer[offset];
        if (parameters[0] == 4) {
            val += (this.output_buffer[offset + 1] << 24) + (this.output_buffer[offset + 2] << 16) + (this.output_buffer[offset + 3] << 8);
        } else if (parameters[0] == 3) {
            val += (this.output_buffer[offset + 1] << 16) + (this.output_buffer[offset + 2] << 8);
        } else if (parameters[0] == 2) {
            val += this.output_buffer[offset + 2] << 8;
        }
        return val & parameters[1];
    }

    private void accumulator_init(String digest) {
        this.fast_pool = Util.getDigestByName(digest);
        this.slow_pool = Util.getDigestByName(digest);
        this.digestSize = this.fast_pool.digestSize();
        this.entropySeen = new Hashtable();
    }

    public int acceptEntropy(EntropySource source, long data, int entropyGuess) {
        return this.accept_entropy(data, source, Math.min(32, Math.min(this.estimateEntropy(source, data), entropyGuess)));
    }

    private synchronized int accept_entropy(long data, EntropySource source, int actualEntropy) {
        block4: {
            block3: {
                this.fast_select = !this.fast_select;
                Digest pool = this.fast_select ? this.fast_pool : this.slow_pool;
                pool.update((byte)data);
                pool.update((byte)(data >> 8));
                pool.update((byte)(data >> 16));
                pool.update((byte)(data >> 24));
                pool.update((byte)(data >> 32));
                pool.update((byte)(data >> 40));
                pool.update((byte)(data >> 48));
                pool.update((byte)(data >> 56));
                if (!this.fast_select) break block3;
                this.fast_entropy += actualEntropy;
                if (this.fast_entropy <= 100) break block4;
                this.fast_pool_reseed();
                break block4;
            }
            this.slow_entropy += actualEntropy;
            if (source != null) {
                Integer contributedEntropy = (Integer)this.entropySeen.get(source);
                contributedEntropy = contributedEntropy == null ? new Integer(actualEntropy) : new Integer(actualEntropy + contributedEntropy);
                this.entropySeen.put(source, contributedEntropy);
                if (this.slow_entropy >= 320) {
                    int kc = 0;
                    Enumeration enumeration = this.entropySeen.keys();
                    while (enumeration.hasMoreElements()) {
                        Object key = enumeration.nextElement();
                        Integer v = (Integer)this.entropySeen.get(key);
                        logger.fine("Key: <" + key + "> " + v);
                        if (v <= 160 || ++kc < 2) continue;
                        this.slow_pool_reseed();
                        break;
                    }
                }
            }
        }
        logger.fine("Fast pool: " + this.fast_entropy + "\tSlow pool: " + this.slow_entropy);
        return actualEntropy;
    }

    private int estimateEntropy(EntropySource source, long newVal) {
        int delta = (int)(newVal - source.lastVal);
        int delta2 = delta - source.lastDelta;
        source.lastDelta = delta;
        int delta3 = delta2 - source.lastDelta2;
        source.lastDelta2 = delta2;
        if (delta < 0) {
            delta = -delta;
        }
        if (delta2 < 0) {
            delta2 = -delta2;
        }
        if (delta3 < 0) {
            delta3 = -delta3;
        }
        if (delta > delta2) {
            delta = delta2;
        }
        if (delta > delta3) {
            delta = delta3;
        }
        delta >>= 1;
        delta &= 0xFFF;
        delta |= delta >> 8;
        delta |= delta >> 4;
        delta |= delta >> 2;
        delta |= delta >> 1;
        delta >>= 1;
        delta -= delta >> 1 & 0x555;
        delta = (delta & 0x333) + (delta >> 2 & 0x333);
        delta += delta >> 4;
        delta += delta >> 8;
        source.lastVal = newVal;
        return delta & 0xF;
    }

    public int acceptTimerEntropy(EntropySource timer) {
        long now = System.currentTimeMillis();
        return this.acceptEntropy(timer, now - timer.lastVal, 32);
    }

    public void waitForEntropy(int bits) {
    }

    private void reseed_init(String digest) {
        this.reseed_ctx = Util.getDigestByName(digest);
    }

    private void fast_pool_reseed() {
        byte[] v0;
        byte[] vi = v0 = this.fast_pool.digest();
        for (byte i = 0; i < 5; i = (byte)(i + 1)) {
            this.reseed_ctx.update(vi, 0, vi.length);
            this.reseed_ctx.update(v0, 0, v0.length);
            this.reseed_ctx.update(i);
            vi = this.reseed_ctx.digest();
        }
        Util.makeKey(vi, this.tmp, 0, this.tmp.length);
        this.rekey(this.tmp);
        Util.wipe(v0);
        this.fast_entropy = 0;
        this.write_seed(this.seedfile);
    }

    private void slow_pool_reseed() {
        byte[] slow_hash = this.slow_pool.digest();
        this.fast_pool.update(slow_hash, 0, slow_hash.length);
        this.fast_pool_reseed();
        this.slow_entropy = 0;
        Integer ZERO = new Integer(0);
        Enumeration enumeration = this.entropySeen.keys();
        while (enumeration.hasMoreElements()) {
            this.entropySeen.put(enumeration.nextElement(), ZERO);
        }
    }

    public void close() {
    }

    public static void main(String[] args) throws Exception {
        block23: {
            Yarrow r;
            block27: {
                int i;
                block26: {
                    byte[] b;
                    block25: {
                        int i2;
                        block24: {
                            block22: {
                                int i3;
                                r = new Yarrow(new File("/dev/urandom"), "SHA1", "Rijndael");
                                b = new byte[1024];
                                if (args.length != 0 && !args[0].equalsIgnoreCase("latency")) break block22;
                                if (args.length == 2) {
                                    b = new byte[Integer.parseInt(args[1])];
                                }
                                long start = System.currentTimeMillis();
                                for (i3 = 0; i3 < 100; ++i3) {
                                    r.nextBytes(b);
                                }
                                System.out.println((double)(System.currentTimeMillis() - start) / (double)(100 * b.length) * 1024.0 + " ms/k");
                                start = System.currentTimeMillis();
                                for (i3 = 0; i3 < 1000; ++i3) {
                                    r.nextInt();
                                }
                                System.out.println((double)(System.currentTimeMillis() - start) / 1000.0 + " ms/int");
                                start = System.currentTimeMillis();
                                for (i3 = 0; i3 < 1000; ++i3) {
                                    r.nextLong();
                                }
                                System.out.println((double)(System.currentTimeMillis() - start) / 1000.0 + " ms/long");
                                break block23;
                            }
                            if (!args[0].equalsIgnoreCase("randomness")) break block24;
                            int kb = Integer.parseInt(args[1]);
                            for (int i4 = 0; i4 < kb; ++i4) {
                                r.nextBytes(b);
                                System.out.write(b);
                            }
                            break block23;
                        }
                        if (!args[0].equalsIgnoreCase("gathering")) break block25;
                        System.gc();
                        EntropySource t = new EntropySource();
                        long start = System.currentTimeMillis();
                        for (i2 = 0; i2 < 100000; ++i2) {
                            r.acceptEntropy(t, System.currentTimeMillis(), 32);
                        }
                        System.err.println((double)(System.currentTimeMillis() - start) / 100000.0);
                        System.gc();
                        start = System.currentTimeMillis();
                        for (i2 = 0; i2 < 100000; ++i2) {
                            r.acceptTimerEntropy(t);
                        }
                        System.err.println((double)(System.currentTimeMillis() - start) / 100000.0);
                        break block23;
                    }
                    if (!args[0].equalsIgnoreCase("volume")) break block26;
                    b = new byte[1020];
                    long duration = System.currentTimeMillis() + (long)Integer.parseInt(args[1]);
                    while (System.currentTimeMillis() < duration) {
                        r.nextBytes(b);
                        System.out.write(b);
                    }
                    break block23;
                }
                if (args[0].equals("stream")) {
                    RandFile f = new RandFile(args[1]);
                    EntropySource rf = new EntropySource();
                    byte[] buffer = new byte[131072];
                    while (true) {
                        r.acceptEntropy(rf, f.nextLong(), 32);
                        r.nextBytes(buffer);
                        System.out.write(buffer);
                    }
                }
                if (args[0].equalsIgnoreCase("bitstream")) {
                    block8: while (true) {
                        int v = r.nextInt();
                        int i5 = 0;
                        while (true) {
                            if (i5 >= 32) continue block8;
                            if ((v >> i5 & 1) == 1) {
                                System.out.print('1');
                            } else {
                                System.out.print('0');
                            }
                            ++i5;
                        }
                        break;
                    }
                }
                if (!args[0].equalsIgnoreCase("sample")) break block23;
                if (args.length != 1 && !args[1].equals("general")) break block27;
                System.out.println("nextInt(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextInt());
                }
                System.out.println("nextLong(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextLong());
                }
                System.out.println("nextFloat(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextFloat());
                }
                System.out.println("nextDouble(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextDouble());
                }
                System.out.println("nextFullFloat(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextFullFloat());
                }
                System.out.println("nextFullDouble(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextFullDouble());
                }
                break block23;
            }
            if (!args[1].equals("normalized")) break block23;
            for (int i = 0; i < 20; ++i) {
                System.out.println(r.nextDouble());
            }
        }
    }

    private void consumeString(String str) {
        byte[] b = str.getBytes();
        this.consumeBytes(b);
    }

    private void consumeBytes(byte[] bytes) {
        if (this.fast_select) {
            this.fast_pool.update(bytes, 0, bytes.length);
        } else {
            this.slow_pool.update(bytes, 0, bytes.length);
        }
        this.fast_select = !this.fast_select;
    }
}

