/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoKey;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.Util;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSAPublicKey
extends CryptoKey {
    protected final BigInteger y;
    protected final DSAGroup group;

    public DSAPublicKey(DSAGroup g, BigInteger y) {
        this.y = y;
        this.group = g;
    }

    public DSAPublicKey(DSAGroup g, DSAPrivateKey p) {
        this(g, g.getG().modPow(p.getX(), g.getP()));
    }

    public BigInteger getY() {
        return this.y;
    }

    public BigInteger getP() {
        return this.group.getP();
    }

    public BigInteger getQ() {
        return this.group.getQ();
    }

    public BigInteger getG() {
        return this.group.getG();
    }

    public String keyType() {
        return "DSA.p";
    }

    public DSAGroup getGroup() {
        return this.group;
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream o = this.writeWithoutGroup(out);
        this.group.write(out);
    }

    public void writeForWireWithoutGroup(OutputStream out) throws IOException {
        Util.writeMPI(this.y, out);
    }

    public void writeForWire(OutputStream out) throws IOException {
        Util.writeMPI(this.y, out);
        this.group.writeForWire(out);
    }

    public DataOutputStream writeWithoutGroup(OutputStream out) throws IOException {
        DataOutputStream o = this.write(out, this.getClass().getName());
        Util.writeMPI(this.y, o);
        return o;
    }

    public static CryptoKey read(InputStream i) throws IOException {
        BigInteger y = Util.readMPI(i);
        DSAGroup g = (DSAGroup)CryptoKey.read(i);
        return new DSAPublicKey(g, y);
    }

    public int keyId() {
        return this.y.intValue();
    }

    public String writeAsField() {
        return this.y.toString(16);
    }

    public byte[] asBytes() {
        byte[] groupBytes = this.group.asBytes();
        byte[] ybytes = Util.MPIbytes(this.y);
        byte[] bytes = new byte[groupBytes.length + ybytes.length];
        System.arraycopy(groupBytes, 0, bytes, 0, groupBytes.length);
        System.arraycopy(ybytes, 0, bytes, groupBytes.length, ybytes.length);
        return bytes;
    }

    public byte[] fingerprint() {
        return this.fingerprint(new BigInteger[]{this.y});
    }

    public boolean equals(DSAPublicKey o) {
        return this.y.equals(o.y) && this.group.equals(o.group);
    }

    public boolean equals(Object o) {
        return o instanceof DSAPublicKey && this.y.equals(((DSAPublicKey)o).y) && this.group.equals(((DSAPublicKey)o).group);
    }

    public int compareTo(Object other) {
        if (other instanceof DSAPublicKey) {
            return this.getY().compareTo(((DSAPublicKey)other).getY());
        }
        return -1;
    }
}

