/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.PCFBMode;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CipherInputStream
extends FilterInputStream {
    private final PCFBMode ctx;
    private boolean needIV = false;

    public CipherInputStream(BlockCipher c, InputStream in) throws IOException {
        this(new PCFBMode(c), in);
    }

    public CipherInputStream(BlockCipher c, InputStream in, boolean readIV) throws IOException {
        this(new PCFBMode(c), in);
        if (readIV) {
            this.ctx.readIV(this.in);
        }
    }

    public CipherInputStream(BlockCipher c, InputStream in, boolean readIV, boolean later) throws IOException {
        this(new PCFBMode(c), in);
        if (readIV && later) {
            this.needIV = true;
        } else if (readIV) {
            this.ctx.readIV(this.in);
        }
    }

    public CipherInputStream(BlockCipher c, InputStream in, byte[] iv) throws IOException {
        this(new PCFBMode(c, iv), in);
    }

    public CipherInputStream(PCFBMode ctx, InputStream in) throws IOException {
        super(in);
        this.ctx = ctx;
    }

    public int read() throws IOException {
        int rv;
        if (this.needIV) {
            this.ctx.readIV(this.in);
            this.needIV = false;
        }
        return (rv = this.in.read()) == -1 ? -1 : this.ctx.decipher(rv);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int rv;
        if (this.needIV) {
            this.ctx.readIV(this.in);
            this.needIV = false;
        }
        if ((rv = this.in.read(b, off, len)) != -1) {
            this.ctx.blockDecipher(b, off, rv);
            return rv;
        }
        return -1;
    }

    public int available() throws IOException {
        int r = this.in.available();
        return this.needIV ? Math.max(0, r - this.ctx.lengthIV()) : r;
    }
}

