/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model;

import frost.util.model.ModelTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class ModelTableHeader
extends JTableHeader {
    private Listener listener = new Listener();
    private ModelTable modelTable;
    private ColumnsPopupMenu popup;

    public ModelTableHeader(ModelTable newModelTable) {
        super(newModelTable.getTable().getColumnModel());
        this.modelTable = newModelTable;
        this.addMouseListener(this.listener);
    }

    protected void headerClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void headerReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void popupMenu_actionPerformed(int position) {
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)this.popup.getComponent(position);
        if (menuItem.isSelected()) {
            this.modelTable.setColumnVisible(position, true);
        } else {
            this.modelTable.setColumnVisible(position, false);
        }
    }

    private JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new ColumnsPopupMenu();
        }
        return this.popup;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        public void mouseClicked(MouseEvent e) {
            ModelTableHeader.this.headerClicked(e);
        }

        public void mouseReleased(MouseEvent e) {
            ModelTableHeader.this.headerReleased(e);
        }

        public void actionPerformed(ActionEvent e) {
            int position;
            if (ModelTableHeader.this.popup != null && (position = ModelTableHeader.this.popup.getComponentIndex((Component)e.getSource())) != -1) {
                ModelTableHeader.this.popupMenu_actionPerformed(position);
            }
        }
    }

    private class ColumnsPopupMenu
    extends JPopupMenu {
        private ColumnsPopupMenu() {
        }

        public void show(Component invoker, int x, int y) {
            this.removeAll();
            Iterator columns = ModelTableHeader.this.modelTable.getColumns();
            int i = 0;
            int shownColumns = 0;
            JMenuItem lastShownItem = null;
            while (columns.hasNext()) {
                TableColumn column = (TableColumn)columns.next();
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(column.getIdentifier().toString());
                if (ModelTableHeader.this.modelTable.isColumnVisible(i)) {
                    menuItem.setSelected(true);
                    ++shownColumns;
                    lastShownItem = menuItem;
                } else {
                    menuItem.setSelected(false);
                }
                menuItem.addActionListener(ModelTableHeader.this.listener);
                this.add(menuItem);
                ++i;
            }
            if (shownColumns == 1) {
                lastShownItem.setEnabled(false);
            }
            super.show(invoker, x, y);
        }
    }
}

