/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.translation;

import frost.util.gui.translation.FrostResourceBundle;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Language {
    private static final Logger logger = Logger.getLogger(Language.class.getName());
    private FrostResourceBundle RESOURCE_BUNDLE = null;
    private FrostResourceBundle ROOT_RESOURCE_BUNDLE = null;
    private static boolean initialized = false;
    private final MessageFormat formatter = new MessageFormat("");
    private final Object[] objectLen1 = new Object[1];
    private final Object[] objectLen2 = new Object[2];
    private final Object[] objectLen3 = new Object[3];
    private static Language instance = null;
    protected EventListenerList listenerList = new EventListenerList();

    private Language(String localeName, boolean isExternal) {
        this.ROOT_RESOURCE_BUNDLE = new FrostResourceBundle();
        this.RESOURCE_BUNDLE = new FrostResourceBundle(localeName.toLowerCase(), this.ROOT_RESOURCE_BUNDLE, isExternal);
    }

    private Language(File bundleFile) {
        this.RESOURCE_BUNDLE = this.ROOT_RESOURCE_BUNDLE = new FrostResourceBundle(bundleFile);
    }

    public static Language getInstance() {
        return instance;
    }

    public static void initializeWithName(String localeName, boolean isExternal) {
        if (!initialized) {
            initialized = true;
            if (localeName == null) {
                localeName = Locale.getDefault().getCountry();
            }
            instance = new Language(localeName.toLowerCase(), isExternal);
        }
    }

    public static void initializeWithName(String localeName) {
        if (!initialized) {
            Locale locale;
            initialized = true;
            if (localeName == null) {
                locale = Locale.getDefault();
                localeName = Locale.getDefault().getCountry();
            } else {
                locale = new Locale(localeName);
            }
            boolean isExternal = Language.getExternalLocales().contains(locale);
            instance = new Language(localeName.toLowerCase(), isExternal);
        }
    }

    public static void initializeWithFile(File bundleFile) {
        if (!initialized) {
            initialized = true;
            instance = new Language(bundleFile);
        }
    }

    public void addLanguageListener(LanguageListener listener) {
        this.listenerList.add(LanguageListener.class, listener);
    }

    public LanguageListener[] getLanguageListeners() {
        return (LanguageListener[])this.listenerList.getListeners(LanguageListener.class);
    }

    public void removeLanguageListener(LanguageListener listener) {
        this.listenerList.remove(LanguageListener.class, listener);
    }

    protected void fireLanguageChanged(LanguageEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        LanguageEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LanguageListener.class) continue;
            if (e == null) {
                e = new LanguageEvent(this);
            }
            ((LanguageListener)listeners[i + 1]).languageChanged(e);
        }
    }

    public static List<Locale> getExternalLocales() {
        ArrayList<Locale> lst = new ArrayList<Locale>();
        File i18nDir = new File("localdata/i18n");
        if (!i18nDir.isDirectory()) {
            return lst;
        }
        File[] files = new File("localdata/i18n").listFiles();
        if (files == null) {
            return lst;
        }
        for (File f : files) {
            String ln;
            String fname = f.getName();
            if (!fname.startsWith("langres_") || !fname.endsWith(".properties") || (ln = fname.substring("langres_".length(), fname.length() - ".properties".length())).length() != 2) continue;
            lst.add(new Locale(ln));
        }
        return lst;
    }

    public synchronized void changeLanguage(String localeName, boolean isExternal) {
        if (localeName == null) {
            localeName = Locale.getDefault().getLanguage();
        }
        this.RESOURCE_BUNDLE = new FrostResourceBundle(localeName.toLowerCase(), this.ROOT_RESOURCE_BUNDLE, isExternal);
        this.fireLanguageChanged(new LanguageEvent(this));
    }

    public String getString(String origKey) {
        String s;
        try {
            s = this.RESOURCE_BUNDLE.getString(origKey);
        }
        catch (MissingResourceException t) {
            s = null;
        }
        catch (Throwable t) {
            s = null;
            logger.log(Level.SEVERE, "Exception catched", t);
        }
        if (s == null) {
            logger.severe("No translation found for key '" + origKey + "', using key.");
            return origKey;
        }
        return s;
    }

    public synchronized String formatMessage(String msg, Object[] objs) {
        try {
            String pattern = this.getString(msg);
            this.formatter.applyPattern(pattern);
            String output = this.formatter.format(objs);
            return output;
        }
        catch (IllegalArgumentException ex) {
            return '!' + msg + '!';
        }
    }

    public synchronized String formatMessage(String msg, Object obj1) {
        this.objectLen1[0] = obj1;
        return this.formatMessage(msg, this.objectLen1);
    }

    public synchronized String formatMessage(String msg, Object obj1, Object obj2) {
        this.objectLen2[0] = obj1;
        this.objectLen2[1] = obj2;
        return this.formatMessage(msg, this.objectLen2);
    }

    public synchronized String formatMessage(String msg, Object obj1, Object obj2, Object obj3) {
        this.objectLen3[0] = obj1;
        this.objectLen3[1] = obj2;
        this.objectLen3[2] = obj3;
        return this.formatMessage(msg, this.objectLen3);
    }
}

