/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.translation;

import frost.util.gui.translation.FrostResourceBundleReader;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrostResourceBundle {
    private static final String BUILDIN_BUNDLE_NAME = "/i18n/langres";
    protected static final String EXTERNAL_BUNDLE_DIR = "localdata/i18n/";
    protected Map<String, String> bundle;
    protected FrostResourceBundle parentBundle = null;

    public FrostResourceBundle() {
        String resource = "/i18n/langres.properties";
        this.bundle = FrostResourceBundleReader.loadBundle("/i18n/langres.properties");
    }

    public FrostResourceBundle getParentBundle() {
        return this.parentBundle;
    }

    public FrostResourceBundle(String localeName, FrostResourceBundle parent, boolean isExternal) {
        this.parentBundle = parent;
        if (localeName.length() == 0) {
            this.bundle = new HashMap<String, String>();
        } else if (!isExternal) {
            String resource = "/i18n/langres_" + localeName + ".properties";
            this.bundle = FrostResourceBundleReader.loadBundle(resource);
        } else {
            String filename = "localdata/i18n/langres_" + localeName + ".properties";
            File file = new File(filename);
            this.bundle = file.isFile() ? FrostResourceBundleReader.loadBundle(file) : new HashMap<String, String>();
        }
    }

    public FrostResourceBundle(File bundleFile) {
        this.bundle = FrostResourceBundleReader.loadBundle(bundleFile);
    }

    public FrostResourceBundle(File bundleFile, FrostResourceBundle parent) {
        this.parentBundle = parent;
        this.bundle = FrostResourceBundleReader.loadBundle(bundleFile);
    }

    public String getString(String key) throws MissingResourceException {
        String value = this.bundle.get(key);
        if (value == null) {
            if (this.parentBundle != null) {
                value = this.parentBundle.getString(key);
            } else {
                throw new MissingResourceException("Key is missing: '" + key + "'", "FrostResourceBundle", key);
            }
        }
        return value;
    }

    public Collection<String> getKeys() {
        return this.bundle.keySet();
    }
}

