/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.ImmutableArea;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;

public class ImmutableAreasDocument
extends PlainDocument {
    private final ArrayList<ImmutableArea> immutableAreas = new ArrayList();
    private final MessageFilter filter = new MessageFilter();

    public ImmutableAreasDocument() {
        this.setDocumentFilter(this.filter);
    }

    public void addImmutableArea(ImmutableArea newArea) {
        this.immutableAreas.add(newArea);
    }

    public void removeImmutableArea(ImmutableArea area) {
        this.immutableAreas.remove(area);
    }

    public ImmutableAreasDocument(AbstractDocument.Content c) {
        super(c);
        this.setDocumentFilter(this.filter);
    }

    private class MessageFilter
    extends DocumentFilter {
        public static final int CLIPPING_OUTSIDE = 0;
        public static final int CLIPPING_INSIDE = 1;
        public static final int CLIPPING_BOTH_SIDES = 2;
        public static final int CLIPPING_LEFT = 3;
        public static final int CLIPPING_RIGHT = 4;

        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            boolean allowReplace = true;
            boolean noAreasEnabled = true;
            Iterator areas = ImmutableAreasDocument.this.immutableAreas.iterator();
            while (areas.hasNext() && allowReplace) {
                int newLength;
                ImmutableArea area = (ImmutableArea)areas.next();
                if (!area.isEnabled()) continue;
                int clippingValue = length == 0 ? this.clip(area, offset, length, false) : this.clip(area, offset, length, true);
                int endOffset = offset + length;
                Position position = ImmutableAreasDocument.this.createPosition(offset);
                Position endPosition = ImmutableAreasDocument.this.createPosition(endOffset);
                if (clippingValue != 0) {
                    noAreasEnabled = false;
                }
                if (clippingValue == 3 || clippingValue == 2) {
                    int newStringLength = text.length() - (endOffset - area.getStartPos());
                    if (newStringLength >= (newLength = area.getStartPos() - offset)) {
                        fb.replace(offset, newLength, this.substring(text, 0, newStringLength), attrs);
                    } else {
                        fb.replace(offset, newLength, this.substring(text, 0, newLength), attrs);
                    }
                }
                if (clippingValue == 4 || clippingValue == 2) {
                    int newStart = area.getEndPos() - position.getOffset();
                    newLength = endPosition.getOffset() - area.getEndPos();
                    if (newStart >= text.length()) {
                        fb.replace(area.getEndPos(), newLength, "", attrs);
                    } else {
                        fb.replace(area.getEndPos(), newLength, text.substring(newStart), attrs);
                    }
                }
                allowReplace = false;
            }
            if (noAreasEnabled) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            boolean noAreasEnabled = true;
            boolean allowInsert = true;
            Iterator areas = ImmutableAreasDocument.this.immutableAreas.iterator();
            while (areas.hasNext() && allowInsert) {
                int clippingValue;
                ImmutableArea area = (ImmutableArea)areas.next();
                if (!area.isEnabled() || (clippingValue = this.clip(area, offset, string.length(), false)) == 0) continue;
                noAreasEnabled = false;
                allowInsert = false;
            }
            if (noAreasEnabled) {
                super.insertString(fb, offset, string, attr);
            }
        }

        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            boolean allowRemove = true;
            boolean noAreasEnabled = true;
            Iterator areas = ImmutableAreasDocument.this.immutableAreas.iterator();
            while (areas.hasNext() && allowRemove) {
                int newLength;
                ImmutableArea area = (ImmutableArea)areas.next();
                if (!area.isEnabled()) continue;
                int clippingValue = this.clip(area, offset, length, true);
                int endOffset = offset + length;
                Position endPosition = ImmutableAreasDocument.this.createPosition(endOffset);
                if (clippingValue != 0) {
                    noAreasEnabled = false;
                }
                if (clippingValue == 3 || clippingValue == 2) {
                    newLength = area.getStartPos() - offset;
                    fb.remove(offset, newLength);
                }
                if (clippingValue == 4 || clippingValue == 2) {
                    newLength = endPosition.getOffset() - area.getEndPos();
                    fb.remove(area.getEndPos(), newLength);
                }
                allowRemove = false;
            }
            if (noAreasEnabled) {
                super.remove(fb, offset, length);
            }
        }

        private int clip(ImmutableArea area, int offset, int length, boolean isRemoving) {
            int endOffset = offset + length;
            boolean offsetOutsideLeft = false;
            boolean offsetOutsideRight = false;
            boolean endOffsetOutsideLeft = false;
            boolean endOffsetOutsideRight = false;
            if (isRemoving) {
                if (offset < area.getStartPos()) {
                    offsetOutsideLeft = true;
                } else if (offset >= area.getEndPos()) {
                    offsetOutsideRight = true;
                }
                if (endOffset < area.getStartPos()) {
                    endOffsetOutsideLeft = true;
                } else if (endOffset >= area.getEndPos()) {
                    endOffsetOutsideRight = true;
                }
            } else {
                if (offset <= area.getStartPos()) {
                    offsetOutsideLeft = true;
                } else if (offset >= area.getEndPos()) {
                    offsetOutsideRight = true;
                }
                if (endOffset <= area.getStartPos()) {
                    endOffsetOutsideLeft = true;
                } else if (endOffset >= area.getEndPos()) {
                    endOffsetOutsideRight = true;
                }
            }
            if (offsetOutsideLeft) {
                if (endOffsetOutsideLeft) {
                    return 0;
                }
                if (endOffsetOutsideRight) {
                    return 2;
                }
                return 3;
            }
            if (offsetOutsideRight) {
                return 0;
            }
            if (endOffsetOutsideRight) {
                return 4;
            }
            return 1;
        }

        private String substring(String text, int beginIndex, int endIndex) {
            if (beginIndex < 0) {
                beginIndex = 0;
            }
            if (endIndex > text.length()) {
                endIndex = text.length();
            }
            return text.substring(beginIndex, endIndex);
        }
    }
}

