/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.Core;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class AbstractMessageStatusProvider
extends DefaultMutableTreeNode {
    private static final Logger logger = Logger.getLogger(AbstractMessageStatusProvider.class.getName());
    private static final int xGOOD = 1;
    private static final int xCHECK = 2;
    private static final int xBAD = 3;
    private static final int xOBSERVE = 4;
    private static final int xTAMPERED = 5;
    private static final int xOLD = 6;
    private static String[] messageStateStrings = new String[]{"*err*", "GOOD", "CHECK", "BAD", "OBSERVE", "FAKE", "NONE"};
    private static final int SIGNATURESTATUS_UNSET = 0;
    private static final int SIGNATURESTATUS_TAMPERED = 1;
    private static final int SIGNATURESTATUS_OLD = 2;
    private static final int SIGNATURESTATUS_VERIFIED = 3;
    private static final int SIGNATURESTATUS_VERIFIED_V1 = 4;
    private static final int SIGNATURESTATUS_VERIFIED_V2 = 5;
    private static final String SIGNATURESTATUS_TAMPERED_STR = "TAMPERED";
    private static final String SIGNATURESTATUS_OLD_STR = "OLD";
    private static final String SIGNATURESTATUS_VERIFIED_STR = "VERIFIED";
    private boolean isFromIdentityInitialized = false;
    private Identity fromIdentity = null;
    private String fromName = "";
    private String publicKey = "";
    private int signatureStatus = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity getFromIdentity() {
        if (!this.isFromIdentityInitialized) {
            if (this.getFromName() == null || this.getFromName().length() == 0) {
                this.fromIdentity = null;
            } else {
                Object object = Core.getIdentities().getLockObject();
                synchronized (object) {
                    this.fromIdentity = Core.getIdentities().getIdentity(this.getFromName());
                    if (this.fromIdentity == null && this.getPublicKey() != null && this.getPublicKey().length() > 0) {
                        this.fromIdentity = Identity.createIdentityFromExactStrings(this.getFromName(), this.getPublicKey());
                        Core.getIdentities().addIdentity(this.fromIdentity);
                    }
                }
            }
            this.isFromIdentityInitialized = true;
        }
        return this.fromIdentity;
    }

    public void setFromIdentity(Identity id) {
        if (this.isFromIdentityInitialized) {
            logger.severe("Already initialized, old=" + this.fromIdentity + "; new=" + id);
        } else {
            this.fromIdentity = id;
            this.isFromIdentityInitialized = true;
        }
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String from) {
        this.fromName = from;
    }

    public boolean setSignatureStatusFromString(String sigStatusStr) {
        if (sigStatusStr.equalsIgnoreCase(SIGNATURESTATUS_VERIFIED_STR)) {
            this.setSignatureStatusVERIFIED_V1();
            return true;
        }
        if (sigStatusStr.equalsIgnoreCase(SIGNATURESTATUS_OLD_STR)) {
            this.setSignatureStatusOLD();
            return true;
        }
        if (sigStatusStr.equalsIgnoreCase(SIGNATURESTATUS_TAMPERED_STR)) {
            this.setSignatureStatusTAMPERED();
            return true;
        }
        return false;
    }

    private int getMessageStatus(Identity fromIdent) {
        if (this.isSignatureStatusVERIFIED()) {
            if (fromIdent == null) {
                return 6;
            }
            if (fromIdent.isCHECK()) {
                return 2;
            }
            if (fromIdent.isOBSERVE()) {
                return 4;
            }
            if (fromIdent.isGOOD()) {
                return 1;
            }
            if (fromIdent.isBAD()) {
                return 3;
            }
        } else {
            if (this.isSignatureStatusOLD()) {
                return 6;
            }
            if (this.isSignatureStatusTAMPERED()) {
                return 5;
            }
        }
        return 6;
    }

    private int getMessageStatus() {
        return this.getMessageStatus(this.getFromIdentity());
    }

    public String getMessageStatusString() {
        Identity i = this.getFromIdentity();
        if (i instanceof LocalIdentity && !Core.frostSettings.getBoolValue("showOwnMessagesAsMeDisabled")) {
            return "ME";
        }
        return messageStateStrings[this.getMessageStatus(i)];
    }

    public boolean isMessageFromME() {
        Identity i = this.getFromIdentity();
        return i instanceof LocalIdentity;
    }

    public boolean isMessageStatusGOOD() {
        return this.getMessageStatus() == 1;
    }

    public boolean isMessageStatusOBSERVE() {
        return this.getMessageStatus() == 4;
    }

    public boolean isMessageStatusCHECK() {
        return this.getMessageStatus() == 2;
    }

    public boolean isMessageStatusBAD() {
        return this.getMessageStatus() == 3;
    }

    public boolean isMessageStatusTAMPERED() {
        return this.getMessageStatus() == 5;
    }

    public boolean isMessageStatusOLD() {
        return this.getMessageStatus() == 6;
    }

    public boolean isSignatureStatusVERIFIED() {
        return this.getSignatureStatus() == 3 || this.getSignatureStatus() == 4 || this.getSignatureStatus() == 5;
    }

    public static boolean isSignatureStatusVERIFIED(int sigstat) {
        return sigstat == 3 || sigstat == 4 || sigstat == 5;
    }

    public boolean isSignatureStatusVERIFIED_V1() {
        return this.getSignatureStatus() == 4;
    }

    public boolean isSignatureStatusVERIFIED_V2() {
        return this.getSignatureStatus() == 5;
    }

    public boolean isSignatureStatusOLD() {
        return this.getSignatureStatus() == 2;
    }

    public boolean isSignatureStatusTAMPERED() {
        return this.getSignatureStatus() == 1;
    }

    public void setSignatureStatusVERIFIED_V1() {
        this.signatureStatus = 4;
    }

    public void setSignatureStatusVERIFIED_V2() {
        this.signatureStatus = 5;
    }

    public void setSignatureStatusOLD() {
        this.signatureStatus = 2;
    }

    public void setSignatureStatusTAMPERED() {
        this.signatureStatus = 1;
    }

    public int getSignatureStatus() {
        return this.signatureStatus;
    }

    public void setSignatureStatus(int s) {
        this.signatureStatus = s;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String pk) {
        this.publicKey = pk;
    }
}

