/*
 * Decompiled with CFR 0.152.
 */
package frost.identities;

import frost.Core;
import frost.identities.LocalIdentity;
import frost.storage.AutoSavable;
import frost.storage.ExitSavable;
import frost.storage.LocalIdentitiesXmlDAO;
import frost.storage.StorageException;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;

public class IdentityAutoBackupTask
implements AutoSavable,
ExitSavable {
    private static final Logger logger = Logger.getLogger(IdentityAutoBackupTask.class.getName());

    public void exitSave() throws StorageException {
        this.backupLocalIdentities();
    }

    public void autoSave() throws StorageException {
        this.backupLocalIdentities();
    }

    private void backupLocalIdentities() {
        if (!Core.frostSettings.getBoolValue("autoSaveLocalIdentities")) {
            return;
        }
        String newName = Core.frostSettings.getValue("localdata.dir") + "localIdentitiesBackup.new";
        String xmlName = Core.frostSettings.getValue("localdata.dir") + "localIdentitiesBackup.xml";
        String bakName = Core.frostSettings.getValue("localdata.dir") + "localIdentitiesBackup.bak";
        String oldName = Core.frostSettings.getValue("localdata.dir") + "localIdentitiesBackup.old";
        File newFile = new File(newName);
        File xmlFile = new File(xmlName);
        File bakFile = new File(bakName);
        File oldFile = new File(oldName);
        List<LocalIdentity> lIds = Core.getIdentities().getLocalIdentities();
        boolean wasOk = LocalIdentitiesXmlDAO.saveLocalIdentities(newFile, lIds);
        if (!wasOk) {
            logger.severe("Failed to backup the local identities!");
            return;
        }
        oldFile.delete();
        if (bakFile.isFile()) {
            bakFile.renameTo(oldFile);
        }
        if (xmlFile.isFile()) {
            xmlFile.renameTo(bakFile);
        }
        newFile.renameTo(xmlFile);
        oldFile.delete();
    }
}

