/*
 * Decompiled with CFR 0.152.
 */
package frost.identities;

import frost.Core;
import frost.identities.LocalIdentity;
import frost.messages.BoardAttachment;
import frost.storage.perst.identities.IdentitiesStorage;
import frost.util.Mixed;
import frost.util.XMLTools;
import frost.util.XMLizable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.garret.perst.Persistent;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Identity
extends Persistent
implements XMLizable {
    private static final transient Logger logger = Logger.getLogger(Identity.class.getName());
    private static final transient int GOOD = 1;
    private static final transient int CHECK = 2;
    private static final transient int OBSERVE = 3;
    private static final transient int BAD = 4;
    private static final transient String GOOD_STRING = "GOOD";
    private static final transient String CHECK_STRING = "CHECK";
    private static final transient String OBSERVE_STRING = "OBSERVE";
    private static final transient String BAD_STRING = "BAD";
    private String uniqueName;
    private long lastSeenTimestamp = -1L;
    private int receivedMessageCount = 0;
    private int state = 2;
    private transient String stateString = "CHECK";
    private transient String publicKey;
    private PerstIdentityPublicKey pPublicKey;

    public Identity() {
    }

    protected Identity(Element el) throws Exception {
        try {
            this.loadXMLElement(el);
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", e);
        }
    }

    protected Identity(String name, String key) {
        this.publicKey = key;
        this.uniqueName = name;
    }

    public Identity(String uname, String pubkey, long lseen, int s) {
        this.uniqueName = uname;
        this.publicKey = pubkey;
        this.lastSeenTimestamp = lseen;
        this.state = s;
        this.updateStateString();
        this.uniqueName = Mixed.makeFilename(this.uniqueName);
    }

    public Identity(LocalIdentity li) {
        this.uniqueName = li.getUniqueName();
        this.publicKey = li.getPublicKey();
        this.lastSeenTimestamp = li.getLastSeenTimestamp();
        this.receivedMessageCount = li.getReceivedMessageCount();
        this.updateStateString();
    }

    protected Identity(String name, String key, boolean createNew) {
        if (name.indexOf("@") < 0) {
            name = name + "@" + Core.getCrypto().digest(key);
        }
        name = Mixed.makeFilename(name);
        this.publicKey = key;
        this.uniqueName = name;
    }

    public static Identity createIdentityFromExactStrings(String name, String key) {
        return new Identity(name, key);
    }

    public static Identity createIdentityFromXmlElement(Element el) {
        try {
            return new Identity(el);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean recursiveLoading() {
        return false;
    }

    public void deallocate() {
        if (this.pPublicKey != null) {
            this.pPublicKey.deallocate();
            this.pPublicKey = null;
        }
        super.deallocate();
    }

    public void onStore() {
        if (this.pPublicKey == null && this.publicKey != null) {
            this.pPublicKey = new PerstIdentityPublicKey(this.publicKey);
        }
    }

    public void onLoad() {
        this.updateStateString();
    }

    public Element getXMLElement(Document doc) {
        Element el = doc.createElement("Identity");
        Element element = doc.createElement("name");
        CDATASection cdata = doc.createCDATASection(this.getUniqueName());
        element.appendChild(cdata);
        el.appendChild(element);
        element = doc.createElement("key");
        cdata = doc.createCDATASection(this.getPublicKey());
        element.appendChild(cdata);
        el.appendChild(element);
        return el;
    }

    public Element getXMLElement_old(Document doc) {
        Element el = doc.createElement("MyIdentity");
        Element element = doc.createElement("name");
        CDATASection cdata = doc.createCDATASection(this.getUniqueName());
        element.appendChild(cdata);
        el.appendChild(element);
        element = doc.createElement("key");
        cdata = doc.createCDATASection(this.getPublicKey());
        element.appendChild(cdata);
        el.appendChild(element);
        return el;
    }

    public Element getExportXMLElement(Document doc) {
        Text txt;
        Element element;
        Element el = this.getXMLElement(doc);
        if (this.getLastSeenTimestamp() > -1L) {
            element = doc.createElement("lastSeen");
            txt = doc.createTextNode(Long.toString(this.getLastSeenTimestamp()));
            element.appendChild(txt);
            el.appendChild(element);
        }
        if (this.getReceivedMessageCount() > -1) {
            element = doc.createElement("messageCount");
            txt = doc.createTextNode(Long.toString(this.getReceivedMessageCount()));
            element.appendChild(txt);
            el.appendChild(element);
        }
        return el;
    }

    public void loadXMLElement(Element e) throws SAXException {
        this.uniqueName = XMLTools.getChildElementsCDATAValue(e, "name");
        this.publicKey = XMLTools.getChildElementsCDATAValue(e, "key");
        String lastSeenStr = XMLTools.getChildElementsTextValue(e, "lastSeen");
        this.lastSeenTimestamp = lastSeenStr != null && (lastSeenStr = lastSeenStr.trim()).length() > 0 ? Long.parseLong(lastSeenStr) : System.currentTimeMillis();
        String msgCount = XMLTools.getChildElementsTextValue(e, "messageCount");
        this.receivedMessageCount = msgCount != null && (msgCount = msgCount.trim()).length() > 0 ? Integer.parseInt(msgCount) : 0;
    }

    public String getPublicKey() {
        if (this.publicKey == null && this.pPublicKey != null) {
            this.pPublicKey.load();
            return this.pPublicKey.getPublicKey();
        }
        return this.publicKey;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void correctUniqueName() {
        this.uniqueName = Mixed.makeFilename(this.uniqueName);
    }

    public static boolean isForbiddenBoardAttachment(BoardAttachment ba) {
        return ba != null && ba.getBoardObj().getPublicKey() != null && ba.getBoardObj().getPublicKey().startsWith("SSK@");
    }

    public long getLastSeenTimestamp() {
        return this.lastSeenTimestamp;
    }

    public void setLastSeenTimestamp(long v) {
        this.lastSeenTimestamp = v;
        this.updateIdentitiesStorage();
    }

    public void setLastSeenTimestampWithoutUpdate(long v) {
        this.lastSeenTimestamp = v;
    }

    public int getState() {
        return this.state;
    }

    public String toString() {
        return this.getUniqueName();
    }

    public boolean isGOOD() {
        return this.state == 1;
    }

    public boolean isCHECK() {
        return this.state == 2;
    }

    public boolean isOBSERVE() {
        return this.state == 3;
    }

    public boolean isBAD() {
        return this.state == 4;
    }

    public void setGOOD() {
        this.state = 1;
        this.updateStateString();
        this.updateIdentitiesStorage();
    }

    public void setCHECK() {
        this.state = 2;
        this.updateStateString();
        this.updateIdentitiesStorage();
    }

    public void setOBSERVE() {
        this.state = 3;
        this.updateStateString();
        this.updateIdentitiesStorage();
    }

    public void setBAD() {
        this.state = 4;
        this.updateStateString();
        this.updateIdentitiesStorage();
    }

    public void setGOODWithoutUpdate() {
        this.state = 1;
        this.updateStateString();
    }

    public void setCHECKWithoutUpdate() {
        this.state = 2;
        this.updateStateString();
    }

    public void setOBSERVEWithoutUpdate() {
        this.state = 3;
        this.updateStateString();
    }

    public void setBADWithoutUpdate() {
        this.state = 4;
        this.updateStateString();
    }

    private void updateStateString() {
        this.stateString = this.isCHECK() ? CHECK_STRING : (this.isOBSERVE() ? OBSERVE_STRING : (this.isGOOD() ? GOOD_STRING : (this.isBAD() ? BAD_STRING : "*ERR*")));
    }

    public String getStateString() {
        return this.stateString;
    }

    protected boolean updateIdentitiesStorage() {
        if (!IdentitiesStorage.inst().beginExclusiveThreadTransaction()) {
            return false;
        }
        this.modify();
        IdentitiesStorage.inst().endThreadTransaction();
        return true;
    }

    public int getReceivedMessageCount() {
        return this.receivedMessageCount;
    }

    public void setReceivedMessageCount(int i) {
        this.receivedMessageCount = i;
    }

    public void incReceivedMessageCount() {
        ++this.receivedMessageCount;
        this.updateIdentitiesStorage();
    }

    class PerstIdentityPublicKey
    extends Persistent {
        private String perstPublicKey;

        public PerstIdentityPublicKey() {
        }

        public PerstIdentityPublicKey(String pk) {
            this.perstPublicKey = pk;
        }

        public String getPublicKey() {
            return this.perstPublicKey;
        }

        public boolean recursiveLoading() {
            return false;
        }
    }
}

