/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.fcp.FcpHandler;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class UploadPanel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private final JLabel htlExplanationLabel = new JLabel();
    private final JLabel htlLabel = new JLabel();
    private final JTextField htlTextField = new JTextField(6);
    private final JLabel splitfileThreadsExplanationLabel = new JLabel();
    private final JLabel splitfileThreadsLabel = new JLabel();
    private final JTextField splitfileThreadsTextField = new JTextField(6);
    private final JLabel priorityLabel = new JLabel();
    private final JTextField priorityTextField = new JTextField(6);
    private final JLabel maxRetriesLabel = new JLabel();
    private final JTextField maxRetriesTextField = new JTextField(6);
    private final JLabel waitTimeLabel = new JLabel();
    private final JTextField waitTimeTextField = new JTextField(6);
    private final JLabel threadsLabel = new JLabel();
    private final JTextField threadsTextField = new JTextField(6);
    private final JCheckBox logUploadsCheckBox = new JCheckBox();

    protected UploadPanel(SettingsClass settings) {
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
    }

    private void initialize() {
        this.setName("UploadPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.htlTextField, this.language);
        new TextComponentClipboardMenu(this.splitfileThreadsTextField, this.language);
        new TextComponentClipboardMenu(this.threadsTextField, this.language);
        new TextComponentClipboardMenu(this.maxRetriesTextField, this.language);
        new TextComponentClipboardMenu(this.waitTimeTextField, this.language);
        GridBagConstraints constraints = new GridBagConstraints();
        Insets insets0555 = new Insets(0, 5, 5, 5);
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.insets = insets0555;
        constraints.anchor = 17;
        constraints.gridx = 0;
        this.add((Component)this.maxRetriesLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.maxRetriesTextField, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.waitTimeLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.waitTimeTextField, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.threadsLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.threadsTextField, constraints);
        if (FcpHandler.isFreenet07()) {
            ++constraints.gridy;
            constraints.gridx = 0;
            this.add((Component)this.priorityLabel, constraints);
            constraints.gridx = 1;
            this.add((Component)this.priorityTextField, constraints);
        } else {
            ++constraints.gridy;
            constraints.gridx = 0;
            this.add((Component)this.htlLabel, constraints);
            constraints.gridx = 1;
            this.add((Component)this.htlTextField, constraints);
            constraints.gridx = 2;
            this.add((Component)this.htlExplanationLabel, constraints);
            ++constraints.gridy;
            constraints.gridx = 0;
            this.add((Component)this.splitfileThreadsLabel, constraints);
            constraints.gridx = 1;
            this.add((Component)this.splitfileThreadsTextField, constraints);
            constraints.gridx = 2;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            this.add((Component)this.splitfileThreadsExplanationLabel, constraints);
        }
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        this.add((Component)this.logUploadsCheckBox, constraints);
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(""), constraints);
    }

    private void loadSettings() {
        if (FcpHandler.isFreenet07()) {
            this.priorityTextField.setText(this.settings.getValue("fcp2.defaultPriorityFileUpload"));
        } else {
            this.htlTextField.setText(this.settings.getValue("htlUpload"));
            this.splitfileThreadsTextField.setText(this.settings.getValue("splitfileUploadThreads"));
        }
        this.threadsTextField.setText(this.settings.getValue("uploadThreads"));
        this.maxRetriesTextField.setText("" + this.settings.getIntValue("uploadMaxRetries"));
        this.waitTimeTextField.setText("" + this.settings.getIntValue("uploadRetriesWaitTime"));
        this.logUploadsCheckBox.setSelected(this.settings.getBoolValue("logUploads"));
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        String minutes = this.language.getString("Options.common.minutes");
        this.waitTimeLabel.setText(this.language.getString("Options.uploads.waittimeAfterEachTry") + " (" + minutes + ")");
        this.maxRetriesLabel.setText(this.language.getString("Options.uploads.maximumNumberOfRetries"));
        this.threadsLabel.setText(this.language.getString("Options.uploads.numberOfSimultaneousUploads") + " (3)");
        this.logUploadsCheckBox.setText(this.language.getString("Options.uploads.logUploads"));
        if (FcpHandler.isFreenet07()) {
            this.priorityLabel.setText(this.language.getString("Options.uploads.uploadPriority") + " (3)");
        } else {
            this.htlLabel.setText(this.language.getString("Options.uploads.uploadHtl") + " (21)");
            this.htlExplanationLabel.setText(this.language.getString("Options.uploads.uploadHtlExplanation"));
            this.splitfileThreadsLabel.setText(this.language.getString("Options.uploads.numberOfSplitfileThreads") + " (15)");
            this.splitfileThreadsExplanationLabel.setText(this.language.getString("Options.uploads.numberOfSplitfileThreadsExplanation"));
        }
    }

    private void saveSettings() {
        if (FcpHandler.isFreenet07()) {
            this.settings.setValue("fcp2.defaultPriorityFileUpload", this.priorityTextField.getText());
        } else {
            this.settings.setValue("htlUpload", this.htlTextField.getText());
            this.settings.setValue("splitfileUploadThreads", this.splitfileThreadsTextField.getText());
        }
        this.settings.setValue("uploadThreads", this.threadsTextField.getText());
        this.settings.setValue("uploadMaxRetries", this.maxRetriesTextField.getText());
        this.settings.setValue("uploadRetriesWaitTime", this.waitTimeTextField.getText());
        this.settings.setValue("logUploads", this.logUploadsCheckBox.isSelected());
    }
}

