/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.messagetreetable;

import frost.gui.messagetreetable.MessageTreeTable;
import frost.gui.messagetreetable.MessageTreeTableSortStateBean;
import frost.util.gui.MiscToolkit;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MessageTreeTableHeader
extends JTableHeader {
    private final MessageTreeTable messageTreeTable;
    private static Icon ascendingIcon = MiscToolkit.loadImageIcon("/data/SortedTable_ascending.png");
    private static Icon descendingIcon = MiscToolkit.loadImageIcon("/data/SortedTable_descending.png");
    private final ArrowRenderer arrowRenderer = new ArrowRenderer();

    public MessageTreeTableHeader(MessageTreeTable t) {
        super(t.getColumnModel());
        this.messageTreeTable = t;
        this.addMouseListener(new Listener());
        Enumeration<TableColumn> enumeration = this.messageTreeTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn column = enumeration.nextElement();
            column.setHeaderRenderer(this.arrowRenderer);
        }
    }

    protected void headerClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            if (MessageTreeTableSortStateBean.isThreaded()) {
                return;
            }
            TableColumnModel lColumnModel = this.getTable().getColumnModel();
            int columnNumber = lColumnModel.getColumnIndexAtX(e.getX());
            if (columnNumber != -1) {
                int modelIndex = lColumnModel.getColumn(columnNumber).getModelIndex();
                if (MessageTreeTableSortStateBean.getSortedColumn() == modelIndex) {
                    MessageTreeTableSortStateBean.setAscending(!MessageTreeTableSortStateBean.isAscending());
                } else {
                    MessageTreeTableSortStateBean.setSortedColumn(modelIndex);
                }
                this.messageTreeTable.resortTable();
            }
        }
    }

    private class ArrowRenderer
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable lTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer defaultRenderer = lTable.getTableHeader().getDefaultRenderer();
            if (defaultRenderer instanceof JLabel) {
                JLabel labelRenderer = (JLabel)((Object)defaultRenderer);
                int modelIndex = lTable.getColumnModel().getColumn(column).getModelIndex();
                if (MessageTreeTableSortStateBean.isThreaded()) {
                    labelRenderer.setIcon(null);
                } else if (MessageTreeTableSortStateBean.getSortedColumn() == modelIndex) {
                    if (MessageTreeTableSortStateBean.isAscending()) {
                        labelRenderer.setIcon(ascendingIcon);
                    } else {
                        labelRenderer.setIcon(descendingIcon);
                    }
                    labelRenderer.setHorizontalTextPosition(10);
                } else {
                    labelRenderer.setIcon(null);
                }
                labelRenderer.setToolTipText(value.toString());
            }
            return defaultRenderer.getTableCellRendererComponent(lTable, value, isSelected, hasFocus, row, column);
        }
    }

    private class Listener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            MessageTreeTableHeader.this.headerClicked(e);
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

