/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.MainFrame;
import frost.SettingsClass;
import frost.boards.AbstractNode;
import frost.boards.Board;
import frost.boards.TOF;
import frost.gui.MessageFrame;
import frost.gui.MessageTextPane;
import frost.gui.MessageWindow;
import frost.gui.messagetreetable.MessageTreeTable;
import frost.gui.messagetreetable.MessageTreeTableModel;
import frost.gui.messagetreetable.TreeTableModelAdapter;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.messages.FrostMessageObject;
import frost.storage.perst.messages.MessageStorage;
import frost.util.CopyToClipboard;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.search.TableFindAction;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePanel
extends JPanel
implements PropertyChangeListener {
    private MessageTreeTable messageTable = null;
    private MessageTextPane messageTextPane = null;
    private JScrollPane messageListScrollPane = null;
    private JSplitPane msgTableAndMsgTextSplitpane = null;
    private final JLabel subjectLabel = new JLabel();
    private final JLabel subjectTextLabel = new JLabel();
    private boolean indicateLowReceivedMessages;
    private int indicateLowReceivedMessagesCountRed;
    private int indicateLowReceivedMessagesCountLightRed;
    MainFrame mainFrame;
    private final Logger logger = Logger.getLogger(MessagePanel.class.getName());
    private final SettingsClass settings;
    private final Language language = Language.getInstance();
    private FrostIdentities identities;
    private JFrame parentFrame;
    private boolean initialized = false;
    private final Listener listener = new Listener();
    private FrostMessageObject selectedMessage;
    private PopupMenuMessageTable popupMenuMessageTable = null;
    private PopupMenuSubjectText popupMenuSubjectText = null;
    private final JButton newMessageButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/mail-message-new.png"));
    private final JButton replyButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/mail-reply-sender.png"));
    private final JButton saveMessageButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/document-save-as.png"));
    protected JButton nextUnreadMessageButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/go-next.png"));
    private final JButton updateBoardButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/view-refresh.png"));
    private final JButton setGoodButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/weather-clear.png"));
    private final JButton setObserveButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/weather-few-clouds.png"));
    private final JButton setCheckButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/weather-overcast.png"));
    private final JButton setBadButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/weather-storm.png"));
    private final JToggleButton toggleShowUnreadOnly = new JToggleButton("");
    private final JToggleButton toggleShowThreads = new JToggleButton("");
    private final JToggleButton toggleShowSmileys = new JToggleButton("");
    private final JToggleButton toggleShowHyperlinks = new JToggleButton("");
    private String allMessagesCountPrefix = "";
    private final JLabel allMessagesCountLabel = new JLabel("");
    private String newMessagesCountPrefix = "";
    private final JLabel newMessagesCountLabel = new JLabel("");

    public MessagePanel(SettingsClass settings, MainFrame mf) {
        this.settings = settings;
        this.mainFrame = mf;
    }

    private JToolBar getButtonsToolbar() {
        MiscToolkit.configureButton(this.newMessageButton, "MessagePane.toolbar.tooltip.newMessage", this.language);
        MiscToolkit.configureButton(this.updateBoardButton, "MessagePane.toolbar.tooltip.update", this.language);
        MiscToolkit.configureButton(this.replyButton, "MessagePane.toolbar.tooltip.reply", this.language);
        MiscToolkit.configureButton(this.saveMessageButton, "MessagePane.toolbar.tooltip.saveMessage", this.language);
        MiscToolkit.configureButton(this.nextUnreadMessageButton, "MessagePane.toolbar.tooltip.nextUnreadMessage", this.language);
        MiscToolkit.configureButton(this.setGoodButton, "MessagePane.toolbar.tooltip.setToGood", this.language);
        MiscToolkit.configureButton(this.setBadButton, "MessagePane.toolbar.tooltip.setToBad", this.language);
        MiscToolkit.configureButton(this.setCheckButton, "MessagePane.toolbar.tooltip.setToCheck", this.language);
        MiscToolkit.configureButton(this.setObserveButton, "MessagePane.toolbar.tooltip.setToObserve", this.language);
        this.replyButton.setEnabled(false);
        this.saveMessageButton.setEnabled(false);
        this.setGoodButton.setEnabled(false);
        this.setCheckButton.setEnabled(false);
        this.setBadButton.setEnabled(false);
        this.setObserveButton.setEnabled(false);
        this.toggleShowUnreadOnly.setSelected(Core.frostSettings.getBoolValue("MessagePanel.showUnreadOnly"));
        ImageIcon icon = MiscToolkit.loadImageIcon("/data/toolbar/software-update-available.png");
        this.toggleShowUnreadOnly.setIcon(icon);
        this.toggleShowUnreadOnly.setRolloverEnabled(true);
        this.toggleShowUnreadOnly.setRolloverIcon(MiscToolkit.createRolloverIcon(icon));
        this.toggleShowUnreadOnly.setMargin(new Insets(0, 0, 0, 0));
        this.toggleShowUnreadOnly.setPreferredSize(new Dimension(24, 24));
        this.toggleShowUnreadOnly.setFocusPainted(false);
        this.toggleShowUnreadOnly.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.toggleShowUnreadOnly"));
        this.toggleShowThreads.setSelected(Core.frostSettings.getBoolValue("MessagePanel.showThreads"));
        icon = MiscToolkit.loadImageIcon("/data/toolbar/toggle-treeview.png");
        this.toggleShowThreads.setIcon(icon);
        this.toggleShowThreads.setRolloverEnabled(true);
        this.toggleShowThreads.setRolloverIcon(MiscToolkit.createRolloverIcon(icon));
        this.toggleShowThreads.setMargin(new Insets(0, 0, 0, 0));
        this.toggleShowThreads.setPreferredSize(new Dimension(24, 24));
        this.toggleShowThreads.setFocusPainted(false);
        this.toggleShowThreads.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.toggleShowThreads"));
        this.toggleShowSmileys.setSelected(Core.frostSettings.getBoolValue("showSmileys"));
        icon = MiscToolkit.loadImageIcon("/data/toolbar/face-smile.png");
        this.toggleShowSmileys.setIcon(icon);
        this.toggleShowSmileys.setRolloverEnabled(true);
        this.toggleShowSmileys.setRolloverIcon(MiscToolkit.createRolloverIcon(icon));
        this.toggleShowSmileys.setMargin(new Insets(0, 0, 0, 0));
        this.toggleShowSmileys.setPreferredSize(new Dimension(24, 24));
        this.toggleShowSmileys.setFocusPainted(false);
        this.toggleShowSmileys.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.toggleShowSmileys"));
        this.toggleShowHyperlinks.setSelected(Core.frostSettings.getBoolValue("showKeysAsHyperlinks"));
        icon = MiscToolkit.loadImageIcon("/data/togglehyperlinks.gif");
        this.toggleShowHyperlinks.setIcon(icon);
        this.toggleShowHyperlinks.setRolloverEnabled(true);
        this.toggleShowHyperlinks.setRolloverIcon(MiscToolkit.createRolloverIcon(icon));
        this.toggleShowHyperlinks.setMargin(new Insets(0, 0, 0, 0));
        this.toggleShowHyperlinks.setPreferredSize(new Dimension(24, 24));
        this.toggleShowHyperlinks.setFocusPainted(false);
        this.toggleShowHyperlinks.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.toggleShowHyperlinks"));
        JToolBar buttonsToolbar = new JToolBar();
        buttonsToolbar.setRollover(true);
        buttonsToolbar.setFloatable(false);
        Dimension blankSpace = new Dimension(3, 3);
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.add(this.nextUnreadMessageButton);
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.addSeparator();
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.add(this.saveMessageButton);
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.addSeparator();
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.add(this.newMessageButton);
        buttonsToolbar.add(this.replyButton);
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.addSeparator();
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.add(this.updateBoardButton);
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.addSeparator();
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.add(this.setGoodButton);
        buttonsToolbar.add(this.setObserveButton);
        buttonsToolbar.add(this.setCheckButton);
        buttonsToolbar.add(this.setBadButton);
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.addSeparator();
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.add(this.toggleShowUnreadOnly);
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.addSeparator();
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.add(this.toggleShowThreads);
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.add(this.toggleShowSmileys);
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        buttonsToolbar.add(this.toggleShowHyperlinks);
        buttonsToolbar.add(Box.createRigidArea(new Dimension(8, 0)));
        buttonsToolbar.add(Box.createHorizontalGlue());
        buttonsToolbar.add(this.allMessagesCountLabel);
        buttonsToolbar.add(Box.createRigidArea(new Dimension(8, 0)));
        buttonsToolbar.add(this.newMessagesCountLabel);
        buttonsToolbar.add(Box.createRigidArea(blankSpace));
        this.newMessageButton.addActionListener(this.listener);
        this.updateBoardButton.addActionListener(this.listener);
        this.replyButton.addActionListener(this.listener);
        this.saveMessageButton.addActionListener(this.listener);
        this.nextUnreadMessageButton.addActionListener(this.listener);
        this.setGoodButton.addActionListener(this.listener);
        this.setCheckButton.addActionListener(this.listener);
        this.setBadButton.addActionListener(this.listener);
        this.setObserveButton.addActionListener(this.listener);
        this.toggleShowUnreadOnly.addActionListener(this.listener);
        this.toggleShowThreads.addActionListener(this.listener);
        this.toggleShowSmileys.addActionListener(this.listener);
        this.toggleShowHyperlinks.addActionListener(this.listener);
        return buttonsToolbar;
    }

    private void updateLabelSize(JLabel label) {
        String labelText = label.getText();
        JLabel dummyLabel = new JLabel(labelText + "00000");
        dummyLabel.doLayout();
        Dimension labelSize = dummyLabel.getPreferredSize();
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
    }

    private PopupMenuMessageTable getPopupMenuMessageTable() {
        if (this.popupMenuMessageTable == null) {
            this.popupMenuMessageTable = new PopupMenuMessageTable();
            this.language.addLanguageListener(this.popupMenuMessageTable);
        }
        return this.popupMenuMessageTable;
    }

    private PopupMenuSubjectText getPopupMenuSubjectText() {
        if (this.popupMenuSubjectText == null) {
            this.popupMenuSubjectText = new PopupMenuSubjectText();
            this.language.addLanguageListener(this.popupMenuSubjectText);
        }
        return this.popupMenuSubjectText;
    }

    public void initialize() {
        if (!this.initialized) {
            this.refreshLanguage();
            this.language.addLanguageListener(this.listener);
            FrostMessageObject.sortThreadRootMsgsAscending = this.settings.getBoolValue("sortThreadRootMessagesAscending");
            this.indicateLowReceivedMessages = Core.frostSettings.getBoolValue("MessagePanel.indicateLowReceivedMessages");
            this.indicateLowReceivedMessagesCountRed = Core.frostSettings.getIntValue("MessagePanel.indicateLowReceivedMessages.redCount");
            this.indicateLowReceivedMessagesCountLightRed = Core.frostSettings.getIntValue("MessagePanel.indicateLowReceivedMessages.lightRedCount");
            Core.frostSettings.addPropertyChangeListener("sortThreadRootMessagesAscending", this);
            Core.frostSettings.addPropertyChangeListener("messageTableMultilineSelect", this);
            Core.frostSettings.addPropertyChangeListener("messageTableScrollHorizontal", this);
            Core.frostSettings.addPropertyChangeListener("MessagePanel.indicateLowReceivedMessages", this);
            Core.frostSettings.addPropertyChangeListener("MessagePanel.indicateLowReceivedMessages.redCount", this);
            Core.frostSettings.addPropertyChangeListener("MessagePanel.indicateLowReceivedMessages.lightRedCount", this);
            MessageTreeTableModel messageTableModel = new MessageTreeTableModel(new DefaultMutableTreeNode());
            this.language.addLanguageListener(messageTableModel);
            this.messageTable = new MessageTreeTable(messageTableModel);
            new TableFindAction().install(this.messageTable);
            this.updateMsgTableResizeMode();
            this.updateMsgTableMultilineSelect();
            this.messageTable.getSelectionModel().addListSelectionListener(this.listener);
            this.messageListScrollPane = new JScrollPane(this.messageTable);
            this.messageListScrollPane.setWheelScrollingEnabled(true);
            this.messageListScrollPane.getViewport().setBackground(this.messageTable.getBackground());
            this.messageTextPane = new MessageTextPane(this.mainFrame);
            JPanel subjectPanel = new JPanel(new FlowLayout(0, 3, 0));
            subjectPanel.add(this.subjectLabel);
            subjectPanel.add(this.subjectTextLabel);
            subjectPanel.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
            this.subjectTextLabel.addMouseListener(this.listener);
            this.messageTable.loadLayout(this.settings);
            this.fontChanged();
            JPanel dummyPanel = new JPanel(new BorderLayout());
            dummyPanel.add((Component)subjectPanel, "North");
            dummyPanel.add((Component)this.messageTextPane, "Center");
            this.msgTableAndMsgTextSplitpane = new JSplitPane(0, this.messageListScrollPane, dummyPanel);
            this.msgTableAndMsgTextSplitpane.setDividerSize(10);
            this.msgTableAndMsgTextSplitpane.setResizeWeight(0.5);
            this.msgTableAndMsgTextSplitpane.setMinimumSize(new Dimension(50, 20));
            int dividerLoc = Core.frostSettings.getIntValue("MessagePanel.msgTableAndMsgTextSplitpaneDividerLocation");
            if (dividerLoc < 10) {
                dividerLoc = 160;
            }
            this.msgTableAndMsgTextSplitpane.setDividerLocation(dividerLoc);
            this.setLayout(new BorderLayout());
            this.add((Component)this.getButtonsToolbar(), "North");
            this.add((Component)this.msgTableAndMsgTextSplitpane, "Center");
            this.messageTable.addMouseListener(this.listener);
            this.mainFrame.getTofTree().addTreeSelectionListener(this.listener);
            this.assignHotkeys();
            this.boardsTree_actionPerformed(null);
            this.initialized = true;
        }
    }

    private void assignHotkeys() {
        AbstractAction deleteMessageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                MessagePanel.this.deleteSelectedMessage();
            }
        };
        MainFrame.getInstance().setKeyActionForNewsTab(deleteMessageAction, "DEL_MSG", KeyStroke.getKeyStroke(127, 0));
        MainFrame.getInstance().setKeyActionForNewsTab(deleteMessageAction, "DEL_MSG", KeyStroke.getKeyStroke(8, 0));
        this.messageTable.getInputMap(1).getParent().remove(KeyStroke.getKeyStroke(10, 0));
        AbstractAction openMessageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                MessagePanel.this.showCurrentMessagePopupWindow();
            }
        };
        MainFrame.getInstance().setKeyActionForNewsTab(openMessageAction, "OPEN_MSG", KeyStroke.getKeyStroke(10, 0));
        AbstractAction nextUnreadAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                MessagePanel.this.selectNextUnreadMessage();
            }
        };
        MainFrame.getInstance().setKeyActionForNewsTab(nextUnreadAction, "NEXT_MSG", KeyStroke.getKeyStroke(78, 0));
        this.getInputMap(1).put(KeyStroke.getKeyStroke(66, 0), "SET_BAD");
        this.getActionMap().put("SET_BAD", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.BAD);
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke(71, 0), "SET_GOOD");
        this.getActionMap().put("SET_GOOD", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.GOOD);
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke(67, 0), "SET_CHECK");
        this.getActionMap().put("SET_CHECK", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.CHECK);
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke(79, 0), "SET_OBSERVE");
        this.getActionMap().put("SET_OBSERVE", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.OBSERVE);
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke(70, 0), "TOGGLE_FLAGGED");
        this.getActionMap().put("TOGGLE_FLAGGED", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                MessagePanel.this.updateBooleanState(BooleanState.FLAGGED);
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke(83, 0), "TOGGLE_STARRED");
        this.getActionMap().put("TOGGLE_STARRED", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                MessagePanel.this.updateBooleanState(BooleanState.STARRED);
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke(74, 0), "TOGGLE_JUNK");
        this.getActionMap().put("TOGGLE_JUNK", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                MessagePanel.this.updateBooleanState(BooleanState.JUNK);
            }
        });
    }

    public void saveLayout(SettingsClass frostSettings) {
        frostSettings.setValue("MessagePanel.msgTableAndMsgTextSplitpaneDividerLocation", this.msgTableAndMsgTextSplitpane.getDividerLocation());
        this.getMessageTable().saveLayout(frostSettings);
    }

    private void fontChanged() {
        int fontSize;
        int fontStyle;
        String fontName = this.settings.getValue("messageListFontName");
        Font font = new Font(fontName, fontStyle = this.settings.getIntValue("messageListFontStyle"), fontSize = this.settings.getIntValue("messageListFontSize"));
        if (!font.getFamily().equals(fontName)) {
            this.logger.severe("The selected font was not found in your system\nThat selection will be changed to \"SansSerif\".");
            this.settings.setValue("messageListFontName", "SansSerif");
            font = new Font("SansSerif", fontStyle, fontSize);
        }
        this.messageTable.setFont(font);
    }

    private FrostMessageObject evalSelection(ListSelectionEvent e, JTable table, Board board) {
        if (!table.isEditing()) {
            FrostMessageObject message;
            if (table.getSelectedRowCount() > 1) {
                return null;
            }
            int row = table.getSelectedRow();
            if (row != -1 && row < this.getMessageTableModel().getRowCount() && (message = (FrostMessageObject)this.getMessageTableModel().getRow(row)) != null) {
                if (!message.isNew()) {
                    return message;
                }
                message.setNew(false);
                this.getMessageTableModel().fireTableRowsUpdated(row, row);
                FrostMessageObject threadRootMsg = message.getThreadRootMessage();
                if (threadRootMsg != message && threadRootMsg != null) {
                    this.getMessageTreeModel().nodeChanged(threadRootMsg);
                }
                board.decNewMessageCount();
                MainFrame.getInstance().updateMessageCountLabels(board);
                MainFrame.getInstance().updateTofTree(board);
                Thread saver = new Thread(){

                    public void run() {
                        MessageStorage.inst().updateMessage(message);
                    }
                };
                saver.start();
                return message;
            }
        }
        return null;
    }

    private void messageTable_itemSelected(ListSelectionEvent e) {
        AbstractNode selectedNode = this.mainFrame.getTofTreeModel().getSelectedNode();
        if (selectedNode.isFolder()) {
            this.setGoodButton.setEnabled(false);
            this.setCheckButton.setEnabled(false);
            this.setBadButton.setEnabled(false);
            this.setObserveButton.setEnabled(false);
            this.replyButton.setEnabled(false);
            this.saveMessageButton.setEnabled(false);
            return;
        }
        if (!selectedNode.isBoard()) {
            return;
        }
        Board selectedBoard = (Board)selectedNode;
        FrostMessageObject newSelectedMessage = this.evalSelection(e, this.messageTable, selectedBoard);
        if (newSelectedMessage == this.selectedMessage) {
            return;
        }
        this.selectedMessage = newSelectedMessage;
        if (this.selectedMessage != null) {
            if (this.selectedMessage.isDummy()) {
                this.getMessageTextPane().update_boardSelected();
                this.clearSubjectTextLabel();
                this.setGoodButton.setEnabled(false);
                this.setCheckButton.setEnabled(false);
                this.setBadButton.setEnabled(false);
                this.setObserveButton.setEnabled(false);
                this.replyButton.setEnabled(false);
                this.saveMessageButton.setEnabled(false);
                return;
            }
            MainFrame.getInstance().displayNewMessageIcon(false);
            if (!selectedBoard.isReadAccessBoard()) {
                this.replyButton.setEnabled(true);
            } else {
                this.replyButton.setEnabled(false);
            }
            if (this.identities.isMySelf(this.selectedMessage.getFromName())) {
                this.setGoodButton.setEnabled(false);
                this.setCheckButton.setEnabled(false);
                this.setBadButton.setEnabled(false);
                this.setObserveButton.setEnabled(false);
            } else if (this.selectedMessage.isMessageStatusCHECK()) {
                this.setCheckButton.setEnabled(false);
                this.setGoodButton.setEnabled(true);
                this.setBadButton.setEnabled(true);
                this.setObserveButton.setEnabled(true);
            } else if (this.selectedMessage.isMessageStatusGOOD()) {
                this.setGoodButton.setEnabled(false);
                this.setCheckButton.setEnabled(true);
                this.setBadButton.setEnabled(true);
                this.setObserveButton.setEnabled(true);
            } else if (this.selectedMessage.isMessageStatusBAD()) {
                this.setBadButton.setEnabled(false);
                this.setGoodButton.setEnabled(true);
                this.setCheckButton.setEnabled(true);
                this.setObserveButton.setEnabled(true);
            } else if (this.selectedMessage.isMessageStatusOBSERVE()) {
                this.setObserveButton.setEnabled(false);
                this.setGoodButton.setEnabled(true);
                this.setCheckButton.setEnabled(true);
                this.setBadButton.setEnabled(true);
            } else {
                this.setGoodButton.setEnabled(false);
                this.setCheckButton.setEnabled(false);
                this.setBadButton.setEnabled(false);
                this.setObserveButton.setEnabled(false);
            }
            this.getMessageTextPane().update_messageSelected(this.selectedMessage);
            this.updateSubjectTextLabel(this.selectedMessage.getSubject(), this.selectedMessage.getFromIdentity());
            if (this.selectedMessage.getContent().length() > 0) {
                this.saveMessageButton.setEnabled(true);
            } else {
                this.saveMessageButton.setEnabled(false);
            }
        } else {
            this.getMessageTextPane().update_boardSelected();
            this.clearSubjectTextLabel();
            this.replyButton.setEnabled(false);
            this.saveMessageButton.setEnabled(false);
            this.setGoodButton.setEnabled(false);
            this.setCheckButton.setEnabled(false);
            this.setBadButton.setEnabled(false);
            this.setObserveButton.setEnabled(false);
        }
    }

    private void newMessageButton_actionPerformed() {
        AbstractNode node = this.mainFrame.getTofTreeModel().getSelectedNode();
        if (node == null || !node.isBoard()) {
            return;
        }
        Board board = (Board)node;
        this.composeNewMessage(board);
    }

    public void composeNewMessage(Board targetBoard) {
        if (targetBoard == null || targetBoard.isReadAccessBoard()) {
            return;
        }
        MessageFrame newMessageFrame = new MessageFrame(this.settings, this.mainFrame);
        newMessageFrame.composeNewMessage(targetBoard, "No subject", "");
    }

    public void setTrustState_actionPerformed(IdentityState idState) {
        List<FrostMessageObject> selectedMessages = this.getSelectedMessages();
        if (selectedMessages.size() == 0) {
            return;
        }
        int[] rows = this.messageTable.getSelectedRows();
        boolean idChanged = false;
        for (FrostMessageObject targetMessage : selectedMessages) {
            Identity id = this.getSelectedMessageFromIdentity(targetMessage);
            if (id == null) continue;
            if (idState == IdentityState.GOOD && !id.isGOOD()) {
                id.setGOOD();
                idChanged = true;
                continue;
            }
            if (idState == IdentityState.OBSERVE && !id.isOBSERVE()) {
                id.setOBSERVE();
                idChanged = true;
                continue;
            }
            if (idState == IdentityState.CHECK && !id.isCHECK()) {
                id.setCHECK();
                idChanged = true;
                continue;
            }
            if (idState != IdentityState.BAD || id.isBAD()) continue;
            id.setBAD();
            idChanged = true;
        }
        if (idChanged) {
            this.updateTableAfterChangeOfIdentityState();
            if (rows.length == 1) {
                this.setGoodButton.setEnabled(idState != IdentityState.GOOD);
                this.setCheckButton.setEnabled(idState != IdentityState.CHECK);
                this.setBadButton.setEnabled(idState != IdentityState.BAD);
                this.setObserveButton.setEnabled(idState != IdentityState.OBSERVE);
            }
        }
    }

    private void toggleShowUnreadOnly_actionPerformed(ActionEvent e) {
        boolean oldValue = Core.frostSettings.getBoolValue("MessagePanel.showUnreadOnly");
        boolean newValue = !oldValue;
        Core.frostSettings.setValue("MessagePanel.showUnreadOnly", newValue);
        MainFrame.getInstance().tofTree_actionPerformed(null, true);
    }

    private void toggleShowThreads_actionPerformed(ActionEvent e) {
        boolean oldValue = Core.frostSettings.getBoolValue("MessagePanel.showThreads");
        boolean newValue = !oldValue;
        Core.frostSettings.setValue("MessagePanel.showThreads", newValue);
        MainFrame.getInstance().tofTree_actionPerformed(null, true);
    }

    private void toggleShowSmileys_actionPerformed(ActionEvent e) {
        boolean oldValue = Core.frostSettings.getBoolValue("showSmileys");
        boolean newValue = !oldValue;
        Core.frostSettings.setValue("showSmileys", newValue);
    }

    private void toggleShowHyperlinks_actionPerformed(ActionEvent e) {
        boolean oldValue = Core.frostSettings.getBoolValue("showKeysAsHyperlinks");
        boolean newValue = !oldValue;
        Core.frostSettings.setValue("showKeysAsHyperlinks", newValue);
    }

    private void refreshLanguage() {
        this.newMessageButton.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.newMessage"));
        this.replyButton.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.reply"));
        this.saveMessageButton.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.saveMessage"));
        this.nextUnreadMessageButton.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.nextUnreadMessage"));
        this.setGoodButton.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.setToGood"));
        this.setBadButton.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.setToBad"));
        this.setCheckButton.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.setToCheck"));
        this.setObserveButton.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.setToObserve"));
        this.updateBoardButton.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.update"));
        this.toggleShowUnreadOnly.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.toggleShowUnreadOnly"));
        this.toggleShowThreads.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.toggleShowThreads"));
        this.toggleShowSmileys.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.toggleShowSmileys"));
        this.toggleShowHyperlinks.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.toggleShowHyperlinks"));
        this.subjectLabel.setText(this.language.getString("MessageWindow.subject") + ": ");
        this.allMessagesCountPrefix = this.language.getString("MessagePane.toolbar.labelAllMessageCount") + ": ";
        this.allMessagesCountLabel.setText(this.allMessagesCountPrefix);
        this.newMessagesCountPrefix = this.language.getString("MessagePane.toolbar.labelNewMessageCount") + ": ";
        this.newMessagesCountLabel.setText(this.newMessagesCountPrefix);
        this.updateLabelSize(this.allMessagesCountLabel);
        this.updateLabelSize(this.newMessagesCountLabel);
    }

    private void replyButton_actionPerformed(ActionEvent e) {
        FrostMessageObject origMessage = this.selectedMessage;
        this.composeReply(origMessage, this.parentFrame);
    }

    public void composeReply(FrostMessageObject origMessage, Window parent) {
        Board targetBoard = this.mainFrame.getTofTreeModel().getBoardByName(origMessage.getBoard().getName());
        if (targetBoard == null) {
            String title = this.language.getString("MessagePane.missingBoardError.title");
            String txt = this.language.formatMessage("MessagePane.missingBoardError.text", origMessage.getBoard().getName());
            JOptionPane.showMessageDialog(parent, txt, title, 64);
            return;
        }
        String subject = origMessage.getSubject();
        if (!subject.startsWith("Re:")) {
            subject = "Re: " + subject;
        }
        String inReplyTo = null;
        if (origMessage.getMessageId() != null) {
            inReplyTo = origMessage.getInReplyTo();
            inReplyTo = inReplyTo == null ? origMessage.getMessageId() : inReplyTo + "," + origMessage.getMessageId();
        }
        if (origMessage.getRecipientName() != null) {
            if (origMessage.getFromIdentity() == null) {
                String title = this.language.getString("MessagePane.unknownRecipientError.title");
                String txt = this.language.formatMessage("MessagePane.unknownRecipientError.text", origMessage.getFromName());
                JOptionPane.showMessageDialog(parent, txt, title, 0);
                return;
            }
            LocalIdentity senderId = null;
            if (origMessage.getFromIdentity() instanceof LocalIdentity) {
                senderId = (LocalIdentity)origMessage.getFromIdentity();
            } else {
                senderId = this.identities.getLocalIdentity(origMessage.getRecipientName());
                if (senderId == null) {
                    String title = this.language.getString("MessagePane.missingLocalIdentityError.title");
                    String txt = this.language.formatMessage("MessagePane.missingLocalIdentityError.text", origMessage.getRecipientName());
                    JOptionPane.showMessageDialog(parent, txt, title, 0);
                    return;
                }
            }
            MessageFrame newMessageFrame = new MessageFrame(this.settings, parent);
            newMessageFrame.composeEncryptedReply(targetBoard, subject, inReplyTo, origMessage.getContent(), origMessage.getFromIdentity(), senderId, origMessage);
        } else {
            MessageFrame newMessageFrame = new MessageFrame(this.settings, parent);
            newMessageFrame.composeReply(targetBoard, subject, inReplyTo, origMessage.getContent(), origMessage);
        }
    }

    private void showMessageTablePopupMenu(MouseEvent e) {
        Point p = e.getPoint();
        int y = this.messageTable.rowAtPoint(p);
        if (y < 0) {
            return;
        }
        if (!this.messageTable.getSelectionModel().isSelectedIndex(y)) {
            this.messageTable.getSelectionModel().setSelectionInterval(y, y);
        }
        this.getPopupMenuMessageTable().show(e.getComponent(), e.getX(), e.getY());
    }

    private void showCurrentMessagePopupWindow() {
        if (!this.isCorrectlySelectedMessage()) {
            return;
        }
        MessageWindow messageWindow = new MessageWindow(this.mainFrame, this.selectedMessage, this.getSize());
        messageWindow.setVisible(true);
    }

    private void updateButton_actionPerformed(ActionEvent e) {
        Board b;
        AbstractNode node = this.mainFrame.getTofTreeModel().getSelectedNode();
        if (node != null && node.isBoard() && (b = (Board)node).isManualUpdateAllowed()) {
            this.mainFrame.getTofTree().updateBoard(b);
        }
    }

    private void boardsTree_actionPerformed(TreeSelectionEvent e) {
        if (this.mainFrame.getTofTreeModel().getRoot().getChildCount() == 0) {
            this.getMessageTextPane().update_noBoardsFound();
            this.clearSubjectTextLabel();
        } else {
            AbstractNode node = (AbstractNode)this.mainFrame.getTofTree().getLastSelectedPathComponent();
            if (node != null) {
                if (node.isBoard()) {
                    this.getMessageTextPane().update_boardSelected();
                    this.clearSubjectTextLabel();
                    this.updateBoardButton.setEnabled(true);
                    this.saveMessageButton.setEnabled(false);
                    this.replyButton.setEnabled(false);
                    if (((Board)node).isReadAccessBoard()) {
                        this.newMessageButton.setEnabled(false);
                    } else {
                        this.newMessageButton.setEnabled(true);
                    }
                } else if (node.isFolder()) {
                    this.newMessageButton.setEnabled(false);
                    this.saveMessageButton.setEnabled(false);
                    this.updateBoardButton.setEnabled(false);
                    this.getMessageTextPane().update_folderSelected();
                    this.clearSubjectTextLabel();
                }
            }
        }
    }

    private boolean isCorrectlySelectedMessage() {
        int row = this.messageTable.getSelectedRow();
        return row >= 0 && this.selectedMessage != null && this.mainFrame.getTofTreeModel().getSelectedNode() != null && this.mainFrame.getTofTreeModel().getSelectedNode().isBoard() && !this.selectedMessage.isDummy();
    }

    private void markSelectedMessagesReadOrUnread(boolean markRead) {
        AbstractNode node = this.mainFrame.getTofTreeModel().getSelectedNode();
        if (node == null || !node.isBoard()) {
            return;
        }
        Board board = (Board)node;
        List<FrostMessageObject> selectedMessages = this.getSelectedMessages();
        if (selectedMessages.size() == 0) {
            return;
        }
        final ArrayList<FrostMessageObject> saveMessages = new ArrayList<FrostMessageObject>();
        DefaultTreeModel model = (DefaultTreeModel)MainFrame.getInstance().getMessagePanel().getMessageTable().getTree().getModel();
        for (FrostMessageObject targetMessage : selectedMessages) {
            if (markRead) {
                if (targetMessage.isNew()) {
                    targetMessage.setNew(false);
                    board.decNewMessageCount();
                }
            } else if (!targetMessage.isNew()) {
                targetMessage.setNew(true);
                board.incNewMessageCount();
            }
            model.nodeChanged(targetMessage);
            saveMessages.add(targetMessage);
        }
        if (!markRead) {
            this.messageTable.removeRowSelectionInterval(0, this.messageTable.getRowCount() - 1);
        }
        this.updateMessageCountLabels(board);
        this.mainFrame.updateTofTree(board);
        Thread saver = new Thread(){

            public void run() {
                Iterator i$ = saveMessages.iterator();
                while (i$.hasNext()) {
                    FrostMessageObject element;
                    FrostMessageObject targetMessage = element = (FrostMessageObject)i$.next();
                    MessageStorage.inst().updateMessage(targetMessage);
                }
            }
        };
        saver.start();
    }

    private void markThreadRead() {
        if (this.selectedMessage == null) {
            return;
        }
        TreeNode[] rootPath = this.selectedMessage.getPath();
        if (rootPath.length < 2) {
            return;
        }
        FrostMessageObject levelOneMsg = (FrostMessageObject)rootPath[1];
        DefaultTreeModel model = MainFrame.getInstance().getMessagePanel().getMessageTreeModel();
        AbstractNode node = this.mainFrame.getTofTreeModel().getSelectedNode();
        if (node == null || !node.isBoard()) {
            return;
        }
        Board board = (Board)node;
        final LinkedList<FrostMessageObject> msgList = new LinkedList<FrostMessageObject>();
        Enumeration<TreeNode> e = levelOneMsg.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            FrostMessageObject mo = (FrostMessageObject)e.nextElement();
            if (!mo.isNew()) continue;
            msgList.add(mo);
            mo.setNew(false);
            if (MainFrame.getInstance().getMessagePanel().getMessageTable().getTree().isVisible(new TreePath(mo.getPath()))) {
                model.nodeChanged(mo);
            }
            board.decNewMessageCount();
        }
        this.updateMessageCountLabels(board);
        this.mainFrame.updateTofTree(board);
        Thread saver = new Thread(){

            public void run() {
                Iterator i$ = msgList.iterator();
                while (i$.hasNext()) {
                    FrostMessageObject element;
                    FrostMessageObject mo = element = (FrostMessageObject)i$.next();
                    MessageStorage.inst().updateMessage(mo);
                }
            }
        };
        saver.start();
    }

    public void deleteSelectedMessage() {
        AbstractNode node = this.mainFrame.getTofTreeModel().getSelectedNode();
        if (node == null || !node.isBoard()) {
            return;
        }
        Board board = (Board)node;
        List<FrostMessageObject> selectedMessages = this.getSelectedMessages();
        if (selectedMessages.size() == 0) {
            return;
        }
        final ArrayList<FrostMessageObject> saveMessages = new ArrayList<FrostMessageObject>();
        DefaultTreeModel model = (DefaultTreeModel)MainFrame.getInstance().getMessagePanel().getMessageTable().getTree().getModel();
        for (FrostMessageObject targetMessage : selectedMessages) {
            targetMessage.setDeleted(true);
            if (targetMessage.isNew()) {
                targetMessage.setNew(false);
                board.decNewMessageCount();
            }
            model.nodeChanged(targetMessage);
            saveMessages.add(targetMessage);
        }
        this.updateMessageCountLabels(board);
        this.mainFrame.updateTofTree(board);
        Thread saver = new Thread(){

            public void run() {
                Iterator i$ = saveMessages.iterator();
                while (i$.hasNext()) {
                    FrostMessageObject element;
                    FrostMessageObject targetMessage = element = (FrostMessageObject)i$.next();
                    MessageStorage.inst().updateMessage(targetMessage);
                }
            }
        };
        saver.start();
    }

    private void undeleteSelectedMessage() {
        List<FrostMessageObject> selectedMessages = this.getSelectedMessages();
        if (selectedMessages.size() == 0) {
            return;
        }
        final ArrayList<FrostMessageObject> saveMessages = new ArrayList<FrostMessageObject>();
        DefaultTreeModel model = (DefaultTreeModel)MainFrame.getInstance().getMessagePanel().getMessageTable().getTree().getModel();
        for (FrostMessageObject targetMessage : selectedMessages) {
            if (!targetMessage.isDeleted()) continue;
            targetMessage.setDeleted(false);
            model.nodeChanged(targetMessage);
            saveMessages.add(targetMessage);
        }
        Thread saver = new Thread(){

            public void run() {
                Iterator i$ = saveMessages.iterator();
                while (i$.hasNext()) {
                    FrostMessageObject element;
                    FrostMessageObject targetMessage = element = (FrostMessageObject)i$.next();
                    MessageStorage.inst().updateMessage(targetMessage);
                }
            }
        };
        saver.start();
    }

    private List<FrostMessageObject> getSelectedMessages() {
        if (this.messageTable.getSelectedRowCount() <= 1 && !this.isCorrectlySelectedMessage()) {
            return Collections.emptyList();
        }
        int[] rows = this.messageTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FrostMessageObject> msgs = new ArrayList<FrostMessageObject>(rows.length);
        for (int ix : rows) {
            FrostMessageObject targetMessage = (FrostMessageObject)this.getMessageTableModel().getRow(ix);
            if (targetMessage == null || targetMessage.isDummy()) continue;
            msgs.add(targetMessage);
        }
        return msgs;
    }

    public void setIdentities(FrostIdentities identities) {
        this.identities = identities;
    }

    public void setParentFrame(JFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void updateMessageCountLabels(AbstractNode node) {
        if (node.isFolder()) {
            this.allMessagesCountLabel.setText("");
            this.newMessagesCountLabel.setText("");
            this.nextUnreadMessageButton.setEnabled(false);
        } else if (node.isBoard()) {
            int allMessages = 0;
            FrostMessageObject rootNode = (FrostMessageObject)MainFrame.getInstance().getMessageTreeModel().getRoot();
            Enumeration<TreeNode> e = rootNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                FrostMessageObject mo = (FrostMessageObject)e.nextElement();
                if (mo.isDummy()) continue;
                ++allMessages;
            }
            this.allMessagesCountLabel.setText(this.allMessagesCountPrefix + allMessages);
            int newMessages = ((Board)node).getNewMessageCount();
            this.newMessagesCountLabel.setText(this.newMessagesCountPrefix + newMessages);
            if (newMessages > 0) {
                this.nextUnreadMessageButton.setEnabled(true);
            } else {
                this.nextUnreadMessageButton.setEnabled(false);
            }
        }
    }

    private Identity getSelectedMessageFromIdentity(FrostMessageObject msg) {
        if (msg == null) {
            return null;
        }
        if (!msg.isSignatureStatusVERIFIED()) {
            return null;
        }
        Identity ident = msg.getFromIdentity();
        if (ident == null) {
            this.logger.severe("no identity in list for from: " + msg.getFromName());
            return null;
        }
        if (ident instanceof LocalIdentity) {
            this.logger.info("Ignored request to change my own ID state");
            return null;
        }
        return ident;
    }

    public FrostMessageObject getSelectedMessage() {
        if (!this.isCorrectlySelectedMessage()) {
            return null;
        }
        return this.selectedMessage;
    }

    public void updateTableAfterChangeOfIdentityState() {
        AbstractNode node = this.mainFrame.getTofTreeModel().getSelectedNode();
        if (node == null || !node.isBoard()) {
            return;
        }
        Board board = (Board)node;
        DefaultTreeModel model = this.getMessageTreeModel();
        DefaultMutableTreeNode rootnode = (DefaultMutableTreeNode)model.getRoot();
        Enumeration<TreeNode> e = rootnode.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreeNode o = e.nextElement();
            if (!(o instanceof FrostMessageObject)) continue;
            FrostMessageObject message = (FrostMessageObject)o;
            int row = MainFrame.getInstance().getMessageTreeTable().getRowForNode(message);
            if (row < 0) continue;
            this.getMessageTableModel().fireTableRowsUpdated(row, row);
        }
        MainFrame.getInstance().updateMessageCountLabels(board);
    }

    public void selectNextUnreadMessage() {
        FrostMessageObject initial;
        DefaultMutableTreeNode nextMessage = null;
        DefaultTreeModel tableModel = this.getMessageTreeModel();
        if (Core.frostSettings.getBoolValue("MessagePanel.showThreads") && (initial = this.getSelectedMessage()) != null) {
            TreeNode[] path = initial.getPath();
            List<TreeNode> path_list = Arrays.asList(path);
            block0: for (int idx = initial.getLevel(); idx > 0 && nextMessage == null; --idx) {
                FrostMessageObject parent = (FrostMessageObject)path[idx];
                LinkedList<FrostMessageObject> queue = new LinkedList<FrostMessageObject>();
                queue.add(parent);
                while (!queue.isEmpty() && nextMessage == null) {
                    FrostMessageObject message = (FrostMessageObject)queue.removeFirst();
                    if (message.isNew()) {
                        nextMessage = message;
                        continue block0;
                    }
                    Enumeration<TreeNode> children = message.children();
                    while (children.hasMoreElements()) {
                        FrostMessageObject t = (FrostMessageObject)children.nextElement();
                        if (path_list.contains(t)) continue;
                        queue.add(t);
                    }
                }
            }
        }
        if (nextMessage == null) {
            Enumeration<TreeNode> e = ((DefaultMutableTreeNode)tableModel.getRoot()).depthFirstEnumeration();
            while (e.hasMoreElements()) {
                FrostMessageObject message = (FrostMessageObject)e.nextElement();
                if (!message.isNew()) continue;
                if (nextMessage == null) {
                    nextMessage = message;
                    continue;
                }
                if (((FrostMessageObject)nextMessage).getDateAndTimeString().compareTo(message.getDateAndTimeString()) <= 0) continue;
                nextMessage = message;
            }
        }
        if (nextMessage != null) {
            this.messageTable.removeRowSelectionInterval(0, this.getMessageTableModel().getRowCount() - 1);
            this.messageTable.getTree().makeVisible(new TreePath(nextMessage.getPath()));
            int row = this.messageTable.getRowForNode(nextMessage);
            if (row >= 0) {
                this.messageTable.addRowSelectionInterval(row, row);
                this.messageListScrollPane.getVerticalScrollBar().setValue((row == 0 ? row : row - 1) * this.messageTable.getRowHeight());
            }
        }
    }

    public void updateBooleanState(BooleanState state) {
        this.updateBooleanState(state, this.getSelectedMessages());
    }

    private void updateBooleanState(BooleanState state, final List<FrostMessageObject> msgs) {
        boolean doEnable;
        if (msgs.isEmpty()) {
            return;
        }
        FrostMessageObject firstMessage = msgs.get(0);
        switch (state) {
            case FLAGGED: {
                doEnable = !firstMessage.isFlagged();
                break;
            }
            case STARRED: {
                doEnable = !firstMessage.isStarred();
                break;
            }
            case JUNK: {
                doEnable = !firstMessage.isJunk();
                break;
            }
            default: {
                return;
            }
        }
        ArrayList<Identity> identitiesToMarkBad = state == BooleanState.JUNK && Core.frostSettings.getBoolValue("junk.markJunkIdentityBad") && doEnable ? new ArrayList<Identity>() : null;
        for (FrostMessageObject message : msgs) {
            FrostMessageObject threadRootMsg;
            Identity id;
            switch (state) {
                case FLAGGED: {
                    message.setFlagged(doEnable);
                    break;
                }
                case STARRED: {
                    message.setStarred(doEnable);
                    break;
                }
                case JUNK: {
                    message.setJunk(doEnable);
                }
            }
            int row = MainFrame.getInstance().getMessageTreeTable().getRowForNode(message);
            if (row >= 0) {
                this.getMessageTableModel().fireTableRowsUpdated(row, row);
            }
            if (identitiesToMarkBad != null && (id = message.getFromIdentity()) != null && id.isCHECK()) {
                identitiesToMarkBad.add(id);
            }
            if (state == BooleanState.JUNK || (threadRootMsg = message.getThreadRootMessage()) == message || threadRootMsg == null) continue;
            this.getMessageTreeModel().nodeChanged(threadRootMsg);
        }
        if (state != BooleanState.JUNK) {
            boolean hasStarredWork = false;
            boolean hasFlaggedWork = false;
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)firstMessage.getRoot();
            Enumeration<TreeNode> e = rootNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                FrostMessageObject mo = (FrostMessageObject)e.nextElement();
                if (!hasStarredWork && mo.isStarred()) {
                    hasStarredWork = true;
                }
                if (!hasFlaggedWork && mo.isFlagged()) {
                    hasFlaggedWork = true;
                }
                if (!hasFlaggedWork || !hasStarredWork) continue;
                break;
            }
            Board board = firstMessage.getBoard();
            board.hasFlaggedMessages(hasFlaggedWork);
            board.hasStarredMessages(hasStarredWork);
            MainFrame.getInstance().updateTofTree(board);
        }
        if (identitiesToMarkBad != null && !identitiesToMarkBad.isEmpty()) {
            for (Identity id : identitiesToMarkBad) {
                id.setBAD();
            }
            this.updateTableAfterChangeOfIdentityState();
            if (msgs.size() == 1) {
                this.setGoodButton.setEnabled(true);
                this.setCheckButton.setEnabled(true);
                this.setBadButton.setEnabled(false);
                this.setObserveButton.setEnabled(true);
            }
        }
        Thread saver = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!MessageStorage.inst().beginExclusiveThreadTransaction()) {
                    MessagePanel.this.logger.severe("Failed to start EXCLUSIVE transaction in MessageStore!");
                    return;
                }
                try {
                    for (FrostMessageObject message : msgs) {
                        MessageStorage.inst().updateMessage(message, false);
                    }
                }
                finally {
                    MessageStorage.inst().endThreadTransaction();
                }
            }
        };
        saver.start();
    }

    private void updateSubjectTextLabel(String newText, Identity fromId) {
        if (newText == null) {
            this.subjectTextLabel.setText("");
        } else {
            this.subjectTextLabel.setText(newText);
        }
        ImageIcon iconToSet = null;
        if (fromId != null && this.indicateLowReceivedMessages) {
            int receivedMsgCount = fromId.getReceivedMessageCount();
            if (receivedMsgCount <= this.indicateLowReceivedMessagesCountRed) {
                iconToSet = MainFrame.getInstance().getMessageTreeTable().receivedOneMessage;
            } else if (receivedMsgCount <= this.indicateLowReceivedMessagesCountLightRed) {
                iconToSet = MainFrame.getInstance().getMessageTreeTable().receivedFiveMessages;
            }
        }
        this.subjectLabel.setIcon(iconToSet);
    }

    private void clearSubjectTextLabel() {
        this.subjectTextLabel.setText("");
        this.subjectLabel.setIcon(null);
    }

    public TreeTableModelAdapter getMessageTableModel() {
        return (TreeTableModelAdapter)this.getMessageTable().getModel();
    }

    public DefaultTreeModel getMessageTreeModel() {
        return (DefaultTreeModel)this.getMessageTable().getTree().getModel();
    }

    public MessageTreeTable getMessageTable() {
        return this.messageTable;
    }

    public MessageTextPane getMessageTextPane() {
        return this.messageTextPane;
    }

    private void updateMsgTableMultilineSelect() {
        if (Core.frostSettings.getBoolValue("messageTableMultilineSelect")) {
            this.messageTable.setSelectionMode(2);
        } else {
            this.messageTable.setSelectionMode(0);
        }
    }

    private void updateMsgTableResizeMode() {
        if (Core.frostSettings.getBoolValue("messageTableScrollHorizontal")) {
            this.getMessageTable().setAutoResizeMode(0);
        } else {
            this.getMessageTable().setAutoResizeMode(1);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("messageTableMultilineSelect")) {
            this.updateMsgTableMultilineSelect();
        } else if (evt.getPropertyName().equals("messageTableScrollHorizontal")) {
            this.updateMsgTableResizeMode();
        } else if (evt.getPropertyName().equals("sortThreadRootMessagesAscending")) {
            FrostMessageObject.sortThreadRootMsgsAscending = this.settings.getBoolValue("sortThreadRootMessagesAscending");
        } else if (evt.getPropertyName().equals("MessagePanel.indicateLowReceivedMessages")) {
            this.indicateLowReceivedMessages = Core.frostSettings.getBoolValue("MessagePanel.indicateLowReceivedMessages");
        } else if (evt.getPropertyName().equals("MessagePanel.indicateLowReceivedMessages.redCount")) {
            this.indicateLowReceivedMessagesCountRed = Core.frostSettings.getIntValue("MessagePanel.indicateLowReceivedMessages.redCount");
        } else if (evt.getPropertyName().equals("MessagePanel.indicateLowReceivedMessages.lightRedCount")) {
            this.indicateLowReceivedMessagesCountLightRed = Core.frostSettings.getIntValue("MessagePanel.indicateLowReceivedMessages.lightRedCount");
        }
    }

    private class PopupMenuMessageTable
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        private final JMenuItem markAllMessagesReadItem = new JMenuItem();
        private final JMenuItem markSelectedMessagesReadItem = new JMenuItem();
        private final JMenuItem markSelectedMessagesUnreadItem = new JMenuItem();
        private final JMenuItem markThreadReadItem = new JMenuItem();
        private final JMenuItem markMessageUnreadItem = new JMenuItem();
        private final JMenuItem setBadItem = new JMenuItem();
        private final JMenuItem setCheckItem = new JMenuItem();
        private final JMenuItem setGoodItem = new JMenuItem();
        private final JMenuItem setObserveItem = new JMenuItem();
        private final JMenuItem deleteItem = new JMenuItem();
        private final JMenuItem undeleteItem = new JMenuItem();
        private final JMenuItem expandAllItem = new JMenuItem();
        private final JMenuItem collapseAllItem = new JMenuItem();
        private final JMenuItem expandThreadItem = new JMenuItem();
        private final JMenuItem collapseThreadItem = new JMenuItem();

        public PopupMenuMessageTable() {
            this.initialize();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.markMessageUnreadItem) {
                MessagePanel.this.markSelectedMessagesReadOrUnread(false);
            } else if (e.getSource() == this.markAllMessagesReadItem) {
                TOF.getInstance().markAllMessagesRead(MessagePanel.this.mainFrame.getTofTreeModel().getSelectedNode());
            } else if (e.getSource() == this.markSelectedMessagesReadItem) {
                MessagePanel.this.markSelectedMessagesReadOrUnread(true);
            } else if (e.getSource() == this.markSelectedMessagesUnreadItem) {
                MessagePanel.this.markSelectedMessagesReadOrUnread(false);
            } else if (e.getSource() == this.markThreadReadItem) {
                MessagePanel.this.markThreadRead();
            } else if (e.getSource() == this.deleteItem) {
                MessagePanel.this.deleteSelectedMessage();
            } else if (e.getSource() == this.undeleteItem) {
                MessagePanel.this.undeleteSelectedMessage();
            } else if (e.getSource() == this.expandAllItem) {
                MessagePanel.this.getMessageTable().expandAll(true);
            } else if (e.getSource() == this.collapseAllItem) {
                MessagePanel.this.getMessageTable().expandAll(false);
            } else if (e.getSource() == this.expandThreadItem) {
                MessagePanel.this.getMessageTable().expandThread(true, MessagePanel.this.selectedMessage);
            } else if (e.getSource() == this.collapseThreadItem) {
                MessagePanel.this.getMessageTable().expandThread(false, MessagePanel.this.selectedMessage);
            } else if (e.getSource() == this.setGoodItem) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.GOOD);
            } else if (e.getSource() == this.setBadItem) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.BAD);
            } else if (e.getSource() == this.setCheckItem) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.CHECK);
            } else if (e.getSource() == this.setObserveItem) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.OBSERVE);
            }
        }

        private void initialize() {
            this.refreshLanguage();
            this.markMessageUnreadItem.addActionListener(this);
            this.markAllMessagesReadItem.addActionListener(this);
            this.markSelectedMessagesReadItem.addActionListener(this);
            this.markSelectedMessagesUnreadItem.addActionListener(this);
            this.markThreadReadItem.addActionListener(this);
            this.setGoodItem.addActionListener(this);
            this.setBadItem.addActionListener(this);
            this.setCheckItem.addActionListener(this);
            this.setObserveItem.addActionListener(this);
            this.deleteItem.addActionListener(this);
            this.undeleteItem.addActionListener(this);
            this.expandAllItem.addActionListener(this);
            this.collapseAllItem.addActionListener(this);
            this.expandThreadItem.addActionListener(this);
            this.collapseThreadItem.addActionListener(this);
        }

        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }

        private void refreshLanguage() {
            this.markMessageUnreadItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.markMessageUnread"));
            this.markAllMessagesReadItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.markAllMessagesRead"));
            this.markSelectedMessagesReadItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.markSelectedMessagesReadItem"));
            this.markSelectedMessagesUnreadItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.markSelectedMessagesUnreadItem"));
            this.markThreadReadItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.markThreadRead"));
            this.setGoodItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.setToGood"));
            this.setBadItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.setToBad"));
            this.setCheckItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.setToCheck"));
            this.setObserveItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.setToObserve"));
            this.deleteItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.deleteMessage"));
            this.undeleteItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.undeleteMessage"));
            this.expandAllItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.expandAll"));
            this.collapseAllItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.collapseAll"));
            this.expandThreadItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.expandThread"));
            this.collapseThreadItem.setText(MessagePanel.this.language.getString("MessagePane.messageTable.popupmenu.collapseThread"));
        }

        public void show(Component invoker, int x, int y) {
            if (MessagePanel.this.messageTable.getSelectedRowCount() < 1) {
                return;
            }
            if (MessagePanel.this.mainFrame.getTofTreeModel().getSelectedNode().isBoard()) {
                this.removeAll();
                if (MessagePanel.this.messageTable.getSelectedRowCount() > 1) {
                    this.add(this.markSelectedMessagesReadItem);
                    this.add(this.markSelectedMessagesUnreadItem);
                    this.addSeparator();
                    this.add(this.deleteItem);
                    this.add(this.undeleteItem);
                    this.addSeparator();
                    this.add(this.setGoodItem);
                    this.add(this.setObserveItem);
                    this.add(this.setCheckItem);
                    this.add(this.setBadItem);
                    this.deleteItem.setEnabled(true);
                    this.undeleteItem.setEnabled(true);
                    this.setGoodItem.setEnabled(true);
                    this.setObserveItem.setEnabled(true);
                    this.setCheckItem.setEnabled(true);
                    this.setBadItem.setEnabled(true);
                    super.show(invoker, x, y);
                    return;
                }
                if (Core.frostSettings.getBoolValue("MessagePanel.showThreads")) {
                    if (MessagePanel.this.messageTable.getSelectedRowCount() == 1) {
                        this.add(this.expandThreadItem);
                        this.add(this.collapseThreadItem);
                    }
                    this.add(this.expandAllItem);
                    this.add(this.collapseAllItem);
                    this.addSeparator();
                }
                boolean itemAdded = false;
                if (MessagePanel.this.messageTable.getSelectedRow() > -1) {
                    this.add(this.markMessageUnreadItem);
                    itemAdded = true;
                }
                if (MessagePanel.this.selectedMessage != null && MessagePanel.this.selectedMessage.getBoard().getNewMessageCount() > 0) {
                    this.add(this.markAllMessagesReadItem);
                    this.add(this.markThreadReadItem);
                    itemAdded = true;
                }
                if (itemAdded) {
                    this.addSeparator();
                }
                this.add(this.setGoodItem);
                this.add(this.setObserveItem);
                this.add(this.setCheckItem);
                this.add(this.setBadItem);
                this.setGoodItem.setEnabled(false);
                this.setObserveItem.setEnabled(false);
                this.setCheckItem.setEnabled(false);
                this.setBadItem.setEnabled(false);
                if (MessagePanel.this.messageTable.getSelectedRow() > -1 && MessagePanel.this.selectedMessage != null && !MessagePanel.this.identities.isMySelf(MessagePanel.this.selectedMessage.getFromName())) {
                    if (MessagePanel.this.selectedMessage.isMessageStatusGOOD()) {
                        this.setObserveItem.setEnabled(true);
                        this.setCheckItem.setEnabled(true);
                        this.setBadItem.setEnabled(true);
                    } else if (MessagePanel.this.selectedMessage.isMessageStatusCHECK()) {
                        this.setObserveItem.setEnabled(true);
                        this.setGoodItem.setEnabled(true);
                        this.setBadItem.setEnabled(true);
                    } else if (MessagePanel.this.selectedMessage.isMessageStatusBAD()) {
                        this.setObserveItem.setEnabled(true);
                        this.setGoodItem.setEnabled(true);
                        this.setCheckItem.setEnabled(true);
                    } else if (MessagePanel.this.selectedMessage.isMessageStatusOBSERVE()) {
                        this.setGoodItem.setEnabled(true);
                        this.setCheckItem.setEnabled(true);
                        this.setBadItem.setEnabled(true);
                    } else if (!MessagePanel.this.selectedMessage.isMessageStatusOLD() && !MessagePanel.this.selectedMessage.isMessageStatusTAMPERED()) {
                        MessagePanel.this.logger.warning("invalid message state");
                    }
                }
                if (MessagePanel.this.selectedMessage != null) {
                    this.addSeparator();
                    this.add(this.deleteItem);
                    this.add(this.undeleteItem);
                    this.deleteItem.setEnabled(false);
                    this.undeleteItem.setEnabled(false);
                    if (MessagePanel.this.selectedMessage.isDeleted()) {
                        this.undeleteItem.setEnabled(true);
                    } else {
                        this.deleteItem.setEnabled(true);
                    }
                }
                super.show(invoker, x, y);
            }
        }
    }

    private class PopupMenuSubjectText
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        JMenuItem copySubjectText = new JMenuItem();

        public PopupMenuSubjectText() {
            this.initialize();
        }

        private void initialize() {
            this.refreshLanguage();
            this.copySubjectText.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.copySubjectText) {
                CopyToClipboard.copyText(MessagePanel.this.subjectTextLabel.getText());
            }
        }

        public void show(Component invoker, int x, int y) {
            this.removeAll();
            this.add(this.copySubjectText);
            super.show(invoker, x, y);
        }

        private void refreshLanguage() {
            this.copySubjectText.setText(MessagePanel.this.language.getString("MessagePane.subjectText.popupmenu.copySubjectText"));
        }

        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    ListSelectionListener,
    TreeSelectionListener,
    LanguageListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MessagePanel.this.updateBoardButton) {
                MessagePanel.this.updateButton_actionPerformed(e);
            } else if (e.getSource() == MessagePanel.this.newMessageButton) {
                MessagePanel.this.newMessageButton_actionPerformed();
            } else if (e.getSource() == MessagePanel.this.replyButton) {
                MessagePanel.this.replyButton_actionPerformed(e);
            } else if (e.getSource() == MessagePanel.this.saveMessageButton) {
                MessagePanel.this.getMessageTextPane().saveMessageButton_actionPerformed();
            } else if (e.getSource() == MessagePanel.this.nextUnreadMessageButton) {
                MessagePanel.this.selectNextUnreadMessage();
            } else if (e.getSource() == MessagePanel.this.setGoodButton) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.GOOD);
            } else if (e.getSource() == MessagePanel.this.setBadButton) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.BAD);
            } else if (e.getSource() == MessagePanel.this.setCheckButton) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.CHECK);
            } else if (e.getSource() == MessagePanel.this.setObserveButton) {
                MessagePanel.this.setTrustState_actionPerformed(IdentityState.OBSERVE);
            } else if (e.getSource() == MessagePanel.this.toggleShowUnreadOnly) {
                MessagePanel.this.toggleShowUnreadOnly_actionPerformed(e);
            } else if (e.getSource() == MessagePanel.this.toggleShowThreads) {
                MessagePanel.this.toggleShowThreads_actionPerformed(e);
            } else if (e.getSource() == MessagePanel.this.toggleShowSmileys) {
                MessagePanel.this.toggleShowSmileys_actionPerformed(e);
            } else if (e.getSource() == MessagePanel.this.toggleShowHyperlinks) {
                MessagePanel.this.toggleShowHyperlinks_actionPerformed(e);
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (e.getComponent() == MessagePanel.this.messageTable) {
                    MessagePanel.this.showMessageTablePopupMenu(e);
                } else if (e.getComponent() == MessagePanel.this.subjectTextLabel) {
                    MessagePanel.this.getPopupMenuSubjectText().show(e.getComponent(), e.getX(), e.getY());
                }
            } else if (SwingUtilities.isLeftMouseButton(e) && e.getID() == 501) {
                if (e.getClickCount() == 2 && e.getComponent() == MessagePanel.this.messageTable) {
                    MessagePanel.this.showCurrentMessagePopupWindow();
                } else if (e.getClickCount() == 1 && e.getComponent() == MessagePanel.this.messageTable) {
                    int row = MessagePanel.this.messageTable.rowAtPoint(e.getPoint());
                    int col = MessagePanel.this.messageTable.columnAtPoint(e.getPoint());
                    if (row > -1 && col > -1) {
                        int modelCol = MessagePanel.this.messageTable.getColumnModel().getColumn(col).getModelIndex();
                        this.editIconColumn(row, modelCol);
                    }
                }
            }
        }

        protected void editIconColumn(int row, int modelCol) {
            BooleanState state;
            switch (modelCol) {
                case 0: {
                    state = BooleanState.FLAGGED;
                    break;
                }
                case 1: {
                    state = BooleanState.STARRED;
                    break;
                }
                case 5: {
                    state = BooleanState.JUNK;
                    break;
                }
                default: {
                    return;
                }
            }
            FrostMessageObject message = (FrostMessageObject)MessagePanel.this.getMessageTableModel().getRow(row);
            if (message == null || message.isDummy()) {
                return;
            }
            MessagePanel.this.updateBooleanState(state, Collections.singletonList(message));
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void valueChanged(ListSelectionEvent e) {
            MessagePanel.this.messageTable_itemSelected(e);
        }

        public void valueChanged(TreeSelectionEvent e) {
            MessagePanel.this.boardsTree_actionPerformed(e);
        }

        public void languageChanged(LanguageEvent event) {
            MessagePanel.this.refreshLanguage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanState {
        FLAGGED,
        STARRED,
        JUNK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IdentityState {
        GOOD,
        CHECK,
        OBSERVE,
        BAD;

    }
}

