/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.fileTransfer.FileTransferInformation;
import frost.threads.RunningMessageThreadsInformation;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class MainFrameStatusBar
extends JPanel {
    private final Language language = Language.getInstance();
    private JLabel statusLabelTofup = null;
    private JLabel statusLabelTofdn = null;
    private JLabel statusLabelBoard = null;
    private JLabel statusMessageLabel = null;
    private JLabel downloadingFilesLabel = null;
    private JLabel uploadingFilesLabel = null;
    private JLabel fileListDownloadQueueSizeLabel = null;
    private RunningMessageThreadsInformation statusBarInformations = null;
    private static ImageIcon[] newMessage = new ImageIcon[2];

    public MainFrameStatusBar() {
        this.initialize();
    }

    private void initialize() {
        this.uploadingFilesLabel = new JLabel();
        this.downloadingFilesLabel = new JLabel();
        JPanel p0 = new JPanel(new FlowLayout(0, 2, 0));
        p0.add(this.uploadingFilesLabel);
        p0.add(new JLabel(" "));
        p0.add(this.downloadingFilesLabel);
        p0.setBorder(BorderFactory.createBevelBorder(1));
        p0.setAlignmentY(0.5f);
        this.statusLabelTofup = new JLabel(){

            public String getToolTipText(MouseEvent me) {
                if (MainFrameStatusBar.this.statusBarInformations == null) {
                    return null;
                }
                String txt = MainFrameStatusBar.this.language.formatMessage("MainFrameStatusBar.tooltip.tofup", Integer.toString(MainFrameStatusBar.this.statusBarInformations.getUploadingMessagesCount()), Integer.toString(MainFrameStatusBar.this.statusBarInformations.getUnsentMessageCount()), Integer.toString(MainFrameStatusBar.this.statusBarInformations.getAttachmentsToUploadRemainingCount()));
                return txt;
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.statusLabelTofup);
        JPanel p1 = new JPanel(new FlowLayout(0, 0, 0));
        p1.add(this.statusLabelTofup);
        p1.setBorder(BorderFactory.createBevelBorder(1));
        p1.setAlignmentY(0.5f);
        this.statusLabelTofdn = new JLabel(){

            public String getToolTipText(MouseEvent me) {
                if (MainFrameStatusBar.this.statusBarInformations == null) {
                    return null;
                }
                String txt = MainFrameStatusBar.this.language.formatMessage("MainFrameStatusBar.tooltip.tofdn", Integer.toString(MainFrameStatusBar.this.statusBarInformations.getDownloadingBoardCount()), Integer.toString(MainFrameStatusBar.this.statusBarInformations.getRunningDownloadThreadCount()));
                return txt;
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.statusLabelTofdn);
        JPanel p2 = new JPanel(new FlowLayout(0, 0, 0));
        p2.add(this.statusLabelTofdn);
        p2.setBorder(BorderFactory.createBevelBorder(1));
        p2.setAlignmentY(0.5f);
        JPanel p3 = null;
        if (Core.isFreenetOnline() && !Core.frostSettings.getBoolValue("disableFilesharing")) {
            this.fileListDownloadQueueSizeLabel = new JLabel(){

                public String getToolTipText(MouseEvent me) {
                    String txt = MainFrameStatusBar.this.language.getString("MainFrame.statusBar.tooltip.fileListDownloadQueueSize");
                    return txt;
                }
            };
            ToolTipManager.sharedInstance().registerComponent(this.fileListDownloadQueueSizeLabel);
            p3 = new JPanel(new FlowLayout(0, 0, 0));
            p3.add(this.fileListDownloadQueueSizeLabel);
            p3.setBorder(BorderFactory.createBevelBorder(1));
            p3.setAlignmentY(0.5f);
        }
        this.statusLabelBoard = new JLabel();
        JPanel p4 = new JPanel(new FlowLayout(0, 0, 0));
        p4.add(this.statusLabelBoard);
        p4.setBorder(BorderFactory.createBevelBorder(1));
        p4.setAlignmentY(0.5f);
        this.statusMessageLabel = new JLabel();
        this.statusMessageLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        JPanel p5 = new JPanel(new FlowLayout(0, 0, 0));
        p5.add(this.statusMessageLabel);
        p5.setBorder(BorderFactory.createBevelBorder(1));
        p5.setAlignmentY(0.5f);
        MainFrameStatusBar.newMessage[0] = MiscToolkit.loadImageIcon("/data/messagebright.gif");
        MainFrameStatusBar.newMessage[1] = MiscToolkit.loadImageIcon("/data/messagedark.gif");
        this.statusMessageLabel.setIcon(newMessage[1]);
        int currGridX = 0;
        GridBagConstraints gridBagConstraints0 = new GridBagConstraints();
        gridBagConstraints0.gridx = currGridX++;
        gridBagConstraints0.anchor = 10;
        gridBagConstraints0.insets = new Insets(1, 2, 1, 1);
        gridBagConstraints0.fill = 3;
        gridBagConstraints0.gridy = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = currGridX++;
        gridBagConstraints1.anchor = 10;
        gridBagConstraints1.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints1.fill = 3;
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = currGridX++;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.gridy = 0;
        GridBagConstraints gridBagConstraints3 = null;
        if (this.fileListDownloadQueueSizeLabel != null) {
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = currGridX++;
            gridBagConstraints3.anchor = 10;
            gridBagConstraints3.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints3.fill = 3;
            gridBagConstraints3.gridy = 0;
        }
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = currGridX++;
        gridBagConstraints4.anchor = 10;
        gridBagConstraints4.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints4.fill = 3;
        gridBagConstraints4.gridy = 0;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = currGridX++;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.gridy = 0;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = currGridX++;
        gridBagConstraints6.anchor = 10;
        gridBagConstraints6.insets = new Insets(1, 1, 1, 2);
        gridBagConstraints6.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)p0, gridBagConstraints0);
        this.add((Component)p1, gridBagConstraints1);
        this.add((Component)p2, gridBagConstraints2);
        if (this.fileListDownloadQueueSizeLabel != null) {
            this.add((Component)p3, gridBagConstraints3);
        }
        this.add((Component)p4, gridBagConstraints4);
        this.add((Component)new JLabel(""), gridBagConstraints5);
        this.add((Component)p5, gridBagConstraints6);
    }

    public void setStatusBarInformations(FileTransferInformation finfo, RunningMessageThreadsInformation info, String selectedNode) {
        String newText;
        this.statusBarInformations = info;
        if (finfo != null) {
            StringBuilder sb = new StringBuilder().append(this.language.getString("MainFrame.statusBar.uploading")).append(": ").append(finfo.getUploadsRunning()).append(" ");
            if (finfo.getUploadsRunning() == 1) {
                sb.append(this.language.getString("MainFrame.statusBar.file"));
            } else {
                sb.append(this.language.getString("MainFrame.statusBar.files"));
            }
            this.uploadingFilesLabel.setText(sb.toString());
            sb = new StringBuilder().append(this.language.getString("MainFrame.statusBar.downloading")).append(": ").append(finfo.getDownloadsRunning()).append(" ");
            if (finfo.getUploadsRunning() == 1) {
                sb.append(this.language.getString("MainFrame.statusBar.file"));
            } else {
                sb.append(this.language.getString("MainFrame.statusBar.files"));
            }
            this.downloadingFilesLabel.setText(sb.toString());
            if (this.fileListDownloadQueueSizeLabel != null) {
                sb = new StringBuilder().append(" ").append(this.language.getString("MainFrame.statusBar.fileListDownloadQueueSize")).append(": ").append(finfo.getFileListDownloadQueueSize()).append(" ");
                this.fileListDownloadQueueSizeLabel.setText(sb.toString());
            }
        }
        if (info != null) {
            newText = " " + this.language.getString("MainFrame.statusBar.TOFUP") + ": " + info.getUploadingMessagesCount() + "U / " + info.getUnsentMessageCount() + "W / " + info.getAttachmentsToUploadRemainingCount() + "A ";
            this.statusLabelTofup.setText(newText);
            newText = " " + this.language.getString("MainFrame.statusBar.TOFDO") + ": " + info.getDownloadingBoardCount() + "B / " + info.getRunningDownloadThreadCount() + "T ";
            this.statusLabelTofdn.setText(newText);
        }
        newText = " " + this.language.getString("MainFrame.statusBar.selectedBoard") + ": " + selectedNode + " ";
        this.statusLabelBoard.setText(newText);
    }

    public void showNewMessageIcon(boolean show) {
        if (show) {
            this.statusMessageLabel.setIcon(newMessage[0]);
        } else {
            this.statusMessageLabel.setIcon(newMessage[1]);
        }
    }
}

