/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.Core;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.storage.perst.NewUploadFile;
import frost.util.Mixed;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenerateShaThread
extends Thread {
    private static final Logger logger = Logger.getLogger(GenerateShaThread.class.getName());
    private static final int wait1minute = 60000;
    FileQueue fileQueue = new FileQueue();

    public void addToFileQueue(NewUploadFile f) {
        this.fileQueue.appendFileToQueue(f);
    }

    public int getQueueSize() {
        return this.fileQueue.getQueueSize();
    }

    public void run() {
        int maxAllowedExceptions = 5;
        int occuredExceptions = 0;
        do {
            try {
                NewUploadFile newUploadFile;
                while ((newUploadFile = this.fileQueue.getFileFromQueue()) == null) {
                    Mixed.wait(60000);
                }
                File newFile = new File(newUploadFile.getFilePath());
                String sha = Core.getCrypto().computeChecksumSHA256(newFile);
                if (sha == null) continue;
                FrostSharedFileItem sfi = new FrostSharedFileItem(newFile, newUploadFile.getFrom(), sha);
                FileTransferManager.inst().getSharedFilesManager().getModel().addNewSharedFile(sfi, newUploadFile.isReplacePathIfFileExists());
                Core.getInstance().getFileTransferManager().getNewUploadFilesManager().deleteNewUploadFile(newUploadFile);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception catched", t);
                ++occuredExceptions;
            }
        } while (occuredExceptions <= 5);
        logger.log(Level.SEVERE, "Stopping GenerateShaThread because of too much exceptions");
    }

    private class FileQueue {
        private final LinkedList<NewUploadFile> queue = new LinkedList();

        private FileQueue() {
        }

        public synchronized NewUploadFile getFileFromQueue() {
            try {
                while (this.queue.isEmpty()) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                return null;
            }
            if (!this.queue.isEmpty()) {
                NewUploadFile key = this.queue.removeFirst();
                return key;
            }
            return null;
        }

        public synchronized void appendFileToQueue(NewUploadFile f) {
            this.queue.addLast(f);
            this.notifyAll();
        }

        public synchronized int getQueueSize() {
            return this.queue.size();
        }
    }
}

