/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.sharing;

import frost.Core;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.gui.RatingStringProvider;
import frost.util.DateFun;
import frost.util.FormatterUtils;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.ModelTable;
import frost.util.model.SortedModelTable;
import frost.util.model.SortedTableFormat;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class SharedFilesTableFormat
extends SortedTableFormat
implements LanguageListener,
PropertyChangeListener {
    private static final String CFGKEY_SORTSTATE_SORTEDCOLUMN = "SharedFilesTable.sortState.sortedColumn";
    private static final String CFGKEY_SORTSTATE_SORTEDASCENDING = "SharedFilesTable.sortState.sortedAscending";
    private static final String CFGKEY_COLUMN_TABLEINDEX = "SharedFilesTable.tableindex.modelcolumn.";
    private static final String CFGKEY_COLUMN_WIDTH = "SharedFilesTable.columnwidth.modelcolumn.";
    private Language language = Language.getInstance();
    private static final int COLUMN_COUNT = 13;
    private String stateNever;
    private String unknown;
    private boolean showColoredLines;
    SortedModelTable modelTable;

    public SharedFilesTableFormat() {
        super(13);
        this.language.addLanguageListener(this);
        this.refreshLanguage();
        this.setComparator(new NameComparator(), 0);
        this.setComparator(new FileSizeComparator(), 1);
        this.setComparator(new OwnerComparator(), 2);
        this.setComparator(new UploadCountComparator(), 3);
        this.setComparator(new LastUploadComparator(), 4);
        this.setComparator(new RequestCountComparator(), 5);
        this.setComparator(new LastRequestComparator(), 6);
        this.setComparator(new KeyComparator(), 7);
        this.setComparator(new RatingComparator(), 8);
        this.setComparator(new CommentComparator(), 9);
        this.setComparator(new KeywordsComparator(), 10);
        this.setComparator(new LastSharedComparator(), 11);
        this.setComparator(new PathComparator(), 12);
        this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
        Core.frostSettings.addPropertyChangeListener(this);
    }

    private void refreshLanguage() {
        this.setColumnName(0, this.language.getString("SharedFilesPane.fileTable.filename"));
        this.setColumnName(1, this.language.getString("SharedFilesPane.fileTable.size"));
        this.setColumnName(2, this.language.getString("SharedFilesPane.fileTable.owner"));
        this.setColumnName(3, this.language.getString("SharedFilesPane.fileTable.uploadCount"));
        this.setColumnName(4, this.language.getString("SharedFilesPane.fileTable.lastUpload"));
        this.setColumnName(5, this.language.getString("SharedFilesPane.fileTable.requestCount"));
        this.setColumnName(6, this.language.getString("SharedFilesPane.fileTable.lastRequest"));
        this.setColumnName(7, this.language.getString("SharedFilesPane.fileTable.key"));
        this.setColumnName(8, this.language.getString("SharedFilesPane.fileTable.rating"));
        this.setColumnName(9, this.language.getString("SharedFilesPane.fileTable.comment"));
        this.setColumnName(10, this.language.getString("SharedFilesPane.fileTable.keywords"));
        this.setColumnName(11, this.language.getString("SharedFilesPane.fileTable.lastShared"));
        this.setColumnName(12, this.language.getString("SharedFilesPane.fileTable.path"));
        this.stateNever = this.language.getString("SharedFilesPane.fileTable.state.never");
        this.unknown = this.language.getString("SharedFilesPane.fileTable.state.unknown");
        this.refreshColumnNames();
    }

    public void setCellValue(Object value, ModelItem item, int columnIndex) {
    }

    public Object getCellValue(ModelItem item, int columnIndex) {
        if (item == null) {
            return "*null*";
        }
        FrostSharedFileItem sfItem = (FrostSharedFileItem)item;
        switch (columnIndex) {
            case 0: {
                return sfItem.getFile().getName();
            }
            case 1: {
                return FormatterUtils.formatSize(sfItem.getFileSize());
            }
            case 2: {
                return sfItem.getOwner();
            }
            case 3: {
                return Integer.toString(sfItem.getUploadCount());
            }
            case 4: {
                if (sfItem.getLastUploaded() == 0L) {
                    return this.stateNever;
                }
                return DateFun.getExtendedDateFromMillis(sfItem.getLastUploaded());
            }
            case 5: {
                return Integer.toString(sfItem.getRequestsReceived());
            }
            case 6: {
                if (sfItem.getRequestLastReceived() == 0L) {
                    return this.stateNever;
                }
                return DateFun.getExtendedDateFromMillis(sfItem.getRequestLastReceived());
            }
            case 7: {
                if (sfItem.getKey() == null) {
                    return this.unknown;
                }
                return sfItem.getKey();
            }
            case 8: {
                return RatingStringProvider.getRatingString(sfItem.getRating());
            }
            case 9: {
                if (sfItem.getComment() == null) {
                    return "";
                }
                return sfItem.getComment();
            }
            case 10: {
                if (sfItem.getKeywords() == null) {
                    return "";
                }
                return sfItem.getKeywords();
            }
            case 11: {
                if (sfItem.getRefLastSent() == 0L) {
                    return this.stateNever;
                }
                return DateFun.getExtendedDateFromMillis(sfItem.getRefLastSent());
            }
            case 12: {
                if (sfItem.isValid()) {
                    return sfItem.getFile().getPath();
                }
                return "???";
            }
        }
        return "**ERROR**";
    }

    public void customizeTable(ModelTable lModelTable) {
        super.customizeTable(lModelTable);
        this.modelTable = (SortedModelTable)lModelTable;
        if (Core.frostSettings.getBoolValue("saveSortStates") && Core.frostSettings.getObjectValue(CFGKEY_SORTSTATE_SORTEDCOLUMN) != null && Core.frostSettings.getObjectValue(CFGKEY_SORTSTATE_SORTEDASCENDING) != null) {
            int sortedColumn = Core.frostSettings.getIntValue(CFGKEY_SORTSTATE_SORTEDCOLUMN);
            boolean isSortedAsc = Core.frostSettings.getBoolValue(CFGKEY_SORTSTATE_SORTEDASCENDING);
            if (sortedColumn > -1) {
                this.modelTable.setSortedColumn(sortedColumn, isSortedAsc);
            }
        } else {
            this.modelTable.setSortedColumn(0, true);
        }
        lModelTable.getTable().setAutoResizeMode(1);
        TableColumnModel columnModel = lModelTable.getTable().getColumnModel();
        ShowContentTooltipRenderer showContentTooltipRenderer = new ShowContentTooltipRenderer();
        RightAlignRenderer numberRightRenderer = new RightAlignRenderer();
        BaseRenderer baseRenderer = new BaseRenderer();
        columnModel.getColumn(0).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(1).setCellRenderer(numberRightRenderer);
        columnModel.getColumn(2).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(3).setCellRenderer(numberRightRenderer);
        columnModel.getColumn(4).setCellRenderer(baseRenderer);
        columnModel.getColumn(5).setCellRenderer(numberRightRenderer);
        columnModel.getColumn(6).setCellRenderer(baseRenderer);
        columnModel.getColumn(7).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(8).setCellRenderer(baseRenderer);
        columnModel.getColumn(9).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(10).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(11).setCellRenderer(baseRenderer);
        columnModel.getColumn(12).setCellRenderer(showContentTooltipRenderer);
        if (!this.loadTableLayout(columnModel)) {
            int[] widths = new int[]{150, 65, 80, 40, 60, 40, 60, 80, 30, 50, 50, 60, 50};
            for (int i = 0; i < widths.length; ++i) {
                columnModel.getColumn(i).setPreferredWidth(widths[i]);
            }
        }
    }

    public void saveTableLayout() {
        TableColumnModel tcm = this.modelTable.getTable().getColumnModel();
        for (int columnIndexInTable = 0; columnIndexInTable < tcm.getColumnCount(); ++columnIndexInTable) {
            TableColumn tc = tcm.getColumn(columnIndexInTable);
            int columnIndexInModel = tc.getModelIndex();
            Core.frostSettings.setValue(CFGKEY_COLUMN_TABLEINDEX + columnIndexInModel, columnIndexInTable);
            int columnWidth = tc.getWidth();
            Core.frostSettings.setValue(CFGKEY_COLUMN_WIDTH + columnIndexInModel, columnWidth);
        }
        if (Core.frostSettings.getBoolValue("saveSortStates") && this.modelTable.getSortedColumn() > -1) {
            int sortedColumn = this.modelTable.getSortedColumn();
            boolean isSortedAsc = this.modelTable.isSortedAscending();
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDCOLUMN, sortedColumn);
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDASCENDING, isSortedAsc);
        }
    }

    private boolean loadTableLayout(TableColumnModel tcm) {
        int x;
        int[] tableToModelIndex = new int[tcm.getColumnCount()];
        int[] columnWidths = new int[tcm.getColumnCount()];
        for (int x2 = 0; x2 < tableToModelIndex.length; ++x2) {
            String indexKey = CFGKEY_COLUMN_TABLEINDEX + x2;
            if (Core.frostSettings.getObjectValue(indexKey) == null) {
                return false;
            }
            int tableIndex = Core.frostSettings.getIntValue(indexKey);
            if (tableIndex < 0 || tableIndex >= tableToModelIndex.length) {
                return false;
            }
            tableToModelIndex[tableIndex] = x2;
            String widthKey = CFGKEY_COLUMN_WIDTH + x2;
            if (Core.frostSettings.getObjectValue(widthKey) == null) {
                return false;
            }
            int columnWidth = Core.frostSettings.getIntValue(widthKey);
            if (columnWidth <= 0) {
                return false;
            }
            columnWidths[x2] = columnWidth;
        }
        TableColumn[] tcms = new TableColumn[tcm.getColumnCount()];
        for (x = tcms.length - 1; x >= 0; --x) {
            tcms[x] = tcm.getColumn(x);
            tcm.removeColumn(tcms[x]);
            tcms[x].setPreferredWidth(columnWidths[x]);
        }
        for (x = 0; x < tableToModelIndex.length; ++x) {
            tcm.addColumn(tcms[tableToModelIndex[x]]);
        }
        return true;
    }

    public int[] getColumnNumbers(int fieldID) {
        return null;
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showColoredRows")) {
            this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
            this.modelTable.fireTableDataChanged();
        }
    }

    private class BaseRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                FrostSharedFileItem sfItem;
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, SharedFilesTableFormat.this.showColoredLines);
                ModelItem item = SharedFilesTableFormat.this.modelTable.getItemAt(row);
                if (item != null && !(sfItem = (FrostSharedFileItem)item).isValid()) {
                    newBackground = TableBackgroundColors.getBackgroundColorFailed(table, row, SharedFilesTableFormat.this.showColoredLines);
                }
                this.setBackground(newBackground);
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathComparator
    implements Comparator<FrostSharedFileItem> {
        private PathComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem item1, FrostSharedFileItem item2) {
            return item1.getFile().getPath().compareToIgnoreCase(item2.getFile().getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastSharedComparator
    implements Comparator<FrostSharedFileItem> {
        private LastSharedComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem item1, FrostSharedFileItem item2) {
            if (item1.getRefLastSent() > item2.getRefLastSent()) {
                return 1;
            }
            if (item1.getRefLastSent() < item2.getRefLastSent()) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeywordsComparator
    implements Comparator<FrostSharedFileItem> {
        private KeywordsComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem o1, FrostSharedFileItem o2) {
            String key1 = o1.getKeywords();
            String key2 = o2.getKeywords();
            if (key1 == null) {
                key1 = SharedFilesTableFormat.this.unknown;
            }
            if (key2 == null) {
                key2 = SharedFilesTableFormat.this.unknown;
            }
            return key1.compareToIgnoreCase(key2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommentComparator
    implements Comparator<FrostSharedFileItem> {
        private CommentComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem o1, FrostSharedFileItem o2) {
            String key1 = o1.getComment();
            String key2 = o2.getComment();
            if (key1 == null) {
                key1 = SharedFilesTableFormat.this.unknown;
            }
            if (key2 == null) {
                key2 = SharedFilesTableFormat.this.unknown;
            }
            return key1.compareToIgnoreCase(key2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RatingComparator
    implements Comparator<FrostSharedFileItem> {
        private RatingComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem item1, FrostSharedFileItem item2) {
            if (item1.getRating() > item2.getRating()) {
                return 1;
            }
            if (item1.getRating() < item2.getRating()) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyComparator
    implements Comparator<FrostSharedFileItem> {
        private KeyComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem o1, FrostSharedFileItem o2) {
            String key1 = o1.getKey();
            String key2 = o2.getKey();
            if (key1 == null) {
                key1 = SharedFilesTableFormat.this.unknown;
            }
            if (key2 == null) {
                key2 = SharedFilesTableFormat.this.unknown;
            }
            return key1.compareToIgnoreCase(key2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastRequestComparator
    implements Comparator<FrostSharedFileItem> {
        private LastRequestComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem item1, FrostSharedFileItem item2) {
            if (item1.getRequestLastReceived() > item2.getRequestLastReceived()) {
                return 1;
            }
            if (item1.getRequestLastReceived() < item2.getRequestLastReceived()) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestCountComparator
    implements Comparator<FrostSharedFileItem> {
        private RequestCountComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem item1, FrostSharedFileItem item2) {
            if (item1.getRequestsReceived() > item2.getRequestsReceived()) {
                return 1;
            }
            if (item1.getRequestsReceived() < item2.getRequestsReceived()) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastUploadComparator
    implements Comparator<FrostSharedFileItem> {
        private LastUploadComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem item1, FrostSharedFileItem item2) {
            if (item1.getLastUploaded() > item2.getLastUploaded()) {
                return 1;
            }
            if (item1.getLastUploaded() < item2.getLastUploaded()) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UploadCountComparator
    implements Comparator<FrostSharedFileItem> {
        private UploadCountComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem item1, FrostSharedFileItem item2) {
            if (item1.getUploadCount() > item2.getUploadCount()) {
                return 1;
            }
            if (item1.getUploadCount() < item2.getUploadCount()) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OwnerComparator
    implements Comparator<FrostSharedFileItem> {
        private OwnerComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem item1, FrostSharedFileItem item2) {
            return item1.getOwner().compareToIgnoreCase(item2.getOwner());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileSizeComparator
    implements Comparator<FrostSharedFileItem> {
        private FileSizeComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem item1, FrostSharedFileItem item2) {
            if (item1.getFileSize() > item2.getFileSize()) {
                return 1;
            }
            if (item1.getFileSize() < item2.getFileSize()) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameComparator
    implements Comparator<FrostSharedFileItem> {
        private NameComparator() {
        }

        @Override
        public int compare(FrostSharedFileItem item1, FrostSharedFileItem item2) {
            return item1.getFile().getName().compareToIgnoreCase(item2.getFile().getName());
        }
    }

    private class RightAlignRenderer
    extends BaseRenderer {
        final EmptyBorder border = new EmptyBorder(0, 0, 0, 3);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(4);
            this.setBorder(this.border);
            return this;
        }
    }

    private class ShowContentTooltipRenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            if (value != null && (tooltip = value.toString()).length() == 0) {
                tooltip = null;
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }
}

