/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.sharing;

import frost.Core;
import frost.MainFrame;
import frost.fcp.FcpHandler;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.fileTransfer.sharing.SharedFilesModel;
import frost.fileTransfer.sharing.SharedFilesOwnerDialog;
import frost.fileTransfer.sharing.SharedFilesPropertiesDialog;
import frost.fileTransfer.sharing.SharedFilesTableFormat;
import frost.storage.perst.NewUploadFile;
import frost.threads.FileListUploadThread;
import frost.util.CopyToClipboard;
import frost.util.FileAccess;
import frost.util.FormatterUtils;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.search.TableFindAction;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.ModelTable;
import frost.util.model.SortedModelListener;
import frost.util.model.SortedModelTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class SharedFilesPanel
extends JPanel {
    private PopupMenu popupMenuUpload = null;
    private final Listener listener = new Listener();
    private static final Logger logger = Logger.getLogger(SharedFilesPanel.class.getName());
    private SharedFilesModel model = null;
    private Language language = null;
    private final JToolBar sharedFilesToolBar = new JToolBar();
    private final JButton addSharedFilesButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/folder-open.png"));
    private int sharedFilesCount = 0;
    private final JLabel sharedFilesCountLabel = new JLabel();
    private SortedModelTable modelTable;
    private boolean initialized = false;

    public SharedFilesPanel() {
        this.language = Language.getInstance();
        this.language.addLanguageListener(this.listener);
    }

    public void initialize() {
        if (!this.initialized) {
            this.refreshLanguage();
            MiscToolkit.configureButton(this.addSharedFilesButton);
            this.sharedFilesToolBar.setRollover(true);
            this.sharedFilesToolBar.setFloatable(false);
            this.sharedFilesToolBar.add(this.addSharedFilesButton);
            this.sharedFilesToolBar.add(Box.createRigidArea(new Dimension(80, 0)));
            this.sharedFilesToolBar.add(Box.createHorizontalGlue());
            this.sharedFilesToolBar.add(this.sharedFilesCountLabel);
            this.modelTable = new SortedModelTable(this.model);
            new TableFindAction().install(this.modelTable.getTable());
            this.setLayout(new BorderLayout());
            this.add((Component)this.sharedFilesToolBar, "North");
            this.add((Component)this.modelTable.getScrollPane(), "Center");
            this.fontChanged();
            this.addSharedFilesButton.addActionListener(this.listener);
            this.modelTable.getScrollPane().addMouseListener(this.listener);
            this.modelTable.getTable().addKeyListener(this.listener);
            this.modelTable.getTable().addMouseListener(this.listener);
            Core.frostSettings.addPropertyChangeListener("fileListFontName", this.listener);
            Core.frostSettings.addPropertyChangeListener("fileListFontSize", this.listener);
            Core.frostSettings.addPropertyChangeListener("fileListFontStyle", this.listener);
            this.initialized = true;
        }
    }

    public SharedFilesTableFormat getTableFormat() {
        return (SharedFilesTableFormat)this.modelTable.getTableFormat();
    }

    public ModelTable getModelTable() {
        return this.modelTable;
    }

    public void setAddFilesButtonEnabled(boolean enabled) {
        this.addSharedFilesButton.setEnabled(enabled);
    }

    private Dimension calculateLabelSize(String text) {
        JLabel dummyLabel = new JLabel(text);
        dummyLabel.doLayout();
        return dummyLabel.getPreferredSize();
    }

    private void refreshLanguage() {
        this.addSharedFilesButton.setToolTipText(this.language.getString("SharedFilesPane.toolbar.tooltip.browse") + "...");
        String waiting = this.language.getString("SharedFilesPane.toolbar.files");
        Dimension labelSize = this.calculateLabelSize(waiting + ": 00000  (9876MB)");
        this.sharedFilesCountLabel.setPreferredSize(labelSize);
        this.sharedFilesCountLabel.setMinimumSize(labelSize);
        this.sharedFilesCountLabel.setText(waiting + ": " + this.sharedFilesCount);
    }

    private PopupMenu getPopupMenuUpload() {
        if (this.popupMenuUpload == null) {
            this.popupMenuUpload = new PopupMenu();
            this.language.addLanguageListener(this.popupMenuUpload);
        }
        return this.popupMenuUpload;
    }

    private void uploadTable_keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\u007f' && !this.modelTable.getTable().isEditing()) {
            this.removeSelectedFiles();
        }
    }

    private void removeSelectedFiles() {
        ModelItem[] selectedItems = this.modelTable.getSelectedItems();
        this.model.removeItems(selectedItems);
        this.modelTable.getTable().clearSelection();
        FileListUploadThread.getInstance().userActionOccured();
    }

    public void uploadAddFilesButton_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(Core.frostSettings.getValue("lastUsedDirectory"));
        fc.setDialogTitle(this.language.getString("SharedFilesPane.filechooser.title"));
        fc.setFileHidingEnabled(true);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setPreferredSize(new Dimension(600, 400));
        if (fc.showOpenDialog(this) != 0) {
            return;
        }
        File[] selectedFiles = fc.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        SharedFilesOwnerDialog dlg = new SharedFilesOwnerDialog((Frame)MainFrame.getInstance(), this.language.getString("SharedFilesOwnerDialog.title"));
        if (dlg.showDialog() == SharedFilesOwnerDialog.CANCEL) {
            return;
        }
        String owner = dlg.getChoosedIdentityName();
        boolean replacePathIfFileExists = dlg.isReplacePathIfFileExists();
        new AddNewSharedFilesThread(selectedFiles, owner, replacePathIfFileExists).start();
    }

    private void showUploadTablePopupMenu(MouseEvent e) {
        Point p = e.getPoint();
        int y = this.modelTable.getTable().rowAtPoint(p);
        if (y < 0) {
            return;
        }
        if (!this.modelTable.getTable().getSelectionModel().isSelectedIndex(y)) {
            this.modelTable.getTable().getSelectionModel().setSelectionInterval(y, y);
        }
        this.getPopupMenuUpload().show(e.getComponent(), e.getX(), e.getY());
    }

    private void fontChanged() {
        int fontSize;
        int fontStyle;
        String fontName = Core.frostSettings.getValue("fileListFontName");
        Font font = new Font(fontName, fontStyle = Core.frostSettings.getIntValue("fileListFontStyle"), fontSize = Core.frostSettings.getIntValue("fileListFontSize"));
        if (!font.getFamily().equals(fontName)) {
            logger.severe("The selected font was not found in your system\nThat selection will be changed to \"SansSerif\".");
            Core.frostSettings.setValue("fileListFontName", "SansSerif");
            font = new Font("SansSerif", fontStyle, fontSize);
        }
        this.modelTable.setFont(font);
    }

    public void setModel(SharedFilesModel model) {
        this.model = model;
        model.addOrderedModelListener(new SortedModelListener(){

            public void modelCleared() {
                SharedFilesPanel.this.updateSharedFilesItemCount();
            }

            public void itemAdded(int position, ModelItem item) {
                SharedFilesPanel.this.updateSharedFilesItemCount();
            }

            public void itemChanged(int position, ModelItem item) {
            }

            public void itemsRemoved(int[] positions, ModelItem[] items) {
                SharedFilesPanel.this.updateSharedFilesItemCount();
            }
        });
    }

    private void showProperties() {
        ModelItem[] selectedItems = this.modelTable.getSelectedItems();
        if (selectedItems.length == 0) {
            return;
        }
        LinkedList<FrostSharedFileItem> items = new LinkedList<FrostSharedFileItem>();
        for (ModelItem element : selectedItems) {
            FrostSharedFileItem item = (FrostSharedFileItem)element;
            items.add(item);
        }
        FrostSharedFileItem defaultItem = (FrostSharedFileItem)items.get(0);
        SharedFilesPropertiesDialog dlg = new SharedFilesPropertiesDialog(MainFrame.getInstance());
        String singleFilename = null;
        int fileCount = 0;
        if (items.size() == 1) {
            singleFilename = defaultItem.getFile().getName();
        } else {
            fileCount = items.size();
        }
        boolean okClicked = dlg.startDialog(singleFilename, fileCount, defaultItem);
        if (!okClicked) {
            return;
        }
        for (FrostSharedFileItem item : items) {
            String newStr;
            String oldStr = item.getComment();
            if (!this.stringsEqual(oldStr, newStr = dlg.getComment())) {
                item.setComment(dlg.getComment());
            }
            if (!this.stringsEqual(oldStr = item.getKeywords(), newStr = dlg.getKeywords())) {
                item.setKeywords(dlg.getKeywords());
            }
            if (item.getRating() == dlg.getRating()) continue;
            item.setRating(dlg.getRating());
        }
    }

    private void updateSharedFilesItemCount() {
        this.sharedFilesCount = this.model.getItemCount();
        long sharedFilesSize = 0L;
        for (Object it : this.model.getItems()) {
            FrostSharedFileItem sfi = (FrostSharedFileItem)it;
            sharedFilesSize += sfi.getFileSize();
        }
        String s = this.language.getString("SharedFilesPane.toolbar.files") + ": " + this.sharedFilesCount + "  (" + FormatterUtils.formatSize(sharedFilesSize) + ")";
        this.sharedFilesCountLabel.setText(s);
    }

    private boolean stringsEqual(String oldStr, String newStr) {
        if (oldStr == null && newStr != null) {
            return false;
        }
        if (oldStr != null && newStr == null) {
            return false;
        }
        if (oldStr == null && newStr == null) {
            return true;
        }
        return oldStr.equals(newStr);
    }

    private class Listener
    extends MouseAdapter
    implements LanguageListener,
    KeyListener,
    ActionListener,
    MouseListener,
    PropertyChangeListener {
        public void languageChanged(LanguageEvent event) {
            SharedFilesPanel.this.refreshLanguage();
        }

        public void keyPressed(KeyEvent e) {
            if (e.getSource() == SharedFilesPanel.this.modelTable.getTable()) {
                SharedFilesPanel.this.uploadTable_keyPressed(e);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SharedFilesPanel.this.addSharedFilesButton) {
                SharedFilesPanel.this.uploadAddFilesButton_actionPerformed(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                if (e.getSource() == SharedFilesPanel.this.modelTable.getTable()) {
                    SharedFilesPanel.this.showProperties();
                }
            } else if (e.isPopupTrigger() && (e.getSource() == SharedFilesPanel.this.modelTable.getTable() || e.getSource() == SharedFilesPanel.this.modelTable.getScrollPane())) {
                SharedFilesPanel.this.showUploadTablePopupMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 1 && e.isPopupTrigger() && (e.getSource() == SharedFilesPanel.this.modelTable.getTable() || e.getSource() == SharedFilesPanel.this.modelTable.getScrollPane())) {
                SharedFilesPanel.this.showUploadTablePopupMenu(e);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("fileListFontName")) {
                SharedFilesPanel.this.fontChanged();
            }
            if (evt.getPropertyName().equals("fileListFontSize")) {
                SharedFilesPanel.this.fontChanged();
            }
            if (evt.getPropertyName().equals("fileListFontStyle")) {
                SharedFilesPanel.this.fontChanged();
            }
        }
    }

    private class PopupMenu
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        private final JMenuItem copyKeysAndNamesItem = new JMenuItem();
        private final JMenuItem copyKeysItem = new JMenuItem();
        private final JMenuItem copyExtendedInfoItem = new JMenuItem();
        private final JMenuItem uploadSelectedFilesItem = new JMenuItem();
        private final JMenuItem removeSelectedFilesItem = new JMenuItem();
        private final JMenuItem propertiesItem = new JMenuItem();
        private final JMenu copyToClipboardMenu = new JMenu();

        public PopupMenu() {
            this.initialize();
        }

        private void initialize() {
            this.refreshLanguage();
            this.copyToClipboardMenu.add(this.copyKeysAndNamesItem);
            if (FcpHandler.isFreenet05()) {
                this.copyToClipboardMenu.add(this.copyKeysItem);
            }
            this.copyToClipboardMenu.add(this.copyExtendedInfoItem);
            this.copyKeysAndNamesItem.addActionListener(this);
            this.copyKeysItem.addActionListener(this);
            this.copyExtendedInfoItem.addActionListener(this);
            this.removeSelectedFilesItem.addActionListener(this);
            this.uploadSelectedFilesItem.addActionListener(this);
            this.propertiesItem.addActionListener(this);
        }

        private void refreshLanguage() {
            this.propertiesItem.setText(SharedFilesPanel.this.language.getString("Common.properties"));
            this.copyKeysItem.setText(SharedFilesPanel.this.language.getString("Common.copyToClipBoard.copyKeysOnly"));
            this.copyKeysAndNamesItem.setText(SharedFilesPanel.this.language.getString("Common.copyToClipBoard.copyKeysWithFilenames"));
            this.copyExtendedInfoItem.setText(SharedFilesPanel.this.language.getString("Common.copyToClipBoard.copyExtendedInfo"));
            this.uploadSelectedFilesItem.setText(SharedFilesPanel.this.language.getString("SharedFilesPane.fileTable.popupmenu.uploadSelectedFiles"));
            this.removeSelectedFilesItem.setText(SharedFilesPanel.this.language.getString("SharedFilesPane.fileTable.popupmenu.removeSelectedFiles"));
            this.copyToClipboardMenu.setText(SharedFilesPanel.this.language.getString("Common.copyToClipBoard") + "...");
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.copyKeysItem) {
                CopyToClipboard.copyKeys(SharedFilesPanel.this.modelTable.getSelectedItems());
            }
            if (e.getSource() == this.copyKeysAndNamesItem) {
                CopyToClipboard.copyKeysAndFilenames(SharedFilesPanel.this.modelTable.getSelectedItems());
            }
            if (e.getSource() == this.copyExtendedInfoItem) {
                CopyToClipboard.copyExtendedInfo(SharedFilesPanel.this.modelTable.getSelectedItems());
            }
            if (e.getSource() == this.removeSelectedFilesItem) {
                SharedFilesPanel.this.removeSelectedFiles();
            }
            if (e.getSource() == this.uploadSelectedFilesItem) {
                this.uploadSelectedFiles();
            }
            if (e.getSource() == this.propertiesItem) {
                SharedFilesPanel.this.showProperties();
            }
        }

        private void uploadSelectedFiles() {
            ModelItem[] selectedItems = SharedFilesPanel.this.modelTable.getSelectedItems();
            SharedFilesPanel.this.model.requestItems(selectedItems);
        }

        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }

        public void show(Component invoker, int x, int y) {
            this.removeAll();
            ModelItem[] selectedItems = SharedFilesPanel.this.modelTable.getSelectedItems();
            if (selectedItems.length == 0) {
                return;
            }
            boolean allValid = true;
            for (ModelItem element : selectedItems) {
                FrostSharedFileItem sfItem = (FrostSharedFileItem)element;
                if (sfItem.isValid()) continue;
                allValid = false;
                break;
            }
            if (allValid) {
                this.add(this.copyToClipboardMenu);
                this.addSeparator();
                this.add(this.removeSelectedFilesItem);
                this.addSeparator();
                this.add(this.uploadSelectedFilesItem);
                this.addSeparator();
                this.add(this.propertiesItem);
            } else {
                this.add(this.removeSelectedFilesItem);
            }
            super.show(invoker, x, y);
        }
    }

    private class AddNewSharedFilesThread
    extends Thread {
        private final File[] selectedFiles;
        private final String owner;
        private final boolean replacePathIfFileExists;

        public AddNewSharedFilesThread(File[] selectedFiles, String owner, boolean replacePath) {
            this.selectedFiles = selectedFiles;
            this.owner = owner;
            this.replacePathIfFileExists = replacePath;
        }

        public void run() {
            String parentDir = null;
            LinkedList<File> uploadFileItems = new LinkedList<File>();
            for (File element : this.selectedFiles) {
                ArrayList<File> allFiles = FileAccess.getAllEntries(element, "");
                for (int j = 0; j < allFiles.size(); ++j) {
                    File newFile = allFiles.get(j);
                    if (!newFile.isFile() || newFile.length() <= 0L) continue;
                    uploadFileItems.add(newFile);
                    if (parentDir != null) continue;
                    parentDir = newFile.getParent();
                }
            }
            if (parentDir != null) {
                Core.frostSettings.setValue("lastUsedDirectory", parentDir);
            }
            LinkedList<NewUploadFile> uploadItems = new LinkedList<NewUploadFile>();
            for (File file : uploadFileItems) {
                NewUploadFile nuf = new NewUploadFile(file, this.owner, this.replacePathIfFileExists);
                uploadItems.add(nuf);
            }
            FileListUploadThread.getInstance().userActionOccured();
            Core.getInstance().getFileTransferManager().getNewUploadFilesManager().addNewUploadFiles(uploadItems);
        }
    }
}

