/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.Core;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.fileTransfer.search.FrostSearchItem;
import frost.fileTransfer.search.SearchTableComparators;
import frost.gui.RatingStringProvider;
import frost.util.FormatterUtils;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.ModelTable;
import frost.util.model.SortedModelTable;
import frost.util.model.SortedTableFormat;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SearchTableFormat
extends SortedTableFormat
implements LanguageListener,
PropertyChangeListener {
    private static final String CFGKEY_SORTSTATE_SORTEDCOLUMN = "SearchFilesTable.sortState.sortedColumn";
    private static final String CFGKEY_SORTSTATE_SORTEDASCENDING = "SearchFilesTable.sortState.sortedAscending";
    private static final String CFGKEY_COLUMN_TABLEINDEX = "SearchFilesTable.tableindex.modelcolumn.";
    private static final String CFGKEY_COLUMN_WIDTH = "SearchFilesTable.columnwidth.modelcolumn.";
    private static final ImageIcon hasMoreInfoIcon = MiscToolkit.loadImageIcon("/data/info.png");
    private final Language language = Language.getInstance();
    private static final int COLUMN_COUNT = 9;
    private String offline;
    private String sharing;
    private String downloading;
    private String downloaded;
    private String sourceCountTooltip;
    private SortedModelTable modelTable;
    private boolean showColoredLines;

    public SearchTableFormat() {
        super(9);
        this.language.addLanguageListener(this);
        this.refreshLanguage();
        this.setComparator(SearchTableComparators.getFileNameComparator(), 0);
        this.setComparator(SearchTableComparators.getSizeComparator(), 1);
        this.setComparator(SearchTableComparators.getStateComparator(), 2);
        this.setComparator(SearchTableComparators.getLastUploadedComparator(), 3);
        this.setComparator(SearchTableComparators.getLastReceivedComparator(), 4);
        this.setComparator(SearchTableComparators.getRatingComparator(), 5);
        this.setComparator(SearchTableComparators.getCommentComparator(), 6);
        this.setComparator(SearchTableComparators.getKeywordsComparator(), 7);
        this.setComparator(SearchTableComparators.getSourcesComparator(), 8);
        this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
        Core.frostSettings.addPropertyChangeListener(this);
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        this.setColumnName(0, this.language.getString("SearchPane.resultTable.filename"));
        this.setColumnName(1, this.language.getString("SearchPane.resultTable.size"));
        this.setColumnName(2, this.language.getString("SearchPane.resultTable.state"));
        this.setColumnName(3, this.language.getString("SearchPane.resultTable.lastUploaded"));
        this.setColumnName(4, this.language.getString("SearchPane.resultTable.lastReceived"));
        this.setColumnName(5, this.language.getString("SearchPane.resultTable.rating"));
        this.setColumnName(6, this.language.getString("SearchPane.resultTable.comment"));
        this.setColumnName(7, this.language.getString("SearchPane.resultTable.keywords"));
        this.setColumnName(8, this.language.getString("SearchPane.resultTable.sources"));
        this.offline = this.language.getString("SearchPane.resultTable.states.offline");
        this.sharing = this.language.getString("SearchPane.resultTable.states.sharing");
        this.downloading = this.language.getString("SearchPane.resultTable.states.downloading");
        this.downloaded = this.language.getString("SearchPane.resultTable.states.downloaded");
        this.sourceCountTooltip = this.language.getString("SearchPane.resultTable.sources.tooltip");
        this.refreshColumnNames();
    }

    public Object getCellValue(ModelItem item, int columnIndex) {
        if (item == null) {
            return "*null*";
        }
        FrostSearchItem searchItem = (FrostSearchItem)item;
        switch (columnIndex) {
            case 0: {
                return searchItem.getFilename();
            }
            case 1: {
                return FormatterUtils.formatSize(searchItem.getSize());
            }
            case 2: {
                return this.getStateStr(searchItem.getState());
            }
            case 3: {
                return searchItem.getLastUploadedStr();
            }
            case 4: {
                return searchItem.getLastReceivedString();
            }
            case 5: {
                return RatingStringProvider.getRatingString(searchItem.getRating());
            }
            case 6: {
                return searchItem.getComment();
            }
            case 7: {
                return searchItem.getKeywords();
            }
            case 8: {
                return searchItem.getSourceCount();
            }
        }
        return "**ERROR**";
    }

    private String getStateStr(int state) {
        String stateString = "";
        switch (state) {
            case 5: {
                stateString = this.offline;
                break;
            }
            case 4: {
                stateString = this.sharing;
                break;
            }
            case 3: {
                stateString = this.downloading;
                break;
            }
            case 2: {
                stateString = this.downloaded;
            }
        }
        return stateString;
    }

    public int[] getColumnNumbers(int fieldID) {
        return new int[0];
    }

    public void customizeTable(ModelTable lModelTable) {
        super.customizeTable(lModelTable);
        this.modelTable = (SortedModelTable)lModelTable;
        this.modelTable.getTable().setAutoResizeMode(1);
        this.modelTable.setSortedColumn(0, true);
        TableColumnModel columnModel = this.modelTable.getTable().getColumnModel();
        RightAlignRenderer rightAlignRenderer = new RightAlignRenderer();
        ShowColoredLinesRenderer showColoredLinesRenderer = new ShowColoredLinesRenderer();
        ShowContentTooltipRenderer showContentTooltipRenderer = new ShowContentTooltipRenderer();
        columnModel.getColumn(0).setCellRenderer(new FileNameRenderer());
        columnModel.getColumn(1).setCellRenderer(rightAlignRenderer);
        columnModel.getColumn(2).setCellRenderer(showColoredLinesRenderer);
        columnModel.getColumn(3).setCellRenderer(showColoredLinesRenderer);
        columnModel.getColumn(4).setCellRenderer(showColoredLinesRenderer);
        columnModel.getColumn(5).setCellRenderer(showColoredLinesRenderer);
        columnModel.getColumn(6).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(7).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(8).setCellRenderer(new SourceCountRenderer());
        if (!this.loadTableLayout(columnModel)) {
            int[] widths = new int[]{250, 30, 40, 20, 20, 10, 50, 80, 15};
            for (int i = 0; i < widths.length; ++i) {
                columnModel.getColumn(i).setPreferredWidth(widths[i]);
            }
        }
        columnModel.addColumnModelListener(new TableColumnModelListener(){

            public void columnMarginChanged(ChangeEvent e) {
                SearchTableFormat.this.saveTableLayout();
            }

            public void columnMoved(TableColumnModelEvent e) {
                if (e.getFromIndex() != e.getToIndex()) {
                    SearchTableFormat.this.saveTableLayout();
                }
            }

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    private void saveTableLayout() {
        TableColumnModel tcm = this.modelTable.getTable().getColumnModel();
        for (int columnIndexInTable = 0; columnIndexInTable < tcm.getColumnCount(); ++columnIndexInTable) {
            TableColumn tc = tcm.getColumn(columnIndexInTable);
            int columnIndexInModel = tc.getModelIndex();
            Core.frostSettings.setValue(CFGKEY_COLUMN_TABLEINDEX + columnIndexInModel, columnIndexInTable);
            int columnWidth = tc.getWidth();
            Core.frostSettings.setValue(CFGKEY_COLUMN_WIDTH + columnIndexInModel, columnWidth);
        }
        if (Core.frostSettings.getBoolValue("saveSortStates") && this.modelTable.getSortedColumn() > -1) {
            int sortedColumn = this.modelTable.getSortedColumn();
            boolean isSortedAsc = this.modelTable.isSortedAscending();
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDCOLUMN, sortedColumn);
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDASCENDING, isSortedAsc);
        }
    }

    private boolean loadTableLayout(TableColumnModel tcm) {
        int[] tableToModelIndex = new int[tcm.getColumnCount()];
        int[] columnWidths = new int[tcm.getColumnCount()];
        for (int x = 0; x < tableToModelIndex.length; ++x) {
            String indexKey = CFGKEY_COLUMN_TABLEINDEX + x;
            if (Core.frostSettings.getObjectValue(indexKey) == null) {
                return false;
            }
            int tableIndex = Core.frostSettings.getIntValue(indexKey);
            if (tableIndex < 0 || tableIndex >= tableToModelIndex.length) {
                return false;
            }
            tableToModelIndex[tableIndex] = x;
            String widthKey = CFGKEY_COLUMN_WIDTH + x;
            if (Core.frostSettings.getObjectValue(widthKey) == null) {
                return false;
            }
            int columnWidth = Core.frostSettings.getIntValue(widthKey);
            if (columnWidth <= 0) {
                return false;
            }
            columnWidths[x] = columnWidth;
        }
        TableColumn[] tcms = new TableColumn[tcm.getColumnCount()];
        for (int x = tcms.length - 1; x >= 0; --x) {
            tcms[x] = tcm.getColumn(x);
            tcm.removeColumn(tcms[x]);
            tcms[x].setPreferredWidth(columnWidths[x]);
        }
        for (int element : tableToModelIndex) {
            tcm.addColumn(tcms[element]);
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showColoredRows")) {
            this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
            this.modelTable.fireTableDataChanged();
        }
    }

    private class ShowColoredLinesRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, SearchTableFormat.this.showColoredLines);
                this.setBackground(newBackground);
            } else {
                this.setBackground(table.getSelectionBackground());
            }
            return this;
        }
    }

    private class SourceCountRenderer
    extends ShowColoredLinesRenderer {
        final EmptyBorder border = new EmptyBorder(0, 0, 0, 3);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(4);
            this.setBorder(this.border);
            ModelItem item = SearchTableFormat.this.modelTable.getItemAt(row);
            if (item != null) {
                FrostSearchItem searchItem = (FrostSearchItem)item;
                if (searchItem.hasInfosFromMultipleSources().booleanValue()) {
                    this.setIcon(hasMoreInfoIcon);
                } else {
                    this.setIcon(null);
                }
            } else {
                this.setIcon(null);
            }
            this.setToolTipText(SearchTableFormat.this.sourceCountTooltip);
            return this;
        }
    }

    private class FileNameRenderer
    extends ShowContentTooltipRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                ModelItem item = SearchTableFormat.this.modelTable.getItemAt(row);
                if (item != null) {
                    FrostSearchItem searchItem = (FrostSearchItem)item;
                    if (searchItem.getState() == 2) {
                        this.setForeground(Color.LIGHT_GRAY);
                    } else if (searchItem.getState() == 3) {
                        this.setForeground(Color.BLUE);
                    } else if (searchItem.getState() == 4) {
                        this.setForeground(Color.MAGENTA);
                    } else if (searchItem.getState() == 5) {
                        this.setForeground(Color.DARK_GRAY);
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                } else {
                    return this;
                }
            }
            return this;
        }
    }

    private class RightAlignRenderer
    extends ShowColoredLinesRenderer {
        final EmptyBorder border = new EmptyBorder(0, 0, 0, 3);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(4);
            this.setBorder(this.border);
            return this;
        }
    }

    private class ShowContentTooltipRenderer
    extends ShowColoredLinesRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            if (value != null && (tooltip = value.toString()).length() == 0) {
                tooltip = null;
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }
}

