/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.fileTransfer.search.FrostSearchItem;
import java.util.Comparator;

public class SearchTableComparators {
    private static final FileNameComparator fileNameComparator = new FileNameComparator();
    private static final SizeComparator sizeComparator = new SizeComparator();
    private static final StateComparator stateComparator = new StateComparator();
    private static final LastUploadedComparator lastUploadedComparator = new LastUploadedComparator();
    private static final LastReceivedComparator lastReceivedComparator = new LastReceivedComparator();
    private static final RatingComparator ratingComparator = new RatingComparator();
    private static final CommentComparator commentComparator = new CommentComparator();
    private static final KeywordsComparator keywordsComparator = new KeywordsComparator();
    private static final SourcesComparator sourcesComparator = new SourcesComparator();

    public static FileNameComparator getFileNameComparator() {
        return fileNameComparator;
    }

    public static SizeComparator getSizeComparator() {
        return sizeComparator;
    }

    public static StateComparator getStateComparator() {
        return stateComparator;
    }

    public static LastUploadedComparator getLastUploadedComparator() {
        return lastUploadedComparator;
    }

    public static LastReceivedComparator getLastReceivedComparator() {
        return lastReceivedComparator;
    }

    public static RatingComparator getRatingComparator() {
        return ratingComparator;
    }

    public static CommentComparator getCommentComparator() {
        return commentComparator;
    }

    public static KeywordsComparator getKeywordsComparator() {
        return keywordsComparator;
    }

    public static SourcesComparator getSourcesComparator() {
        return sourcesComparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourcesComparator
    implements Comparator<FrostSearchItem> {
        private SourcesComparator() {
        }

        @Override
        public int compare(FrostSearchItem o1, FrostSearchItem o2) {
            Integer sources1 = o1.getSourceCount();
            Integer sources2 = o2.getSourceCount();
            return sources1.compareTo(sources2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LastUploadedComparator
    implements Comparator<FrostSearchItem> {
        private LastUploadedComparator() {
        }

        @Override
        public int compare(FrostSearchItem o1, FrostSearchItem o2) {
            long l2;
            long l1 = o1.getFrostFileListFileObject().getLastUploaded();
            if (l1 < (l2 = o2.getFrostFileListFileObject().getLastUploaded())) {
                return -1;
            }
            if (l1 > l2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LastReceivedComparator
    implements Comparator<FrostSearchItem> {
        private LastReceivedComparator() {
        }

        @Override
        public int compare(FrostSearchItem o1, FrostSearchItem o2) {
            long l2;
            long l1 = o1.getFrostFileListFileObject().getLastReceived();
            if (l1 < (l2 = o2.getFrostFileListFileObject().getLastReceived())) {
                return -1;
            }
            if (l1 > l2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RatingComparator
    implements Comparator<FrostSearchItem> {
        private RatingComparator() {
        }

        @Override
        public int compare(FrostSearchItem o1, FrostSearchItem o2) {
            Integer rating1 = o1.getRating();
            Integer rating2 = o2.getRating();
            return rating1.compareTo(rating2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeywordsComparator
    implements Comparator<FrostSearchItem> {
        private KeywordsComparator() {
        }

        @Override
        public int compare(FrostSearchItem o1, FrostSearchItem o2) {
            String keywords1 = o1.getKeywords();
            String keywords2 = o2.getKeywords();
            return keywords1.compareToIgnoreCase(keywords2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommentComparator
    implements Comparator<FrostSearchItem> {
        private CommentComparator() {
        }

        @Override
        public int compare(FrostSearchItem o1, FrostSearchItem o2) {
            String comment1 = o1.getComment();
            String comment2 = o2.getComment();
            return comment1.compareToIgnoreCase(comment2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileNameComparator
    implements Comparator<FrostSearchItem> {
        private FileNameComparator() {
        }

        @Override
        public int compare(FrostSearchItem o1, FrostSearchItem o2) {
            return o1.getFilename().compareToIgnoreCase(o2.getFilename());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SizeComparator
    implements Comparator<FrostSearchItem> {
        private SizeComparator() {
        }

        @Override
        public int compare(FrostSearchItem o1, FrostSearchItem o2) {
            return o1.getSize().compareTo(o2.getSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StateComparator
    implements Comparator<FrostSearchItem> {
        private StateComparator() {
        }

        @Override
        public int compare(FrostSearchItem o1, FrostSearchItem o2) {
            int i2;
            int i1 = o1.getState();
            if (i1 < (i2 = o2.getState())) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }
    }
}

