/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.FrostFileListFileObject;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.sharing.SharedFilesModel;
import frost.util.CopyToClipboardItem;
import frost.util.DateFun;
import frost.util.model.ModelItem;

public class FrostSearchItem
extends ModelItem
implements CopyToClipboardItem {
    private final FrostFileListFileObject fo;
    private int state;
    private Long sizeLong = null;
    private String lastUploadedStr = null;
    private String lastReceivedStr = null;
    private Integer rating = null;
    private Integer sourceCount = null;
    public static final int STATE_NONE = 1;
    public static final int STATE_DOWNLOADED = 2;
    public static final int STATE_DOWNLOADING = 3;
    public static final int STATE_SHARING = 4;
    public static final int STATE_OFFLINE = 5;

    public FrostSearchItem(FrostFileListFileObject newKey) {
        this.fo = newKey;
        this.updateState();
    }

    public void updateState() {
        String SHA1;
        DownloadModel downloadModel = FileTransferManager.inst().getDownloadManager().getModel();
        SharedFilesModel sharedFilesModel = FileTransferManager.inst().getSharedFilesManager().getModel();
        int searchItemState = sharedFilesModel.containsItemWithSha(SHA1 = this.fo.getSha()) ? 4 : (downloadModel.containsItemWithSha(SHA1) ? 3 : (this.fo.getLastDownloaded() > 0L ? 2 : (this.fo.getKey() == null ? 5 : 1)));
        this.state = searchItemState;
    }

    public String getFilename() {
        return this.fo.getDisplayName();
    }

    public String getComment() {
        if (this.fo.getDisplayComment() == null) {
            return "";
        }
        return this.fo.getDisplayComment();
    }

    public String getKeywords() {
        if (this.fo.getDisplayKeywords() == null) {
            return "";
        }
        return this.fo.getDisplayKeywords();
    }

    public Boolean hasInfosFromMultipleSources() {
        return this.fo.hasInfosFromMultipleSources();
    }

    public Integer getRating() {
        if (this.rating == null) {
            this.rating = new Integer(this.fo.getDisplayRating());
        }
        return this.rating;
    }

    public Long getSize() {
        if (this.sizeLong == null) {
            this.sizeLong = new Long(this.fo.getSize());
        }
        return this.sizeLong;
    }

    public long getFileSize() {
        return this.getSize();
    }

    public String getLastUploadedStr() {
        if (this.lastUploadedStr == null) {
            long lastUploaded = this.fo.getLastUploaded();
            this.lastUploadedStr = lastUploaded > 0L ? DateFun.getExtendedDateFromMillis(lastUploaded) : "";
        }
        return this.lastUploadedStr;
    }

    public String getLastReceivedString() {
        if (this.lastReceivedStr == null) {
            this.lastReceivedStr = this.getFrostFileListFileObject().getLastReceived() > 0L ? DateFun.getExtendedDateFromMillis(this.getFrostFileListFileObject().getLastReceived()) : "";
        }
        return this.lastReceivedStr;
    }

    public String getKey() {
        return this.fo.getKey();
    }

    public int getState() {
        return this.state;
    }

    public String getSha() {
        return this.fo.getSha();
    }

    public FrostFileListFileObject getFrostFileListFileObject() {
        return this.fo;
    }

    public Integer getSourceCount() {
        if (this.sourceCount == null) {
            this.sourceCount = new Integer(this.fo.getFrostFileListFileObjectOwnerListSize());
        }
        return this.sourceCount;
    }

    public String toString() {
        return this.getFilename();
    }
}

