/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.common;

import frost.Core;
import frost.fileTransfer.FrostFileListFileObjectOwner;
import frost.identities.Identity;
import frost.util.CopyToClipboardItem;
import frost.util.DateFun;
import frost.util.model.ModelItem;

public class FileListFileDetailsItem
extends ModelItem
implements CopyToClipboardItem {
    private FrostFileListFileObjectOwner fileOwner;
    private String displayComment = null;
    private String displayKeywords = null;
    private String displayLastReceived;
    private String displayLastUploaded;
    private Identity ownerIdentity = null;

    public FileListFileDetailsItem(FrostFileListFileObjectOwner o) {
        this.fileOwner = o;
    }

    public String getDisplayComment() {
        if (this.displayComment == null) {
            this.displayComment = this.fileOwner.getComment() == null ? "" : this.fileOwner.getComment();
        }
        return this.displayComment;
    }

    public String getDisplayKeywords() {
        if (this.displayKeywords == null) {
            this.displayKeywords = this.fileOwner.getKeywords() == null ? "" : this.fileOwner.getKeywords();
        }
        return this.displayKeywords;
    }

    public String getDisplayLastReceived() {
        if (this.displayLastReceived == null) {
            this.displayLastReceived = this.fileOwner.getLastReceived() == 0L ? "" : DateFun.getExtendedDateFromMillis(this.fileOwner.getLastReceived());
        }
        return this.displayLastReceived;
    }

    public String getDisplayLastUploaded() {
        if (this.displayLastUploaded == null) {
            this.displayLastUploaded = this.fileOwner.getLastUploaded() == 0L ? "" : DateFun.getExtendedDateFromMillis(this.fileOwner.getLastUploaded());
        }
        return this.displayLastUploaded;
    }

    public Identity getOwnerIdentity() {
        if (this.ownerIdentity == null) {
            this.ownerIdentity = Core.getIdentities().getIdentity(this.fileOwner.getOwner());
        }
        return this.ownerIdentity;
    }

    public String getKey() {
        return this.fileOwner.getKey();
    }

    public String getFilename() {
        return this.getFileOwner().getName();
    }

    public long getFileSize() {
        return -1L;
    }

    public FrostFileListFileObjectOwner getFileOwner() {
        return this.fileOwner;
    }
}

