/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.common;

import frost.Core;
import frost.MainFrame;
import frost.fcp.FcpHandler;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.FrostFileListFileObject;
import frost.fileTransfer.FrostFileListFileObjectOwner;
import frost.fileTransfer.common.FileListFileDetailsItem;
import frost.fileTransfer.common.FileListFileDetailsTableFormat;
import frost.fileTransfer.common.FileListFileDetailsTableModel;
import frost.fileTransfer.search.SearchParameters;
import frost.gui.MessagePanel;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.util.CopyToClipboard;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.SortedModelTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class FileListFileDetailsDialog
extends JDialog {
    Language language = Language.getInstance();
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JPanel mainPanel = null;
    private JButton Bclose = null;
    private SortedModelTable modelTable = null;
    private FileListFileDetailsTableModel model = null;
    private FileListFileDetailsTableFormat tableFormat = null;
    private PopupMenu popupMenu = null;
    private final Listener listener = new Listener();
    private final boolean isOwnerSearchAllowed;

    public FileListFileDetailsDialog(Frame owner) {
        this(owner, false);
    }

    public FileListFileDetailsDialog(Frame owner, boolean allowOwnerSearch) {
        super(owner);
        this.initialize(owner);
        this.isOwnerSearchAllowed = allowOwnerSearch;
    }

    private void initialize(Frame owner) {
        this.setContentPane(this.getJContentPane());
        this.setTitle(this.language.getString("FileListFileDetailsDialog.title"));
        this.loadLayout();
        this.setLocationRelativeTo(owner);
    }

    private PopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new PopupMenu();
        }
        return this.popupMenu;
    }

    private void showUploadTablePopupMenu(MouseEvent e) {
        Point p = e.getPoint();
        int y = this.modelTable.getTable().rowAtPoint(p);
        if (y < 0) {
            return;
        }
        if (!this.modelTable.getTable().getSelectionModel().isSelectedIndex(y)) {
            this.modelTable.getTable().getSelectionModel().setSelectionInterval(y, y);
        }
        this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
    }

    private void loadLayout() {
        int lastHeight = Core.frostSettings.getIntValue("FileListFileDetailsDialog.height");
        int lastWidth = Core.frostSettings.getIntValue("FileListFileDetailsDialog.width");
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (lastWidth < 100) {
            lastWidth = 600;
        }
        if (lastWidth > scrSize.width) {
            lastWidth = scrSize.width;
        }
        if (lastHeight < 100) {
            lastHeight = 370;
        }
        if (lastHeight > scrSize.height) {
            lastWidth = scrSize.height;
        }
        this.setSize(lastWidth, lastHeight);
    }

    private void saveLayout() {
        Rectangle bounds = this.getBounds();
        Core.frostSettings.setValue("FileListFileDetailsDialog.height", bounds.height);
        Core.frostSettings.setValue("FileListFileDetailsDialog.width", bounds.width);
        this.tableFormat.saveTableLayout(this.getModelTable());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getBclose(), null);
        }
        return this.buttonPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getModelTable().getScrollPane(), "Center");
        }
        return this.mainPanel;
    }

    private SortedModelTable getModelTable() {
        if (this.modelTable == null) {
            this.tableFormat = new FileListFileDetailsTableFormat();
            this.model = new FileListFileDetailsTableModel(this.tableFormat);
            this.modelTable = new SortedModelTable(this.model);
            this.modelTable.getScrollPane().addMouseListener(this.listener);
            this.modelTable.getTable().addMouseListener(this.listener);
        }
        return this.modelTable;
    }

    private JButton getBclose() {
        if (this.Bclose == null) {
            this.Bclose = new JButton();
            this.Bclose.setText(this.language.getString("FileListFileDetailsDialog.button.close"));
            this.Bclose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileListFileDetailsDialog.this.saveLayout();
                    FileListFileDetailsDialog.this.setVisible(false);
                }
            });
        }
        return this.Bclose;
    }

    public void startDialog(FrostFileListFileObject fileObject) {
        Iterator<FrostFileListFileObjectOwner> i = fileObject.getFrostFileListFileObjectOwnerIterator();
        while (i.hasNext()) {
            FrostFileListFileObjectOwner o = i.next();
            FileListFileDetailsItem item = new FileListFileDetailsItem(o);
            this.model.addPropertiesItem(item);
        }
        this.setVisible(true);
    }

    private class Listener
    extends MouseAdapter
    implements MouseListener {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && (e.getSource() == FileListFileDetailsDialog.this.modelTable.getTable() || e.getSource() == FileListFileDetailsDialog.this.modelTable.getScrollPane())) {
                FileListFileDetailsDialog.this.showUploadTablePopupMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 1 && e.isPopupTrigger() && (e.getSource() == FileListFileDetailsDialog.this.modelTable.getTable() || e.getSource() == FileListFileDetailsDialog.this.modelTable.getScrollPane())) {
                FileListFileDetailsDialog.this.showUploadTablePopupMenu(e);
            }
        }
    }

    private class PopupMenu
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        private final JMenuItem copyKeysAndNamesItem = new JMenuItem();
        private final JMenuItem copyKeysItem = new JMenuItem();
        private final JMenu copyToClipboardMenu = new JMenu();
        private final JMenuItem showOwnerFilesItem = new JMenuItem();
        private final JMenuItem setBadItem = new JMenuItem();
        private final JMenuItem setCheckItem = new JMenuItem();
        private final JMenuItem setGoodItem = new JMenuItem();
        private final JMenuItem setObserveItem = new JMenuItem();

        public PopupMenu() {
            this.initialize();
        }

        private void initialize() {
            this.refreshLanguage();
            this.copyToClipboardMenu.add(this.copyKeysAndNamesItem);
            if (FcpHandler.isFreenet05()) {
                this.copyToClipboardMenu.add(this.copyKeysItem);
            }
            this.copyKeysAndNamesItem.addActionListener(this);
            this.copyKeysItem.addActionListener(this);
            this.showOwnerFilesItem.addActionListener(this);
            this.setGoodItem.addActionListener(this);
            this.setBadItem.addActionListener(this);
            this.setCheckItem.addActionListener(this);
            this.setObserveItem.addActionListener(this);
        }

        private void refreshLanguage() {
            this.copyKeysItem.setText(FileListFileDetailsDialog.this.language.getString("Common.copyToClipBoard.copyKeysOnly"));
            this.copyKeysAndNamesItem.setText(FileListFileDetailsDialog.this.language.getString("Common.copyToClipBoard.copyKeysWithFilenames"));
            this.copyToClipboardMenu.setText(FileListFileDetailsDialog.this.language.getString("Common.copyToClipBoard") + "...");
            this.showOwnerFilesItem.setText(FileListFileDetailsDialog.this.language.getString("FileListFileDetailsDialog.popupmenu.searchFilesOfOwner"));
            this.setGoodItem.setText(FileListFileDetailsDialog.this.language.getString("MessagePane.messageTable.popupmenu.setToGood"));
            this.setBadItem.setText(FileListFileDetailsDialog.this.language.getString("MessagePane.messageTable.popupmenu.setToBad"));
            this.setCheckItem.setText(FileListFileDetailsDialog.this.language.getString("MessagePane.messageTable.popupmenu.setToCheck"));
            this.setObserveItem.setText(FileListFileDetailsDialog.this.language.getString("MessagePane.messageTable.popupmenu.setToObserve"));
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.copyKeysItem) {
                CopyToClipboard.copyKeys(FileListFileDetailsDialog.this.modelTable.getSelectedItems());
            } else if (e.getSource() == this.copyKeysAndNamesItem) {
                CopyToClipboard.copyKeysAndFilenames(FileListFileDetailsDialog.this.modelTable.getSelectedItems());
            } else if (e.getSource() == this.showOwnerFilesItem) {
                this.searchFilesOfOwner();
            } else if (e.getSource() == this.setGoodItem) {
                this.changeTrustState(MessagePanel.IdentityState.GOOD);
            } else if (e.getSource() == this.setBadItem) {
                this.changeTrustState(MessagePanel.IdentityState.BAD);
            } else if (e.getSource() == this.setCheckItem) {
                this.changeTrustState(MessagePanel.IdentityState.CHECK);
            } else if (e.getSource() == this.setObserveItem) {
                this.changeTrustState(MessagePanel.IdentityState.OBSERVE);
            }
        }

        private void changeTrustState(MessagePanel.IdentityState is) {
            ModelItem[] selectedItems = FileListFileDetailsDialog.this.modelTable.getSelectedItems();
            if (selectedItems.length == 1) {
                FileListFileDetailsItem item = (FileListFileDetailsItem)selectedItems[0];
                if (is == MessagePanel.IdentityState.GOOD) {
                    item.getOwnerIdentity().setGOOD();
                } else if (is == MessagePanel.IdentityState.CHECK) {
                    item.getOwnerIdentity().setCHECK();
                } else if (is == MessagePanel.IdentityState.OBSERVE) {
                    item.getOwnerIdentity().setOBSERVE();
                } else if (is == MessagePanel.IdentityState.BAD) {
                    item.getOwnerIdentity().setBAD();
                }
                FileListFileDetailsDialog.this.modelTable.fireTableRowsUpdated(0, FileListFileDetailsDialog.this.modelTable.getRowCount() - 1);
                MainFrame.getInstance().getMessagePanel().updateTableAfterChangeOfIdentityState();
            }
        }

        private void searchFilesOfOwner() {
            ModelItem[] selectedItems = FileListFileDetailsDialog.this.modelTable.getSelectedItems();
            if (selectedItems.length == 1) {
                FileListFileDetailsItem item = (FileListFileDetailsItem)selectedItems[0];
                String owner = item.getOwnerIdentity().getUniqueName();
                SearchParameters sp = new SearchParameters(false);
                sp.setOwnerString(owner);
                FileTransferManager.inst().getSearchManager().getPanel().startNewSearch(sp);
            }
        }

        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }

        public void show(Component invoker, int x, int y) {
            this.removeAll();
            ModelItem[] selectedItems = FileListFileDetailsDialog.this.modelTable.getSelectedItems();
            if (selectedItems.length == 0) {
                return;
            }
            this.add(this.copyToClipboardMenu);
            if (selectedItems.length == 1) {
                this.addSeparator();
                this.add(this.setGoodItem);
                this.add(this.setObserveItem);
                this.add(this.setCheckItem);
                this.add(this.setBadItem);
                this.setGoodItem.setEnabled(false);
                this.setObserveItem.setEnabled(false);
                this.setCheckItem.setEnabled(false);
                this.setBadItem.setEnabled(false);
                FileListFileDetailsItem item = (FileListFileDetailsItem)selectedItems[0];
                Identity ownerId = item.getOwnerIdentity();
                if (!(ownerId instanceof LocalIdentity)) {
                    if (ownerId.isGOOD()) {
                        this.setObserveItem.setEnabled(true);
                        this.setCheckItem.setEnabled(true);
                        this.setBadItem.setEnabled(true);
                    } else if (ownerId.isCHECK()) {
                        this.setObserveItem.setEnabled(true);
                        this.setGoodItem.setEnabled(true);
                        this.setBadItem.setEnabled(true);
                    } else if (ownerId.isBAD()) {
                        this.setObserveItem.setEnabled(true);
                        this.setGoodItem.setEnabled(true);
                        this.setCheckItem.setEnabled(true);
                    } else if (ownerId.isOBSERVE()) {
                        this.setGoodItem.setEnabled(true);
                        this.setCheckItem.setEnabled(true);
                        this.setBadItem.setEnabled(true);
                    }
                }
            }
            if (FileListFileDetailsDialog.this.isOwnerSearchAllowed && selectedItems.length == 1) {
                this.addSeparator();
                this.add(this.showOwnerFilesItem);
            }
            super.show(invoker, x, y);
        }
    }
}

