/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.util.XMLTools;
import frost.util.XMLizable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SharedFileXmlFile
implements XMLizable {
    public static final int MAX_COMMENT_LENGTH = 100;
    public static final int MAX_KEYWORDS_LENGTH = 100;
    private static final Logger logger = Logger.getLogger(SharedFileXmlFile.class.getName());
    private static final char[] invalidChars = new char[]{'/', '\\', '?', '*', '<', '>', '\"', ':', '|'};
    private String sha = null;
    private Long size = new Long(0L);
    private String key = null;
    private String lastUploaded = null;
    private String filename = new String();
    private String comment = null;
    private String keywords = null;
    private int rating = 0;

    public void ensureValidity() {
        if (this.filename == null || this.filename.length() == 0) {
            this.filename = "filename";
        } else {
            for (char element : invalidChars) {
                this.filename = this.filename.replace(element, '_');
            }
        }
    }

    private boolean checkFilename() {
        if (this.filename == null || this.filename.length() == 0) {
            return false;
        }
        this.ensureValidity();
        return true;
    }

    private boolean checkKey() {
        if (this.key == null) {
            return true;
        }
        return this.key.startsWith("CHK@");
    }

    public boolean isSharedFileValid() {
        return this.size != null && this.sha != null && this.checkFilename() && this.checkKey();
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename.trim();
    }

    public String getSha() {
        return this.sha;
    }

    public void setSha(String s) {
        this.sha = s;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        if (this.key == null) {
            return this.key;
        }
        return this.key.trim();
    }

    public void setLastUploaded(String date) {
        if (date != null) {
            date = date.trim();
        }
        this.lastUploaded = date;
    }

    public String getLastUploaded() {
        return this.lastUploaded;
    }

    public void setSize(String size) {
        try {
            this.size = new Long(size);
        }
        catch (NumberFormatException ex) {
            this.size = null;
        }
    }

    public void setSize(long size) {
        this.size = new Long(size);
    }

    public Long getSize() {
        return this.size;
    }

    public Element getXMLElement(Document doc) {
        Element fileelement = doc.createElement("File");
        Element element = doc.createElement("name");
        CDATASection cdata = doc.createCDATASection(this.getFilename());
        element.appendChild(cdata);
        fileelement.appendChild(element);
        element = doc.createElement("sha");
        cdata = doc.createCDATASection(this.getSha());
        element.appendChild(cdata);
        fileelement.appendChild(element);
        element = doc.createElement("size");
        Text textnode = doc.createTextNode("" + this.getSize());
        element.appendChild(textnode);
        fileelement.appendChild(element);
        if (this.getKey() != null && this.getKey().trim().length() > 0) {
            element = doc.createElement("key");
            textnode = doc.createTextNode(this.getKey());
            element.appendChild(textnode);
            fileelement.appendChild(element);
        }
        if (this.getLastUploaded() != null && this.getLastUploaded().trim().length() > 0) {
            element = doc.createElement("uploaded");
            textnode = doc.createTextNode(this.getLastUploaded());
            element.appendChild(textnode);
            fileelement.appendChild(element);
        }
        if (this.getComment() != null && this.getComment().trim().length() > 0) {
            element = doc.createElement("comment");
            cdata = doc.createCDATASection(this.getComment());
            element.appendChild(cdata);
            fileelement.appendChild(element);
        }
        if (this.getKeywords() != null && this.getKeywords().trim().length() > 0) {
            element = doc.createElement("keywords");
            cdata = doc.createCDATASection(this.getKeywords());
            element.appendChild(cdata);
            fileelement.appendChild(element);
        }
        if (this.getRating() != 0) {
            element = doc.createElement("rating");
            textnode = doc.createTextNode(Integer.toString(this.getRating()));
            element.appendChild(textnode);
            fileelement.appendChild(element);
        }
        return fileelement;
    }

    public void loadXMLElement(Element current) throws SAXException {
        this.setFilename(XMLTools.getChildElementsCDATAValue(current, "name"));
        this.setSha(XMLTools.getChildElementsCDATAValue(current, "sha"));
        this.setKey(XMLTools.getChildElementsTextValue(current, "key"));
        this.setLastUploaded(XMLTools.getChildElementsTextValue(current, "uploaded"));
        this.setSize(XMLTools.getChildElementsTextValue(current, "size"));
        this.setComment(XMLTools.getChildElementsCDATAValue(current, "comment"));
        this.setKeywords(XMLTools.getChildElementsCDATAValue(current, "keywords"));
        String rat = XMLTools.getChildElementsTextValue(current, "rating");
        if (rat != null) {
            this.setRating(Integer.valueOf(rat));
        }
    }

    public boolean equals(Object obj) {
        SharedFileXmlFile other = (SharedFileXmlFile)obj;
        return this.sha.equals(other.getSha());
    }

    public static SharedFileXmlFile getInstance(Element e) {
        try {
            SharedFileXmlFile result = new SharedFileXmlFile();
            result.loadXMLElement(e);
            return result;
        }
        catch (SAXException ex) {
            logger.log(Level.SEVERE, "parsing file failed.", ex);
            return null;
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (comment != null) {
            if ((comment = comment.trim()).length() == 0) {
                comment = null;
            } else if (comment.length() > 100) {
                comment = comment.substring(0, 100);
            }
        }
        this.comment = comment;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        if (keywords != null) {
            if ((keywords = keywords.trim()).length() == 0) {
                keywords = null;
            } else if (keywords.length() > 100) {
                keywords = keywords.substring(0, 100);
            }
        }
        this.keywords = keywords;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }
}

