/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.Core;
import frost.MainFrame;
import frost.fcp.FcpHandler;
import frost.fcp.FcpResultGet;
import frost.fcp.FcpResultPut;
import frost.fcp.NodeAddress;
import frost.fcp.fcp07.FcpMultiRequestConnection;
import frost.fcp.fcp07.FcpMultiRequestConnectionTools;
import frost.fcp.fcp07.NodeMessage;
import frost.fcp.fcp07.filepersistence.FcpPersistentGet;
import frost.fcp.fcp07.filepersistence.FcpPersistentPut;
import frost.fcp.fcp07.filepersistence.FcpPersistentQueue;
import frost.fcp.fcp07.filepersistence.IFcpPersistentRequestsHandler;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadModel;
import frost.util.Mixed;
import frost.util.model.ModelItem;
import frost.util.model.SortedModelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManager
implements IFcpPersistentRequestsHandler {
    private static final Logger logger = Logger.getLogger(PersistenceManager.class.getName());
    private final Hashtable<String, FrostUploadItem> uploadModelItems = new Hashtable();
    private final Hashtable<String, FrostDownloadItem> downloadModelItems = new Hashtable();
    private final UploadModel uploadModel;
    private final DownloadModel downloadModel;
    private final DirectTransferQueue directTransferQueue;
    private final DirectTransferThread directTransferThread;
    private boolean showExternalItemsDownload;
    private boolean showExternalItemsUpload;
    private boolean isConnected = true;
    private final FcpPersistentQueue persistentQueue;
    private final FcpMultiRequestConnection fcpConn;
    private final FcpMultiRequestConnectionTools fcpTools;
    private final Set<String> directGETsInProgress = new HashSet<String>();
    private final Set<String> directPUTsInProgress = new HashSet<String>();
    private final Set<String> directPUTsWithoutAnswer = new HashSet<String>();

    public static boolean isPersistenceEnabled() {
        return FcpHandler.isFreenet07() && Core.frostSettings.getBoolValue("fcp2.usePersistence");
    }

    public boolean isDDA() {
        return Core.frostSettings.getBoolValue("fcp2.useDDA") && this.fcpConn.isDDA();
    }

    public PersistenceManager(UploadModel um, DownloadModel dm) throws Throwable {
        ModelItem ul;
        int x;
        this.showExternalItemsDownload = Core.frostSettings.getBoolValue("showExternalGlobalQueueDownloads");
        this.showExternalItemsUpload = Core.frostSettings.getBoolValue("showExternalGlobalQueueUploads");
        if (FcpHandler.inst().getNodes().isEmpty()) {
            throw new Exception("No freenet nodes defined");
        }
        NodeAddress na = FcpHandler.inst().getNodes().get(0);
        this.fcpConn = FcpMultiRequestConnection.createInstance(na);
        this.fcpTools = new FcpMultiRequestConnectionTools(this.fcpConn);
        Core.frostSettings.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("showExternalGlobalQueueDownloads")) {
                    PersistenceManager.this.showExternalItemsDownload = Core.frostSettings.getBoolValue("showExternalGlobalQueueDownloads");
                    if (PersistenceManager.this.showExternalItemsDownload) {
                        PersistenceManager.this.showExternalDownloadItems();
                    }
                } else if (evt.getPropertyName().equals("showExternalGlobalQueueUploads")) {
                    PersistenceManager.this.showExternalItemsUpload = Core.frostSettings.getBoolValue("showExternalGlobalQueueUploads");
                    if (PersistenceManager.this.showExternalItemsUpload) {
                        PersistenceManager.this.showExternalUploadItems();
                    }
                }
            }
        });
        this.uploadModel = um;
        this.downloadModel = dm;
        for (x = 0; x < this.uploadModel.getItemCount(); ++x) {
            ul = (FrostUploadItem)this.uploadModel.getItemAt(x);
            if (((FrostUploadItem)ul).getGqIdentifier() == null) continue;
            this.uploadModelItems.put(((FrostUploadItem)ul).getGqIdentifier(), (FrostUploadItem)ul);
        }
        for (x = 0; x < this.downloadModel.getItemCount(); ++x) {
            ul = (FrostDownloadItem)this.downloadModel.getItemAt(x);
            if (((FrostDownloadItem)ul).getGqIdentifier() == null) continue;
            this.downloadModelItems.put(((FrostDownloadItem)ul).getGqIdentifier(), (FrostDownloadItem)ul);
        }
        this.uploadModel.addOrderedModelListener(new SortedModelListener(){

            public void modelCleared() {
                for (FrostUploadItem ul : PersistenceManager.this.uploadModelItems.values()) {
                    if (ul.isExternal()) continue;
                    PersistenceManager.this.fcpTools.removeRequest(ul.getGqIdentifier());
                }
                PersistenceManager.this.uploadModelItems.clear();
            }

            public void itemAdded(int position, ModelItem item) {
                FrostUploadItem ul = (FrostUploadItem)item;
                PersistenceManager.this.uploadModelItems.put(ul.getGqIdentifier(), ul);
                if (!ul.isExternal()) {
                    PersistenceManager.this.startNewUploads();
                }
            }

            public void itemChanged(int position, ModelItem item) {
            }

            public void itemsRemoved(int[] positions, ModelItem[] items) {
                for (ModelItem item : items) {
                    FrostUploadItem ul = (FrostUploadItem)item;
                    PersistenceManager.this.uploadModelItems.remove(ul.getGqIdentifier());
                    if (ul.isExternal()) continue;
                    PersistenceManager.this.fcpTools.removeRequest(ul.getGqIdentifier());
                }
            }
        });
        this.downloadModel.addOrderedModelListener(new SortedModelListener(){

            public void modelCleared() {
                for (FrostDownloadItem ul : PersistenceManager.this.downloadModelItems.values()) {
                    if (ul.isExternal()) continue;
                    PersistenceManager.this.fcpTools.removeRequest(ul.getGqIdentifier());
                }
                PersistenceManager.this.downloadModelItems.clear();
            }

            public void itemAdded(int position, ModelItem item) {
                FrostDownloadItem ul = (FrostDownloadItem)item;
                PersistenceManager.this.downloadModelItems.put(ul.getGqIdentifier(), ul);
                if (!ul.isExternal()) {
                    PersistenceManager.this.startNewDownloads();
                }
            }

            public void itemChanged(int position, ModelItem item) {
            }

            public void itemsRemoved(int[] positions, ModelItem[] items) {
                for (ModelItem item : items) {
                    FrostDownloadItem ul = (FrostDownloadItem)item;
                    PersistenceManager.this.downloadModelItems.remove(ul.getGqIdentifier());
                    if (ul.isExternal()) continue;
                    PersistenceManager.this.fcpTools.removeRequest(ul.getGqIdentifier());
                }
            }
        });
        this.directTransferQueue = new DirectTransferQueue();
        this.directTransferThread = new DirectTransferThread();
        this.persistentQueue = new FcpPersistentQueue(this.fcpTools, this);
    }

    public void startThreads() {
        this.directTransferThread.start();
        this.persistentQueue.startThreads();
        TimerTask task = new TimerTask(){

            public void run() {
                PersistenceManager.this.maybeStartRequests();
            }
        };
        Core.schedule(task, 3000L, 3000L);
    }

    public void removeRequests(List<String> requests) {
        for (String id : requests) {
            this.fcpTools.removeRequest(id);
        }
    }

    public void changeItemPriorites(ModelItem[] items, int newPrio) {
        if (items == null || items.length == 0) {
            return;
        }
        for (ModelItem item : items) {
            String gqid = null;
            if (item instanceof FrostUploadItem) {
                FrostUploadItem ui = (FrostUploadItem)item;
                gqid = ui.getGqIdentifier();
            } else if (item instanceof FrostDownloadItem) {
                FrostDownloadItem di = (FrostDownloadItem)item;
                gqid = di.getGqIdentifier();
            }
            if (gqid == null) continue;
            this.fcpTools.changeRequestPriority(gqid, newPrio);
        }
    }

    public boolean isItemInGlobalQueue(FrostDownloadItem dlItem) {
        return this.persistentQueue.isIdInGlobalQueue(dlItem.getGqIdentifier());
    }

    public boolean isItemInGlobalQueue(FrostUploadItem ulItem) {
        return this.persistentQueue.isIdInGlobalQueue(ulItem.getGqIdentifier());
    }

    private void maybeStartRequests() {
        this.startNewUploads();
        this.startNewDownloads();
    }

    @Override
    public void connected() {
        this.isConnected = true;
        MainFrame.getInstance().setConnected();
        logger.severe("now connected");
    }

    @Override
    public void disconnected() {
        this.isConnected = false;
        MainFrame.getInstance().setDisconnected();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PersistenceManager.this.uploadModel.removeExternalUploads();
                PersistenceManager.this.downloadModel.removeExternalDownloads();
            }
        });
        logger.severe("disconnected!");
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean maybeEnqueueDirectGet(FrostDownloadItem dlItem, long expectedFileSize) {
        File targetFile;
        if (!(this.isDirectTransferInProgress(dlItem) || (targetFile = new File(Core.frostSettings.getValue("downloadDirectory") + dlItem.getFilename())).isFile() && targetFile.length() == expectedFileSize)) {
            this.directTransferQueue.appendItemToQueue(dlItem);
            return true;
        }
        return false;
    }

    private void applyState(FrostDownloadItem dlItem, FcpPersistentGet getReq) {
        int returnCode;
        if (dlItem.isInternalRemoveExpected() && getReq.isFailed() && (returnCode = getReq.getCode()) == 25) {
            return;
        }
        if (dlItem.getPriority() != getReq.getPriority()) {
            dlItem.setPriority(getReq.getPriority());
        }
        if (dlItem.isDirect() != getReq.isDirect()) {
            dlItem.setDirect(getReq.isDirect());
        }
        if (!(getReq.isProgressSet() || getReq.isSuccess() || getReq.isFailed())) {
            if (dlItem.getState() == 1) {
                dlItem.setState(5);
            }
            return;
        }
        if (getReq.isProgressSet()) {
            int doneBlocks = getReq.getDoneBlocks();
            int requiredBlocks = getReq.getRequiredBlocks();
            int totalBlocks = getReq.getTotalBlocks();
            boolean isFinalized = getReq.isFinalized();
            if (totalBlocks > 0) {
                dlItem.setDoneBlocks(doneBlocks);
                dlItem.setRequiredBlocks(requiredBlocks);
                dlItem.setTotalBlocks(totalBlocks);
                dlItem.setFinalized(isFinalized);
                dlItem.fireValueChanged();
            }
            if (dlItem.getState() != 5) {
                dlItem.setState(5);
            }
        }
        if (getReq.isSuccess()) {
            dlItem.setFinalized(true);
            if (dlItem.getTotalBlocks() > 0 && dlItem.getDoneBlocks() < dlItem.getRequiredBlocks()) {
                dlItem.setDoneBlocks(dlItem.getRequiredBlocks());
                dlItem.fireValueChanged();
            }
            if (dlItem.isExternal()) {
                dlItem.setFileSize(getReq.getFilesize());
                dlItem.setState(3);
            } else if (dlItem.isDirect()) {
                this.maybeEnqueueDirectGet(dlItem, getReq.getFilesize());
            } else {
                FcpResultGet result = new FcpResultGet(true);
                File targetFile = new File(Core.frostSettings.getValue("downloadDirectory") + dlItem.getFilename());
                FileTransferManager.inst().getDownloadManager().notifyDownloadFinished(dlItem, result, targetFile);
            }
        }
        if (getReq.isFailed()) {
            String desc = getReq.getCodeDesc();
            if (dlItem.isExternal()) {
                dlItem.setState(4);
                dlItem.setErrorCodeDescription(desc);
            } else {
                int returnCode2 = getReq.getCode();
                boolean isFatal = getReq.isFatal();
                String redirectURI = getReq.getRedirectURI();
                FcpResultGet result = new FcpResultGet(false, returnCode2, desc, isFatal, redirectURI);
                File targetFile = new File(Core.frostSettings.getValue("downloadDirectory") + dlItem.getFilename());
                boolean retry = FileTransferManager.inst().getDownloadManager().notifyDownloadFinished(dlItem, result, targetFile);
                if (retry) {
                    this.fcpTools.removeRequest(getReq.getIdentifier());
                    this.startDownload(dlItem);
                }
            }
        }
    }

    private void applyState(FrostUploadItem ulItem, FcpPersistentPut putReq) {
        int returnCode;
        if (ulItem.isInternalRemoveExpected() && putReq.isFailed() && (returnCode = putReq.getCode()) == 25) {
            return;
        }
        if (this.directPUTsWithoutAnswer.contains(ulItem.getGqIdentifier())) {
            this.directPUTsWithoutAnswer.remove(ulItem.getGqIdentifier());
        }
        if (ulItem.getPriority() != putReq.getPriority()) {
            ulItem.setPriority(putReq.getPriority());
        }
        if (!(putReq.isProgressSet() || putReq.isSuccess() || putReq.isFailed())) {
            if (ulItem.getState() == 7) {
                ulItem.setState(4);
            }
            return;
        }
        if (putReq.isProgressSet()) {
            int doneBlocks = putReq.getDoneBlocks();
            int totalBlocks = putReq.getTotalBlocks();
            boolean isFinalized = putReq.isFinalized();
            if (totalBlocks > 0) {
                ulItem.setDoneBlocks(doneBlocks);
                ulItem.setTotalBlocks(totalBlocks);
                ulItem.setFinalized(isFinalized);
                ulItem.fireValueChanged();
            }
            if (ulItem.getState() != 4) {
                ulItem.setState(4);
            }
        }
        if (putReq.isSuccess()) {
            ulItem.setFinalized(true);
            if (ulItem.getTotalBlocks() > 0 && ulItem.getDoneBlocks() != ulItem.getTotalBlocks()) {
                ulItem.setDoneBlocks(ulItem.getTotalBlocks());
            }
            String chkKey = putReq.getUri();
            if (ulItem.isExternal()) {
                ulItem.setState(1);
                ulItem.setKey(chkKey);
            } else {
                FcpResultPut result = new FcpResultPut(1, chkKey);
                FileTransferManager.inst().getUploadManager().notifyUploadFinished(ulItem, result);
            }
        }
        if (putReq.isFailed()) {
            String desc = putReq.getCodeDesc();
            if (ulItem.isExternal()) {
                ulItem.setState(8);
                ulItem.setErrorCodeDescription(desc);
            } else {
                int returnCode2 = putReq.getCode();
                boolean isFatal = putReq.isFatal();
                FcpResultPut result = returnCode2 == 9 ? new FcpResultPut(2, returnCode2, desc, isFatal) : (returnCode2 == 5 ? new FcpResultPut(4, returnCode2, desc, isFatal) : new FcpResultPut(3, returnCode2, desc, isFatal));
                FileTransferManager.inst().getUploadManager().notifyUploadFinished(ulItem, result);
            }
        }
    }

    private void startNewUploads() {
        FrostUploadItem ulItem;
        boolean isLimited = true;
        int currentAllowedUploadCount = 0;
        int allowedConcurrentUploads = Core.frostSettings.getIntValue("uploadThreads");
        if (allowedConcurrentUploads <= 0) {
            isLimited = false;
        } else {
            int runningUploads = 0;
            for (FrostUploadItem ulItem2 : this.uploadModelItems.values()) {
                if (ulItem2.isExternal() || ulItem2.getState() != 4) continue;
                ++runningUploads;
            }
            currentAllowedUploadCount = allowedConcurrentUploads - runningUploads;
            if (currentAllowedUploadCount < 0) {
                currentAllowedUploadCount = 0;
            }
        }
        while (!(isLimited && currentAllowedUploadCount <= 0 || (ulItem = FileTransferManager.inst().getUploadManager().selectNextUploadItem()) == null)) {
            if (!this.startUpload(ulItem)) continue;
            --currentAllowedUploadCount;
        }
    }

    public boolean startUpload(FrostUploadItem ulItem) {
        if (ulItem == null || ulItem.getState() != 7) {
            return false;
        }
        ulItem.setUploadStartedMillis(System.currentTimeMillis());
        ulItem.setState(4);
        if (this.isDDA()) {
            boolean setTargetFileName;
            boolean doMime;
            if (ulItem.isSharedFile()) {
                doMime = false;
                setTargetFileName = false;
            } else {
                doMime = true;
                setTargetFileName = true;
            }
            this.fcpTools.startPersistentPut(ulItem.getGqIdentifier(), ulItem.getFile(), doMime, setTargetFileName);
        } else {
            this.directTransferQueue.appendItemToQueue(ulItem);
        }
        return true;
    }

    private void startNewDownloads() {
        FrostDownloadItem dlItem;
        boolean isLimited = true;
        int currentAllowedDownloadCount = 0;
        int allowedConcurrentDownloads = Core.frostSettings.getIntValue("downloadThreads");
        if (allowedConcurrentDownloads <= 0) {
            isLimited = false;
        } else {
            int runningDownloads = 0;
            for (FrostDownloadItem dlItem2 : this.downloadModelItems.values()) {
                if (dlItem2.isExternal() || dlItem2.getState() != 5) continue;
                ++runningDownloads;
            }
            currentAllowedDownloadCount = allowedConcurrentDownloads - runningDownloads;
            if (currentAllowedDownloadCount < 0) {
                currentAllowedDownloadCount = 0;
            }
        }
        while (!(isLimited && currentAllowedDownloadCount <= 0 || (dlItem = FileTransferManager.inst().getDownloadManager().selectNextDownloadItem()) == null)) {
            if (!this.startDownload(dlItem)) continue;
            --currentAllowedDownloadCount;
        }
    }

    public boolean startDownload(FrostDownloadItem dlItem) {
        if (dlItem == null || dlItem.getState() != 1) {
            return false;
        }
        dlItem.setDownloadStartedTime(System.currentTimeMillis());
        dlItem.setState(5);
        String gqid = dlItem.getGqIdentifier();
        File targetFile = new File(Core.frostSettings.getValue("downloadDirectory") + dlItem.getFilename());
        dlItem.setDirect(!this.fcpTools.isDDA());
        this.fcpTools.startPersistentGet(dlItem.getKey(), gqid, targetFile);
        return true;
    }

    private void showExternalUploadItems() {
        Map<String, FcpPersistentPut> items = this.persistentQueue.getUploadRequests();
        for (FcpPersistentPut uploadRequest : items.values()) {
            if (this.uploadModelItems.containsKey(uploadRequest.getIdentifier())) continue;
            this.addExternalItem(uploadRequest);
        }
    }

    private void showExternalDownloadItems() {
        Map<String, FcpPersistentGet> items = this.persistentQueue.getDownloadRequests();
        for (FcpPersistentGet downloadRequest : items.values()) {
            if (this.downloadModelItems.containsKey(downloadRequest.getIdentifier())) continue;
            this.addExternalItem(downloadRequest);
        }
    }

    private void addExternalItem(FcpPersistentPut uploadRequest) {
        String stmp;
        final FrostUploadItem ulItem = new FrostUploadItem();
        ulItem.setGqIdentifier(uploadRequest.getIdentifier());
        ulItem.setExternal(true);
        String fileName = uploadRequest.getFilename();
        if (fileName == null) {
            fileName = uploadRequest.getIdentifier();
        } else if ((fileName.indexOf(47) > -1 || fileName.indexOf(92) > -1) && (stmp = new File(fileName).getName()).length() > 0) {
            fileName = stmp;
        }
        ulItem.setFile(new File(fileName));
        ulItem.setState(4);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PersistenceManager.this.uploadModel.addExternalItem(ulItem);
            }
        });
        this.applyState(ulItem, uploadRequest);
    }

    private void addExternalItem(FcpPersistentGet downloadRequest) {
        String stmp;
        String fileName = downloadRequest.getFilename();
        if (fileName == null) {
            fileName = downloadRequest.getIdentifier();
        } else if ((fileName.indexOf(47) > -1 || fileName.indexOf(92) > -1) && (stmp = new File(fileName).getName()).length() > 0) {
            fileName = stmp;
        }
        final FrostDownloadItem dlItem = new FrostDownloadItem(fileName, downloadRequest.getUri());
        dlItem.setExternal(true);
        dlItem.setGqIdentifier(downloadRequest.getIdentifier());
        dlItem.setState(5);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PersistenceManager.this.downloadModel.addExternalItem(dlItem);
            }
        });
        this.applyState(dlItem, downloadRequest);
    }

    public boolean isDirectTransferInProgress(FrostDownloadItem dlItem) {
        String id = dlItem.getGqIdentifier();
        return this.directGETsInProgress.contains(id);
    }

    public boolean isDirectTransferInProgress(FrostUploadItem ulItem) {
        String id = ulItem.getGqIdentifier();
        if (this.directPUTsInProgress.contains(id)) {
            return true;
        }
        return this.directPUTsWithoutAnswer.contains(id);
    }

    @Override
    public void persistentRequestError(String id, NodeMessage nm) {
        if (this.uploadModelItems.containsKey(id)) {
            FrostUploadItem item = this.uploadModelItems.get(id);
            item.setEnabled(Boolean.FALSE);
            item.setState(8);
            item.setErrorCodeDescription(nm.getStringValue("CodeDescription"));
        } else if (this.downloadModelItems.containsKey(id)) {
            FrostDownloadItem item = this.downloadModelItems.get(id);
            item.setEnabled(Boolean.FALSE);
            item.setState(4);
            item.setErrorCodeDescription(nm.getStringValue("CodeDescription"));
        } else {
            System.out.println("persistentRequestError: ID not in any model: " + id);
        }
    }

    @Override
    public void persistentRequestAdded(FcpPersistentPut uploadRequest) {
        FrostUploadItem ulItem = this.uploadModelItems.get(uploadRequest.getIdentifier());
        if (ulItem != null) {
            this.applyState(ulItem, uploadRequest);
        } else if (this.showExternalItemsUpload) {
            this.addExternalItem(uploadRequest);
        }
    }

    @Override
    public void persistentRequestAdded(FcpPersistentGet downloadRequest) {
        FrostDownloadItem dlItem = this.downloadModelItems.get(downloadRequest.getIdentifier());
        if (dlItem != null) {
            this.applyState(dlItem, downloadRequest);
        } else if (this.showExternalItemsDownload) {
            this.addExternalItem(downloadRequest);
        }
    }

    @Override
    public void persistentRequestModified(FcpPersistentPut uploadRequest) {
        if (this.uploadModelItems.containsKey(uploadRequest.getIdentifier())) {
            FrostUploadItem ulItem = this.uploadModelItems.get(uploadRequest.getIdentifier());
            ulItem.setPriority(uploadRequest.getPriority());
        }
    }

    @Override
    public void persistentRequestModified(FcpPersistentGet downloadRequest) {
        if (this.downloadModelItems.containsKey(downloadRequest.getIdentifier())) {
            FrostDownloadItem dlItem = this.downloadModelItems.get(downloadRequest.getIdentifier());
            dlItem.setPriority(downloadRequest.getPriority());
        }
    }

    @Override
    public void persistentRequestRemoved(FcpPersistentPut uploadRequest) {
        if (this.uploadModelItems.containsKey(uploadRequest.getIdentifier())) {
            final FrostUploadItem ulItem = this.uploadModelItems.get(uploadRequest.getIdentifier());
            if (ulItem.isExternal()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PersistenceManager.this.uploadModel.removeItems(new ModelItem[]{ulItem});
                    }
                });
            } else if (ulItem.isInternalRemoveExpected()) {
                ulItem.setInternalRemoveExpected(false);
            } else if (ulItem.getState() != 1) {
                ulItem.setEnabled(false);
                ulItem.setState(8);
                ulItem.setErrorCodeDescription("Disappeared from global queue");
            }
        }
    }

    @Override
    public void persistentRequestRemoved(FcpPersistentGet downloadRequest) {
        if (this.downloadModelItems.containsKey(downloadRequest.getIdentifier())) {
            final FrostDownloadItem dlItem = this.downloadModelItems.get(downloadRequest.getIdentifier());
            if (dlItem.isExternal()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PersistenceManager.this.downloadModel.removeItems(new ModelItem[]{dlItem});
                    }
                });
            } else if (dlItem.isInternalRemoveExpected()) {
                dlItem.setInternalRemoveExpected(false);
            } else if (dlItem.getState() != 3) {
                dlItem.setEnabled(false);
                dlItem.setState(4);
                dlItem.setErrorCodeDescription("Disappeared from global queue");
            }
        }
    }

    @Override
    public void persistentRequestUpdated(FcpPersistentPut uploadRequest) {
        FrostUploadItem ui = this.uploadModelItems.get(uploadRequest.getIdentifier());
        if (ui == null) {
            return;
        }
        this.applyState(ui, uploadRequest);
    }

    @Override
    public void persistentRequestUpdated(FcpPersistentGet downloadRequest) {
        FrostDownloadItem dl = this.downloadModelItems.get(downloadRequest.getIdentifier());
        if (dl == null) {
            return;
        }
        this.applyState(dl, downloadRequest);
    }

    private class DirectTransferQueue {
        private final LinkedList<ModelItem> queue = new LinkedList();

        private DirectTransferQueue() {
        }

        public synchronized ModelItem getItemFromQueue() {
            try {
                while (this.queue.isEmpty()) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                return null;
            }
            if (!this.queue.isEmpty()) {
                ModelItem item = this.queue.removeFirst();
                return item;
            }
            return null;
        }

        public synchronized void appendItemToQueue(FrostDownloadItem item) {
            String id = item.getGqIdentifier();
            PersistenceManager.this.directGETsInProgress.add(id);
            this.queue.addLast(item);
            this.notifyAll();
        }

        public synchronized void appendItemToQueue(FrostUploadItem item) {
            String id = item.getGqIdentifier();
            PersistenceManager.this.directPUTsInProgress.add(id);
            this.queue.addLast(item);
            this.notifyAll();
        }

        public synchronized int getQueueSize() {
            return this.queue.size();
        }
    }

    private class DirectTransferThread
    extends Thread {
        private DirectTransferThread() {
        }

        public void run() {
            int maxAllowedExceptions = 5;
            int catchedExceptions = 0;
            do {
                try {
                    boolean retryNow;
                    FcpResultGet result;
                    String gqid;
                    ModelItem item;
                    while ((item = PersistenceManager.this.directTransferQueue.getItemFromQueue()) == null) {
                        Mixed.wait(5000);
                    }
                    if (item instanceof FrostUploadItem) {
                        boolean setTargetFileName;
                        boolean doMime;
                        FrostUploadItem ulItem = (FrostUploadItem)item;
                        gqid = ulItem.getGqIdentifier();
                        File sourceFile = ulItem.getFile();
                        if (ulItem.isSharedFile()) {
                            doMime = false;
                            setTargetFileName = false;
                        } else {
                            doMime = true;
                            setTargetFileName = true;
                        }
                        NodeMessage answer = PersistenceManager.this.fcpTools.startDirectPersistentPut(gqid, sourceFile, doMime, setTargetFileName);
                        if (answer == null) {
                            String desc = "Could not open a new FCP2 socket for direct put!";
                            FcpResultPut result2 = new FcpResultPut(3, -1, "Could not open a new FCP2 socket for direct put!", false);
                            FileTransferManager.inst().getUploadManager().notifyUploadFinished(ulItem, result2);
                            logger.severe("Could not open a new FCP2 socket for direct put!");
                        } else {
                            PersistenceManager.this.directPUTsWithoutAnswer.add(gqid);
                        }
                        PersistenceManager.this.directPUTsInProgress.remove(gqid);
                        continue;
                    }
                    if (!(item instanceof FrostDownloadItem)) continue;
                    FrostDownloadItem dlItem = (FrostDownloadItem)item;
                    gqid = dlItem.getGqIdentifier();
                    File targetFile = new File(Core.frostSettings.getValue("downloadDirectory") + dlItem.getFilename());
                    NodeMessage answer = PersistenceManager.this.fcpTools.startDirectPersistentGet(gqid, targetFile);
                    if (answer != null) {
                        result = new FcpResultGet(true);
                        FileTransferManager.inst().getDownloadManager().notifyDownloadFinished(dlItem, result, targetFile);
                        retryNow = false;
                    } else {
                        logger.severe("Could not open a new fcp socket for direct get!");
                        result = new FcpResultGet(false);
                        retryNow = FileTransferManager.inst().getDownloadManager().notifyDownloadFinished(dlItem, result, targetFile);
                    }
                    PersistenceManager.this.directGETsInProgress.remove(gqid);
                    if (!retryNow) continue;
                    PersistenceManager.this.startDownload(dlItem);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Exception catched", t);
                    ++catchedExceptions;
                }
            } while (catchedExceptions <= 5);
            logger.log(Level.SEVERE, "Stopping DirectTransferThread because of too much exceptions");
        }
    }
}

