/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeMessage {
    private static final Logger logger = Logger.getLogger(NodeMessage.class.getName());
    private final String messageName;
    private final HashMap<String, String> items;
    private String messageEndMarker = null;

    public static NodeMessage readMessage(BufferedInputStream fcpInp) {
        NodeMessage result = null;
        boolean isfirstline = true;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(128);
        while (true) {
            String tmp;
            if ((tmp = NodeMessage.readLine(fcpInp, bytes)) == null) {
                return null;
            }
            bytes.reset();
            if (tmp.trim().length() == 0) continue;
            if (isfirstline) {
                result = new NodeMessage(tmp);
                isfirstline = false;
                continue;
            }
            if (tmp.compareTo("Data") == 0) {
                result.setEnd(tmp);
                break;
            }
            if (tmp.compareTo("EndMessage") == 0) {
                result.setEnd(tmp);
                break;
            }
            if (tmp.indexOf("=") > -1) {
                String[] tmp2 = tmp.split("=", 2);
                result.addItem(tmp2[0], tmp2[1]);
                continue;
            }
            logger.severe("ERROR: no '=' in message line. This shouldn't happen. FIXME. : " + tmp + " -> " + tmp.length());
            result.addItem("Unknown", tmp);
        }
        return result;
    }

    private static String readLine(BufferedInputStream fcpInp, ByteArrayOutputStream bytes) {
        try {
            while (true) {
                int c;
                if ((c = fcpInp.read()) < 0) {
                    return null;
                }
                if (c == 10) {
                    return new String(bytes.toByteArray(), "UTF-8");
                }
                bytes.write(c);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Throwable catched", e);
            return null;
        }
    }

    protected NodeMessage(String name) {
        this.messageName = name;
        this.items = new HashMap();
    }

    public String toString() {
        return this.messageName + " " + this.items + " " + this.messageEndMarker;
    }

    protected void setItem(String name, String value) {
        this.items.put(name, value);
    }

    protected void setEnd(String em) {
        this.messageEndMarker = em;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public String getMessageEnd() {
        return this.messageEndMarker;
    }

    public boolean isMessageName(String aName) {
        if (aName == null) {
            return false;
        }
        return aName.equalsIgnoreCase(this.messageName);
    }

    public boolean isValueSet(String name) {
        return this.items.get(name) != null;
    }

    public String getStringValue(String name) {
        return this.items.get(name);
    }

    public long getLongValue(String name) {
        return Long.parseLong(this.items.get(name));
    }

    public int getIntValue(String name) {
        return Integer.parseInt(this.items.get(name));
    }

    public boolean getBoolValue(String name) {
        return "true".equalsIgnoreCase(this.items.get(name));
    }

    public void addItem(String key, String value) {
        this.items.put(key, value);
    }
}

