/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp05;

import frost.Core;
import frost.fcp.DataNotFoundException;
import frost.fcp.FcpResultGet;
import frost.fcp.FcpToolsException;
import frost.fcp.fcp05.FcpConnection;
import frost.fcp.fcp05.FcpFactory;
import frost.fcp.fcp05.FecBlock;
import frost.fcp.fcp05.FecSplitfile;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.util.FileAccess;
import frost.util.Mixed;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcpRequest {
    static final boolean DEBUG = true;
    private static final Logger logger = Logger.getLogger(FcpRequest.class.getName());

    public static void updateProgress(FrostDownloadItem dlItem) {
        FecSplitfile splitfile;
        if (dlItem == null || dlItem.getKey() == null) {
            return;
        }
        File t1 = new File(dlItem.getTargetPath() + ".redirect");
        if (!t1.isFile() || t1.length() == 0L) {
            return;
        }
        try {
            splitfile = new FecSplitfile(new File(dlItem.getTargetPath()), t1);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception thrown in updateProgress", ex);
            return;
        }
        int displayedRequiredBlocks = splitfile.getDataBlocks().size();
        int displayedAvailableBlocks = splitfile.getDataBlocks().size() + splitfile.getCheckBlocks().size();
        int displayedFinishedBlocks = 0;
        for (int segmentNo = 0; segmentNo < splitfile.getSegmentCount(); ++segmentNo) {
            FecSplitfile.SingleSegmentValues seginf = splitfile.getValuesForSegment(segmentNo);
            int neededBlockCount = seginf.dataBlockCount;
            int segmentsFinishedBlocks = 0;
            segmentsFinishedBlocks += FcpRequest.getBlocksInSegmentWithState(splitfile.getDataBlocks(), segmentNo, 3).size();
            if ((segmentsFinishedBlocks += FcpRequest.getBlocksInSegmentWithState(splitfile.getCheckBlocks(), segmentNo, 3).size()) > neededBlockCount) {
                displayedFinishedBlocks += neededBlockCount;
                continue;
            }
            displayedFinishedBlocks += segmentsFinishedBlocks;
        }
        splitfile.closeBuckets();
        dlItem.setDoneBlocks(displayedFinishedBlocks);
        dlItem.setRequiredBlocks(displayedRequiredBlocks);
        dlItem.setTotalBlocks(displayedAvailableBlocks);
        dlItem.fireValueChanged();
    }

    private static boolean getFECSplitFile(File target, File redirect, int htl, FrostDownloadItem dlItem) {
        boolean optionTryAllSegments = Core.frostSettings.getBoolValue("downloadTryAllSegments");
        boolean optionDecodeAfterDownload = Core.frostSettings.getBoolValue("downloadDecodeAfterEachSegment");
        FecSplitfile splitfile = null;
        File t1 = new File(target.getPath() + ".redirect");
        if (!t1.exists() || t1.length() == 0L) {
            t1.delete();
            redirect.renameTo(t1);
            redirect = new File(target.getPath() + ".redirect");
        } else {
            redirect.delete();
            redirect = t1;
        }
        try {
            splitfile = new FecSplitfile(target, redirect);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception thrown in getFECSplitFile(File, File, int, FrostDownloadItem)", ex);
            return false;
        }
        int displayedRequiredBlocks = splitfile.getDataBlocks().size();
        int displayedAvailableBlocks = splitfile.getDataBlocks().size() + splitfile.getCheckBlocks().size();
        int displayedFinishedBlocks = 0;
        if (dlItem != null) {
            for (int segmentNo = 0; segmentNo < splitfile.getSegmentCount(); ++segmentNo) {
                FecSplitfile.SingleSegmentValues seginf = splitfile.getValuesForSegment(segmentNo);
                int neededBlockCount = seginf.dataBlockCount;
                int segmentsFinishedBlocks = 0;
                segmentsFinishedBlocks += FcpRequest.getBlocksInSegmentWithState(splitfile.getDataBlocks(), segmentNo, 3).size();
                if ((segmentsFinishedBlocks += FcpRequest.getBlocksInSegmentWithState(splitfile.getCheckBlocks(), segmentNo, 3).size()) > neededBlockCount) {
                    displayedFinishedBlocks += neededBlockCount;
                    continue;
                }
                displayedFinishedBlocks += segmentsFinishedBlocks;
            }
            dlItem.setFileSize(new Long(splitfile.getDataFileSize()));
            dlItem.setDoneBlocks(displayedFinishedBlocks);
            dlItem.setRequiredBlocks(displayedRequiredBlocks);
            dlItem.setTotalBlocks(displayedAvailableBlocks);
            dlItem.fireValueChanged();
            dlItem.setState(5);
        }
        boolean[] wasSegmentSuccessful = new boolean[splitfile.getSegmentCount()];
        Arrays.fill(wasSegmentSuccessful, false);
        for (int segmentNo = 0; segmentNo < splitfile.getSegmentCount(); ++segmentNo) {
            FecSplitfile.SingleSegmentValues seginf = splitfile.getValuesForSegment(segmentNo);
            int neededBlockCount = seginf.dataBlockCount;
            ArrayList<FecBlock> missingBlocks = FcpRequest.getBlocksInSegmentWithState(splitfile.getDataBlocks(), segmentNo, 1);
            missingBlocks.addAll(FcpRequest.getBlocksInSegmentWithState(splitfile.getCheckBlocks(), segmentNo, 1));
            int missingOverallBlockCount = missingBlocks.size();
            int segmentsFinishedBlocks = 0;
            segmentsFinishedBlocks += FcpRequest.getBlocksInSegmentWithState(splitfile.getDataBlocks(), segmentNo, 3).size();
            segmentsFinishedBlocks += FcpRequest.getBlocksInSegmentWithState(splitfile.getCheckBlocks(), segmentNo, 3).size();
            if (missingOverallBlockCount == 0) {
                logger.info("Segment " + segmentNo + " is already decoded.");
                wasSegmentSuccessful[segmentNo] = true;
                continue;
            }
            int maxThreads = Core.frostSettings.getIntValue("splitfileDownloadThreads");
            if (segmentsFinishedBlocks < neededBlockCount) {
                int y;
                boolean threadsFinished;
                Collections.shuffle(missingBlocks);
                int actBlockIx = 0;
                Vector<GetKeyThread> runningThreads = new Vector<GetKeyThread>(maxThreads);
                while (segmentsFinishedBlocks < neededBlockCount && actBlockIx < missingBlocks.size()) {
                    threadsFinished = false;
                    for (y = runningThreads.size() - 1; y >= 0; --y) {
                        GetKeyThread gkt = (GetKeyThread)runningThreads.get(y);
                        if (gkt.isAlive()) continue;
                        if (gkt.getSuccess()) {
                            if (segmentsFinishedBlocks < neededBlockCount) {
                                ++displayedFinishedBlocks;
                            }
                            ++segmentsFinishedBlocks;
                            if (dlItem != null) {
                                dlItem.setDoneBlocks(displayedFinishedBlocks);
                                dlItem.setRequiredBlocks(displayedRequiredBlocks);
                                dlItem.setTotalBlocks(displayedAvailableBlocks);
                                dlItem.fireValueChanged();
                            }
                        }
                        runningThreads.remove(y);
                        threadsFinished = true;
                    }
                    if (threadsFinished) continue;
                    int maxThreadsNeeded = neededBlockCount - segmentsFinishedBlocks;
                    int threadCountAllowedToStart = maxThreads - runningThreads.size();
                    if (maxThreadsNeeded > 0 && threadCountAllowedToStart > 0) {
                        FecBlock block = missingBlocks.get(actBlockIx);
                        ++actBlockIx;
                        GetKeyThread thread = new GetKeyThread(splitfile, block, htl);
                        runningThreads.add(thread);
                        thread.start();
                        Mixed.waitRandom(3000);
                        continue;
                    }
                    Mixed.wait(1000);
                }
                while (runningThreads.size() > 0) {
                    threadsFinished = false;
                    for (y = runningThreads.size() - 1; y >= 0; --y) {
                        GetKeyThread gkt = (GetKeyThread)runningThreads.get(y);
                        if (segmentsFinishedBlocks >= neededBlockCount && !gkt.isAborted()) {
                            gkt.abortTransfer();
                            Mixed.wait(500);
                        }
                        if (gkt.isAlive()) continue;
                        if (gkt.getSuccess()) {
                            if (segmentsFinishedBlocks < neededBlockCount) {
                                ++displayedFinishedBlocks;
                            }
                            ++segmentsFinishedBlocks;
                            if (dlItem != null) {
                                dlItem.setDoneBlocks(displayedFinishedBlocks);
                                dlItem.setRequiredBlocks(displayedRequiredBlocks);
                                dlItem.setTotalBlocks(displayedAvailableBlocks);
                                dlItem.fireValueChanged();
                            }
                        }
                        runningThreads.remove(y);
                        threadsFinished = true;
                    }
                    if (threadsFinished) continue;
                    Mixed.wait(1000);
                }
            }
            if (splitfile.isDecodeable(segmentNo)) {
                logger.info("Segment " + segmentNo + " is decodeable...");
                if (!optionDecodeAfterDownload) {
                    if (dlItem != null) {
                        dlItem.setState(6);
                    }
                    try {
                        splitfile.decode(segmentNo);
                    }
                    catch (Throwable e1) {
                        logger.log(Level.SEVERE, "segment decode failed", e1);
                        wasSegmentSuccessful[segmentNo] = false;
                        break;
                    }
                    if (dlItem != null) {
                        dlItem.setState(5);
                    }
                    FcpRequest.setBlocksInSegmentFinished(splitfile.getDataBlocks(), segmentNo);
                    FcpRequest.setBlocksInSegmentFinished(splitfile.getCheckBlocks(), segmentNo);
                    splitfile.createRedirectFile(true);
                }
                wasSegmentSuccessful[segmentNo] = true;
                continue;
            }
            logger.warning("Segment " + segmentNo + " is NOT decodeable...");
            wasSegmentSuccessful[segmentNo] = false;
            if (!optionTryAllSegments) break;
        }
        boolean success = true;
        for (boolean element : wasSegmentSuccessful) {
            if (element) continue;
            success = false;
            break;
        }
        if (optionDecodeAfterDownload && success) {
            if (dlItem != null) {
                dlItem.setState(6);
            }
            for (int segmentNo = 0; segmentNo < splitfile.getSegmentCount(); ++segmentNo) {
                try {
                    splitfile.decode(segmentNo);
                    continue;
                }
                catch (Throwable e1) {
                    logger.log(Level.SEVERE, "splitfile decode failed", e1);
                    success = false;
                    wasSegmentSuccessful[segmentNo] = false;
                    break;
                }
            }
            if (dlItem != null) {
                dlItem.setState(5);
            }
        }
        splitfile.closeBuckets();
        if (success) {
            splitfile.setCorrectDatafileSize();
            if (dlItem != null) {
                splitfile.finishDownload(true);
            } else {
                splitfile.finishDownload(true);
            }
        } else if (dlItem == null) {
            splitfile.finishDownload(true);
        }
        return success;
    }

    private static ArrayList<FecBlock> getBlocksInSegmentWithState(List<FecBlock> allBlocks, int segno, int state) {
        ArrayList<FecBlock> l = new ArrayList<FecBlock>();
        for (int x = 0; x < allBlocks.size(); ++x) {
            FecBlock b = allBlocks.get(x);
            if (b.getSegmentNo() != segno || b.getCurrentState() != state) continue;
            l.add(b);
        }
        return l;
    }

    private static void setBlocksInSegmentFinished(List<FecBlock> allBlocks, int segno) {
        for (int x = 0; x < allBlocks.size(); ++x) {
            FecBlock b = allBlocks.get(x);
            if (b.getSegmentNo() != segno || b.getCurrentState() == 3) continue;
            b.setCurrentState(3);
        }
    }

    public static FcpResultGet getFile(String key, Long size, File target, int htl, boolean doRedirect, boolean fastDownload, boolean createTempFile, FrostDownloadItem dlItem) {
        assert (htl >= 0);
        File tempFile = null;
        tempFile = createTempFile ? FileAccess.createTempFile("getFile_", ".tmp") : new File(target.getPath() + ".tmp");
        FcpResultGet results = null;
        String[] metadataLines = null;
        results = FcpRequest.getKey(key, tempFile, htl, fastDownload);
        if (results != null) {
            metadataLines = results.getMetadataAsLines();
        }
        if (results != null && (tempFile.length() > 0L || metadataLines != null)) {
            String redirectCHK;
            if (metadataLines != null && doRedirect && (redirectCHK = FcpRequest.getRedirectCHK(metadataLines, key)) != null) {
                logger.info("Redirecting to " + redirectCHK);
                results = FcpRequest.getKey(redirectCHK, tempFile, htl, fastDownload);
                if (results == null || tempFile.length() == 0L) {
                    tempFile.delete();
                    return null;
                }
            }
            boolean isSplitfile = false;
            if (metadataLines != null) {
                String[] content = metadataLines;
                String algoName = null;
                for (String element : content) {
                    if (element.startsWith("SplitFile.Size")) {
                        isSplitfile = true;
                    }
                    if (!element.startsWith("SplitFile.AlgoName")) continue;
                    algoName = element.substring(element.indexOf("=") + 1).trim();
                }
                if (isSplitfile) {
                    if (algoName != null && algoName.equals("OnionFEC_a_1_2")) {
                        FileAccess.writeFile(results.getRawMetadata(), tempFile);
                        boolean success = FcpRequest.getFECSplitFile(target, tempFile, htl, dlItem);
                        if (success) {
                            return results;
                        }
                        return null;
                    }
                    logger.severe("Old non-FEC splitfiles are not supported by Frost, try with fproxy. key=" + key);
                    tempFile.delete();
                    return null;
                }
            }
            if (size == null || size < 0L || size.longValue() == tempFile.length()) {
                boolean wasOK;
                if (target.isFile()) {
                    target.delete();
                }
                if (!(wasOK = tempFile.renameTo(target))) {
                    logger.severe("ERROR: Could not move file '" + tempFile.getPath() + "' to '" + target.getPath() + "'.\n" + "Maybe the locations are on different filesystems where a move is not allowed.\n" + "Please try change the location of 'temp.dir' in the frost.ini file," + " and copy the file to a save location by yourself.");
                }
                return results;
            }
        }
        tempFile.delete();
        return null;
    }

    private static String getRedirectCHK(String[] metadata, String key) {
        String searchedFilename = null;
        int pos1 = key.lastIndexOf("/");
        if (pos1 > -1 && (searchedFilename = key.substring(pos1 + 1).trim()).length() == 0) {
            searchedFilename = null;
        }
        if (searchedFilename == null) {
            return null;
        }
        String keywordName = "Name=";
        String keywordRedirTarget = "Redirect.Target=";
        String actualFilename = null;
        String actualCHK = null;
        String resultCHK = null;
        for (String element : metadata) {
            String line = element.trim();
            if (line.length() == 0) continue;
            if (line.equals("Document")) {
                actualFilename = null;
                actualCHK = null;
                continue;
            }
            if (line.equals("End") || line.equals("EndPart")) {
                if (actualCHK == null || actualFilename == null || !actualFilename.equals(searchedFilename)) continue;
                resultCHK = actualCHK;
                return resultCHK;
            }
            if (line.startsWith("Name=")) {
                actualFilename = line.substring("Name=".length()).trim();
                continue;
            }
            if (!line.startsWith("Redirect.Target=")) continue;
            actualCHK = line.substring("Redirect.Target=".length()).trim();
        }
        return null;
    }

    private static FcpResultGet getKey(String key, File target, int htl, boolean fastDownload) {
        boolean metadataAvailable;
        FcpConnection connection;
        if (key == null || key.length() == 0 || key.startsWith("null")) {
            return null;
        }
        FcpResultGet results = null;
        try {
            connection = FcpFactory.getFcpConnectionInstance();
        }
        catch (ConnectException e1) {
            connection = null;
        }
        if (connection != null) {
            int maxtries = 3;
            for (int tries = 0; tries < 3 || results != null; ++tries) {
                try {
                    results = connection.getKeyToFile(key, target.getPath(), htl, fastDownload);
                    break;
                }
                catch (ConnectException e) {
                    continue;
                }
                catch (DataNotFoundException ex) {
                    logger.log(Level.INFO, "FcpRequest.getKey(1): DataNotFoundException (usual if not found)", ex);
                    break;
                }
                catch (FcpToolsException e) {
                    logger.log(Level.SEVERE, "FcpRequest.getKey(1): FcpToolsException", e);
                    break;
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "FcpRequest.getKey(1): IOException", e);
                    break;
                }
            }
        }
        String printableKey = null;
        String keyPrefix = "";
        if (key.indexOf("@") > -1) {
            keyPrefix = key.substring(0, key.indexOf("@") + 1);
        }
        String keyUrl = "";
        if (key.indexOf("/") > -1) {
            keyUrl = key.substring(key.indexOf("/"));
        }
        printableKey = keyPrefix + "..." + keyUrl;
        boolean bl = metadataAvailable = results != null && results.getRawMetadata() != null && results.getRawMetadata().length > 0;
        if (results != null && (target.length() > 0L || metadataAvailable)) {
            logger.info("getKey - Success: " + printableKey);
            return results;
        }
        target.delete();
        logger.info("getKey - Failed: " + printableKey);
        return null;
    }

    private static class GetKeyThread
    extends Thread {
        FecBlock block;
        int htl;
        boolean success;
        FecSplitfile splitfile;
        FcpConnection connection = null;
        boolean aborted = false;

        public GetKeyThread(FecSplitfile sf, FecBlock b, int h) {
            this.block = b;
            this.htl = h;
            this.splitfile = sf;
        }

        public void run() {
            this.block.setCurrentState(2);
            this.success = false;
            try {
                this.connection = FcpFactory.getFcpConnectionInstance();
            }
            catch (ConnectException e1) {
                this.connection = null;
            }
            if (this.connection != null) {
                try {
                    this.success = this.connection.getKeyToBucket(this.block.getChkKey(), this.block.getRandomAccessFileBucket(false), this.htl);
                }
                catch (FcpToolsException e) {
                    if (!this.isAborted()) {
                        logger.log(Level.WARNING, "Error during request: ", e);
                    }
                    this.success = false;
                }
                catch (Throwable e) {
                    if (!this.isAborted()) {
                        logger.log(Level.WARNING, "Error during request: ", e);
                    }
                    this.success = false;
                }
            }
            if (this.success) {
                this.block.setCurrentState(3);
                this.splitfile.createRedirectFile(true);
                this.block.close();
            } else {
                this.block.setCurrentState(1);
            }
        }

        public boolean getSuccess() {
            return this.success;
        }

        public synchronized FecBlock getBlock() {
            return this.block;
        }

        public void abortTransfer() {
            this.aborted = true;
            if (this.connection != null) {
                this.connection.abortConnection();
            }
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

