/*
 * Decompiled with CFR 0.152.
 */
package frost.crypt;

import frost.Core;
import frost.crypt.MetaData;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.util.XMLTools;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SignMetaData
extends MetaData {
    private static final Logger logger = Logger.getLogger(SignMetaData.class.getName());
    String sig;

    public SignMetaData() {
        this.person = null;
        this.sig = null;
    }

    public SignMetaData(byte[] plaintext, LocalIdentity myId) {
        this.person = myId;
        this.sig = Core.getCrypto().detachedSign(plaintext, myId.getPrivateKey());
    }

    public SignMetaData(byte[] metadata) throws Throwable {
        Document d = XMLTools.parseXmlContent(metadata, false);
        Element el = d.getDocumentElement();
        if (!el.getTagName().equals("FrostMetaData")) {
            throw new Exception("This is not FrostMetaData XML file.");
        }
        try {
            this.loadXMLElement(el);
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", e);
            throw e;
        }
    }

    public SignMetaData(Element el) throws SAXException {
        try {
            this.loadXMLElement(el);
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", e);
            throw e;
        }
    }

    public Element getXMLElement(Document container) {
        Element el = super.getXMLElement(container);
        Element _sig = container.createElement("sig");
        CDATASection cdata = container.createCDATASection(this.sig);
        _sig.appendChild(cdata);
        el.appendChild(_sig);
        return el;
    }

    public void loadXMLElement(Element e) throws SAXException {
        List<Element> tags = XMLTools.getChildElementsByTagName(e, "Identity");
        if (tags.size() == 0) {
            tags = XMLTools.getChildElementsByTagName(e, "MyIdentity");
        }
        Element _person = tags.iterator().next();
        this.person = Identity.createIdentityFromXmlElement(_person);
        this.sig = XMLTools.getChildElementsCDATAValue(e, "sig");
        assert (this.person != null && this.sig != null);
    }

    public String getSig() {
        return this.sig;
    }

    public int getType() {
        return 0;
    }
}

