/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.MainFrame;
import frost.boards.AbstractNode;
import frost.boards.Board;
import frost.boards.BoardUpdateInformation;
import frost.boards.TofTree;
import frost.boards.TofTreeModel;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class BoardUpdateInformationFrame
extends JFrame
implements BoardUpdateThreadListener,
TreeSelectionListener {
    private JComboBox cbBoards;
    private JLabel lBoards;
    private JTextArea taContent;
    private JLabel lDates;
    private JComboBox cbDates;
    private static boolean isShowing = false;
    private final TofTree tofTree;
    private JCheckBox cbSyncWithBoardTree;
    private JTextArea taSummary;
    private JPanel buttonPanel;
    private JButton Bclose;
    private JTabbedPane tabbedPane;
    private final TofTreeModel tofTreeModel;

    public BoardUpdateInformationFrame(JFrame parentFrame, TofTree tofTree) {
        this.tofTree = tofTree;
        this.tofTreeModel = (TofTreeModel)tofTree.getModel();
        this.setDefaultCloseOperation(0);
        this.enableEvents(64L);
        this.initGUI();
        this.setTitle("Board update informations");
        this.setLocationRelativeTo(parentFrame);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            GridBagLayout boardUpdateInfoPanelLayout = new GridBagLayout();
            JPanel boardUpdateInfoPanel = new JPanel(boardUpdateInfoPanelLayout);
            DefaultComboBoxModel cbBoardsModel = new DefaultComboBoxModel();
            this.cbBoards = new JComboBox();
            boardUpdateInfoPanel.add((Component)this.cbBoards, new GridBagConstraints(1, 0, 1, 1, 0.4, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
            this.cbBoards.setModel(cbBoardsModel);
            this.cbBoards.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    BoardUpdateInformationFrame.this.cbBoardsActionPerformed(evt);
                }
            });
            DefaultComboBoxModel cbDatesModel = new DefaultComboBoxModel();
            this.cbDates = new JComboBox();
            boardUpdateInfoPanel.add((Component)this.cbDates, new GridBagConstraints(3, 0, 1, 1, 0.4, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.cbDates.setModel(cbDatesModel);
            this.cbDates.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    BoardUpdateInformationFrame.this.cbDatesActionPerformed(evt);
                }
            });
            this.lBoards = new JLabel();
            boardUpdateInfoPanel.add((Component)this.lBoards, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
            this.lBoards.setText("Board");
            this.lDates = new JLabel();
            boardUpdateInfoPanel.add((Component)this.lDates, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
            this.lDates.setText("Date");
            this.taContent = new JTextArea();
            boardUpdateInfoPanel.add((Component)this.taContent, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.taContent.setBorder(BorderFactory.createBevelBorder(1));
            this.taContent.setEditable(false);
            GridBagLayout summaryPanelLayout = new GridBagLayout();
            JPanel summaryPanel = new JPanel(summaryPanelLayout);
            GridBagLayout summaryPanelLayout1 = new GridBagLayout();
            summaryPanel.setLayout(summaryPanelLayout1);
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("By board", boardUpdateInfoPanel);
            this.tabbedPane.addTab("Summary", summaryPanel);
            this.taSummary = new JTextArea();
            summaryPanel.add((Component)this.taSummary, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.taSummary.setText(" ");
            this.taSummary.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, null, null, null, null), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.taSummary.setEditable(false);
            this.tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    BoardUpdateInformationFrame.this.maybeUpdateSummaryTextArea();
                }
            });
            this.getContentPane().add((Component)this.tabbedPane, "Center");
            this.buttonPanel = new JPanel();
            BorderLayout buttonPanelLayout = new BorderLayout();
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.buttonPanel.setLayout(buttonPanelLayout);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.Bclose = new JButton();
            this.buttonPanel.add((Component)this.Bclose, "East");
            this.Bclose.setText("Close");
            this.Bclose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    BoardUpdateInformationFrame.this.BcloseActionPerformed(evt);
                }
            });
            this.cbSyncWithBoardTree = new JCheckBox();
            this.buttonPanel.add((Component)this.cbSyncWithBoardTree, "West");
            this.cbSyncWithBoardTree.setText("Sync with board tree");
            this.cbSyncWithBoardTree.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    BoardUpdateInformationFrame.this.maybeSyncBoards();
                }
            });
            this.pack();
            this.setSize(400, 470);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearTaContent() {
        this.taContent.setText("No informations available");
    }

    private void cbBoardsActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        Board selectedBoard = (Board)cb.getSelectedItem();
        if (selectedBoard == null) {
            this.clearTaContent();
            return;
        }
        this.cbDates.removeAllItems();
        List<BoardUpdateInformation> l = selectedBoard.getBoardUpdateInformationList();
        for (BoardUpdateInformation bui : l) {
            this.cbDates.addItem(bui);
        }
        if (this.cbDates.getModel().getSize() > 0) {
            this.cbDates.setSelectedIndex(0);
        } else {
            this.clearTaContent();
        }
    }

    private void cbDatesActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        BoardUpdateInformation selectedItem = (BoardUpdateInformation)cb.getSelectedItem();
        if (selectedItem == null) {
            this.clearTaContent();
            return;
        }
        this.taContent.setText(selectedItem.getInfoString());
    }

    private void loadGuiData() {
        Vector<Board> items = new Vector<Board>();
        for (Board b : this.tofTreeModel.getAllBoards()) {
            if (!b.hasBoardUpdateInformations()) continue;
            items.add(b);
        }
        DefaultComboBoxModel cbBoardsModel = new DefaultComboBoxModel(items);
        this.cbBoards.setModel(cbBoardsModel);
        if (this.cbBoards.getItemCount() > 0) {
            this.cbBoards.setSelectedIndex(0);
        }
    }

    public void startDialog() {
        this.tofTree.getRunningBoardUpdateThreads().addBoardUpdateThreadListener(this);
        MainFrame.getInstance().getTofTree().addTreeSelectionListener(this);
        BoardUpdateInformationFrame.setDialogShowing(true);
        this.loadGuiData();
        this.setVisible(true);
    }

    private void closeDialog() {
        MainFrame.getInstance().getTofTree().removeTreeSelectionListener(this);
        this.tofTree.getRunningBoardUpdateThreads().removeBoardUpdateThreadListener(this);
        BoardUpdateInformationFrame.setDialogShowing(false);
        this.dispose();
    }

    private void BcloseActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.closeDialog();
        }
        super.processWindowEvent(e);
    }

    public static boolean isDialogShowing() {
        return isShowing;
    }

    public static void setDialogShowing(boolean val) {
        isShowing = val;
    }

    public void boardUpdateThreadFinished(BoardUpdateThread thread) {
    }

    public void boardUpdateThreadStarted(BoardUpdateThread thread) {
    }

    public void boardUpdateInformationChanged(final BoardUpdateThread thread, final BoardUpdateInformation bui) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BoardUpdateInformationFrame.this.updateGui(thread, bui);
            }
        });
    }

    private void updateGui(BoardUpdateThread thread, BoardUpdateInformation bui) {
        int x;
        this.maybeUpdateSummaryTextArea();
        Board selectedBoard = (Board)this.cbBoards.getSelectedItem();
        boolean contained = false;
        for (x = 0; x < this.cbBoards.getItemCount(); ++x) {
            if (this.cbBoards.getItemAt(x) != thread.getTargetBoard()) continue;
            contained = true;
            break;
        }
        if (!contained) {
            this.cbBoards.addItem(thread.getTargetBoard());
            return;
        }
        if (selectedBoard == null) {
            return;
        }
        if (selectedBoard != thread.getTargetBoard()) {
            return;
        }
        contained = false;
        for (x = 0; x < this.cbDates.getItemCount(); ++x) {
            if (this.cbDates.getItemAt(x) != bui) continue;
            contained = true;
            break;
        }
        if (!contained) {
            this.cbDates.addItem(bui);
            return;
        }
        BoardUpdateInformation selectedBui = (BoardUpdateInformation)this.cbDates.getSelectedItem();
        if (selectedBui == null) {
            return;
        }
        if (selectedBui != bui) {
            return;
        }
        this.taContent.setText(bui.getInfoString());
    }

    private void maybeUpdateSummaryTextArea() {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.taSummary.setText(BoardUpdateInformation.getSummaryInfoString(this.tofTreeModel.getAllBoards()));
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.maybeSyncBoards();
    }

    private void maybeSyncBoards() {
        if (this.cbSyncWithBoardTree.isSelected()) {
            Board selectedBoard = this.getSelectedBoardFromBoardTree();
            if (selectedBoard == null) {
                return;
            }
            if (selectedBoard == this.cbBoards.getSelectedItem()) {
                return;
            }
            this.cbBoards.setSelectedItem(selectedBoard);
        }
    }

    private Board getSelectedBoardFromBoardTree() {
        TreePath treePath = this.tofTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        AbstractNode selectedNode = (AbstractNode)treePath.getLastPathComponent();
        if (!selectedNode.isBoard()) {
            return null;
        }
        Board selectedBoard = (Board)selectedNode;
        return selectedBoard;
    }
}

