/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.Core;
import frost.boards.AbstractNode;
import frost.boards.BoardUpdateInformation;
import frost.storage.perst.messages.PerstFrostBoardObject;
import frost.util.Mixed;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Board
extends AbstractNode {
    private static Language language = Language.getInstance();
    private PerstFrostBoardObject perstFrostBoardObject = null;
    private boolean autoUpdateEnabled = true;
    private String boardDescription = null;
    private final String boardFileName;
    private Boolean hideBad = null;
    private Boolean hideCheck = null;
    private Boolean hideObserve = null;
    private Boolean storeSentMessages = null;
    private boolean isConfigured = false;
    private boolean isUpdating = false;
    private long lastUpdateStartMillis = -1L;
    private long lastBackloadUpdateFinishedMillis = -1L;
    private Integer maxMessageDisplay = null;
    private Integer maxMessageDownload = null;
    private int newMessageCount = 0;
    private int numberBlocked = 0;
    private String privateKey = null;
    private String publicKey = null;
    private Boolean showSignedOnly = null;
    private boolean spammed = false;
    private int timesUpdatedCount = 0;
    private boolean hasFlaggedMessages = false;
    private boolean hasStarredMessages = false;
    private final Hashtable<Long, BoardUpdateInformation> boardUpdateInformations = new Hashtable();
    private static final BoardUpdateInformationComparator boardUpdateInformationComparator = new BoardUpdateInformationComparator();
    private boolean dosForToday = false;
    private boolean dosForBackloadDays = false;
    private boolean dosForAllDays = false;
    private static final ImageIcon writeAccessIcon = MiscToolkit.loadImageIcon("/data/key.png");
    private static final ImageIcon writeAccessNewIcon = MiscToolkit.loadImageIcon("/data/key_add.png");
    private static final ImageIcon writeAccessSpammedIcon = MiscToolkit.loadImageIcon("/data/key_delete.png");
    private static final ImageIcon readAccessIcon = MiscToolkit.loadImageIcon("/data/lock.png");
    private static final ImageIcon readAccessNewIcon = MiscToolkit.loadImageIcon("/data/lock_add.png");
    private static final ImageIcon readAccessSpammedIcon = MiscToolkit.loadImageIcon("/data/lock_delete.png");
    private static final ImageIcon boardIcon = MiscToolkit.loadImageIcon("/data/comments.png");
    private static final ImageIcon boardNewIcon = MiscToolkit.loadImageIcon("/data/comments_add.png");
    private static final ImageIcon boardSpammedIcon = MiscToolkit.loadImageIcon("/data/comments_delete.png");

    public Board(String name, String description) {
        this(name, null, null, description);
    }

    public Board(String name, String pubKey, String privKey, String description) {
        super(name);
        this.boardDescription = description;
        this.boardFileName = Mixed.makeFilename(this.getNameLowerCase());
        this.setPublicKey(pubKey);
        this.setPrivateKey(privKey);
    }

    @Override
    public boolean containsNewMessages() {
        return this.getNewMessageCount() > 0;
    }

    public void decNewMessageCount() {
        --this.newMessageCount;
    }

    public void incTimesUpdatedCount() {
        ++this.timesUpdatedCount;
    }

    public boolean getAutoUpdateEnabled() {
        if (!this.isConfigured()) {
            return true;
        }
        return this.autoUpdateEnabled;
    }

    public int getBlockedCount() {
        return this.numberBlocked;
    }

    public String getBoardFilename() {
        return this.boardFileName;
    }

    public String getDescription() {
        return this.boardDescription;
    }

    public void setDescription(String desc) {
        this.boardDescription = desc;
    }

    public boolean getStoreSentMessages() {
        if (!this.isConfigured() || this.storeSentMessages == null) {
            return Core.frostSettings.getBoolValue("storage.storeSentMessages");
        }
        return this.storeSentMessages;
    }

    public Boolean getStoreSentMessagesObj() {
        return this.storeSentMessages;
    }

    public boolean getHideBad() {
        if (!this.isConfigured() || this.hideBad == null) {
            return Core.frostSettings.getBoolValue("hideBadMessages");
        }
        return this.hideBad;
    }

    public Boolean getHideBadObj() {
        return this.hideBad;
    }

    public boolean getHideCheck() {
        if (!this.isConfigured() || this.hideCheck == null) {
            return Core.frostSettings.getBoolValue("hideCheckMessages");
        }
        return this.hideCheck;
    }

    public Boolean getHideCheckObj() {
        return this.hideCheck;
    }

    public boolean getHideObserve() {
        if (!this.isConfigured() || this.hideObserve == null) {
            return Core.frostSettings.getBoolValue("hideObserveMessages");
        }
        return this.hideObserve;
    }

    public Boolean getHideObserveObj() {
        return this.hideObserve;
    }

    public long getLastUpdateStartMillis() {
        return this.lastUpdateStartMillis;
    }

    public long getLastBackloadUpdateFinishedMillis() {
        return this.lastBackloadUpdateFinishedMillis;
    }

    public int getMaxMessageDisplay() {
        if (!this.isConfigured() || this.maxMessageDisplay == null) {
            return Core.frostSettings.getIntValue("maxMessageDisplay");
        }
        return this.maxMessageDisplay;
    }

    public Integer getMaxMessageDisplayObj() {
        return this.maxMessageDisplay;
    }

    public int getMaxMessageDownload() {
        if (!this.isConfigured() || this.maxMessageDownload == null) {
            return Core.frostSettings.getIntValue("maxMessageDownload");
        }
        return this.maxMessageDownload;
    }

    public Integer getMaxMessageDownloadObj() {
        return this.maxMessageDownload;
    }

    public int getNewMessageCount() {
        return this.newMessageCount;
    }

    public int getTimesUpdatedCount() {
        return this.timesUpdatedCount;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public boolean getShowSignedOnly() {
        if (!this.isConfigured() || this.showSignedOnly == null) {
            return Core.frostSettings.getBoolValue("signedOnly");
        }
        return this.showSignedOnly;
    }

    public Boolean getShowSignedOnlyObj() {
        return this.showSignedOnly;
    }

    public String getStateString() {
        if (this.isReadAccessBoard()) {
            return language.getString("Board.boardState.readAccess");
        }
        if (this.isWriteAccessBoard()) {
            return language.getString("Board.boardState.writeAccess");
        }
        if (this.isPublicBoard()) {
            return language.getString("Board.boardState.publicBoard");
        }
        return language.getString("Board.boardState.invalid");
    }

    public ImageIcon getStateIcon() {
        if (this.isReadAccessBoard()) {
            if (this.isSpammed() || this.isDosForToday()) {
                return readAccessSpammedIcon;
            }
            if (this.containsNewMessages()) {
                return readAccessNewIcon;
            }
            return readAccessIcon;
        }
        if (this.isWriteAccessBoard()) {
            if (this.isSpammed() || this.isDosForToday()) {
                return writeAccessSpammedIcon;
            }
            if (this.containsNewMessages()) {
                return writeAccessNewIcon;
            }
            return writeAccessIcon;
        }
        if (this.isPublicBoard()) {
            if (this.isSpammed() || this.isDosForToday()) {
                return boardSpammedIcon;
            }
            if (this.containsNewMessages()) {
                return boardNewIcon;
            }
            return boardIcon;
        }
        return boardIcon;
    }

    public void incBlocked() {
        ++this.numberBlocked;
    }

    public void incNewMessageCount() {
        ++this.newMessageCount;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    @Override
    public boolean isBoard() {
        return true;
    }

    public boolean isPublicBoard() {
        return this.publicKey == null && this.privateKey == null;
    }

    public boolean isReadAccessBoard() {
        return this.publicKey != null && this.privateKey == null;
    }

    public boolean isWriteAccessBoard() {
        return this.publicKey != null && this.privateKey != null;
    }

    public boolean isSpammed() {
        return this.spammed;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void resetBlocked() {
        this.numberBlocked = 0;
    }

    public void setAutoUpdateEnabled(boolean val) {
        this.autoUpdateEnabled = val;
    }

    public void setConfigured(boolean val) {
        this.isConfigured = val;
    }

    public void setStoreSentMessages(Boolean val) {
        this.storeSentMessages = val;
    }

    public void setHideBad(Boolean val) {
        this.hideBad = val;
    }

    public void setHideCheck(Boolean val) {
        this.hideCheck = val;
    }

    public void setHideObserve(Boolean val) {
        this.hideObserve = val;
    }

    public void setLastUpdateStartMillis(long millis) {
        this.lastUpdateStartMillis = millis;
    }

    public void setLastBackloadUpdateFinishedMillis(long millis) {
        this.lastBackloadUpdateFinishedMillis = millis;
    }

    public void setMaxMessageDays(Integer val) {
        this.maxMessageDisplay = val;
    }

    public void setMaxMessageDownload(Integer val) {
        this.maxMessageDownload = val;
    }

    public void setNewMessageCount(int val) {
        this.newMessageCount = val;
    }

    public void setPrivateKey(String val) {
        if (val != null && (val = val.trim()).length() == 0) {
            val = null;
        }
        this.privateKey = val;
    }

    public void setPublicKey(String val) {
        if (val != null && (val = val.trim()).length() == 0) {
            val = null;
        }
        this.publicKey = val;
    }

    public void setShowSignedOnly(Boolean val) {
        this.showSignedOnly = val;
    }

    public void setSpammed(boolean val) {
        this.spammed = val;
    }

    public void setUpdating(boolean val) {
        this.isUpdating = val;
    }

    public boolean isManualUpdateAllowed() {
        return this.isBoard() && !this.isSpammed();
    }

    public boolean isAutomaticUpdateAllowed() {
        return this.isBoard() && !this.isSpammed() && !this.isUpdating();
    }

    public void newMessageReceived() {
    }

    public boolean hasFlaggedMessages() {
        return this.hasFlaggedMessages;
    }

    public void hasFlaggedMessages(boolean newHasFlaggedMessages) {
        this.hasFlaggedMessages = newHasFlaggedMessages;
    }

    public boolean hasStarredMessages() {
        return this.hasStarredMessages;
    }

    public void hasStarredMessages(boolean newHasStarredMessages) {
        this.hasStarredMessages = newHasStarredMessages;
    }

    public PerstFrostBoardObject getPerstFrostBoardObject() {
        return this.perstFrostBoardObject;
    }

    public void setPerstFrostBoardObject(PerstFrostBoardObject perstFrostBoardObject) {
        this.perstFrostBoardObject = perstFrostBoardObject;
    }

    public BoardUpdateInformation getBoardUpdateInformationForDay(long dateMillis) {
        return this.boardUpdateInformations.get(dateMillis);
    }

    public BoardUpdateInformation getOrCreateBoardUpdateInformationForDay(String dateString, long dateMillis) {
        BoardUpdateInformation bui = this.getBoardUpdateInformationForDay(dateMillis);
        if (bui == null) {
            bui = new BoardUpdateInformation(this, dateString, dateMillis);
            this.boardUpdateInformations.put(dateMillis, bui);
        }
        return bui;
    }

    public List<BoardUpdateInformation> getBoardUpdateInformationList() {
        ArrayList<BoardUpdateInformation> buiList = new ArrayList<BoardUpdateInformation>(this.boardUpdateInformations.size());
        buiList.addAll(this.boardUpdateInformations.values());
        Collections.sort(buiList, boardUpdateInformationComparator);
        return buiList;
    }

    public boolean hasBoardUpdateInformations() {
        return this.boardUpdateInformations.size() > 0;
    }

    public boolean isDosForToday() {
        return this.dosForToday;
    }

    private void setDosForToday(boolean dosForToday) {
        this.dosForToday = dosForToday;
    }

    public boolean isDosForBackloadDays() {
        return this.dosForBackloadDays;
    }

    private void setDosForBackloadDays(boolean dosForBackloadDays) {
        this.dosForBackloadDays = dosForBackloadDays;
    }

    public boolean isDosForAllDays() {
        return this.dosForAllDays;
    }

    private void setDosForAllDays(boolean dosForAllDays) {
        this.dosForAllDays = dosForAllDays;
    }

    public void updateDosStatus(boolean stopBoardUpdatesWhenDOSed, long minDateTime, long todayDateTime) {
        if (!stopBoardUpdatesWhenDOSed) {
            this.setDosForToday(false);
            this.setDosForBackloadDays(false);
            this.setDosForAllDays(false);
            return;
        }
        List<BoardUpdateInformation> buiList = this.getBoardUpdateInformationList();
        boolean newDosForToday = false;
        boolean newDosForBackloadDays = false;
        boolean newDosForAllDays = false;
        int dosBackloadDayCount = 0;
        for (BoardUpdateInformation bui : buiList) {
            long buiDateMillis = bui.getDateMillis();
            if (buiDateMillis < minDateTime) continue;
            if (buiDateMillis == todayDateTime) {
                if (!bui.isBoardUpdateAllowed()) {
                    newDosForToday = true;
                }
            } else if (!bui.isBoardUpdateAllowed()) {
                ++dosBackloadDayCount;
            }
            if (dosBackloadDayCount == buiList.size() - 1) {
                newDosForAllDays = true;
            } else {
                newDosForBackloadDays = true;
            }
            this.setDosForToday(newDosForToday);
            this.setDosForBackloadDays(newDosForBackloadDays);
            this.setDosForAllDays(newDosForAllDays);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BoardUpdateInformationComparator
    implements Comparator<BoardUpdateInformation> {
        private BoardUpdateInformationComparator() {
        }

        @Override
        public int compare(BoardUpdateInformation o1, BoardUpdateInformation o2) {
            return Mixed.compareLong(o2.getDateMillis(), o1.getDateMillis());
        }
    }
}

