/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.Frost;
import frost.FrostSecurityManager;
import frost.MainFrame;
import frost.SettingsClass;
import frost.Startup;
import frost.boards.BoardsManager;
import frost.crypt.FrostCrypt;
import frost.events.FrostEvent;
import frost.events.FrostEventDispatcher;
import frost.events.StorageErrorEvent;
import frost.ext.JSysTrayIcon;
import frost.fcp.FcpHandler;
import frost.fileTransfer.FileSharingManager;
import frost.fileTransfer.FileTransferManager;
import frost.gui.FirstStartupDialog;
import frost.gui.FreenetVersionDialog;
import frost.gui.Splashscreen;
import frost.gui.help.CheckHtmlIntegrity;
import frost.identities.FrostIdentities;
import frost.identities.IdentityAutoBackupTask;
import frost.messages.UnsentMessagesManager;
import frost.storage.StorageManager;
import frost.storage.perst.AbstractFrostStorage;
import frost.storage.perst.FrostFilesStorage;
import frost.storage.perst.IndexSlotsStorage;
import frost.storage.perst.SharedFilesCHKKeyStorage;
import frost.storage.perst.filelist.FileListStorage;
import frost.storage.perst.identities.IdentitiesStorage;
import frost.storage.perst.messagearchive.ArchiveMessageStorage;
import frost.storage.perst.messages.MessageContentStorage;
import frost.storage.perst.messages.MessageStorage;
import frost.threads.FileAttachmentUploadThread;
import frost.util.CleanUp;
import frost.util.Logging;
import frost.util.Mixed;
import frost.util.gui.JDialogWithDetails;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class Core
implements FrostEventDispatcher {
    private static final Logger logger = Logger.getLogger(Core.class.getName());
    public static final SettingsClass frostSettings = new SettingsClass();
    private static Core instance = null;
    private static final FrostCrypt crypto = new FrostCrypt();
    private static boolean isHelpHtmlSecure = false;
    private final EventDispatcher dispatcher = new EventDispatcher();
    private Language language = null;
    private static boolean freenetIsOnline = false;
    private final Timer timer = new Timer(true);
    private MainFrame mainFrame;
    private BoardsManager boardsManager;
    private FileTransferManager fileTransferManager;
    private static FrostIdentities identities;

    private Core() {
        this.initializeLanguage();
    }

    private boolean initializeConnectivity() {
        int freenetVersion = frostSettings.getIntValue("freenetVersion");
        if (freenetVersion <= 0) {
            FreenetVersionDialog dlg = new FreenetVersionDialog();
            dlg.setVisible(true);
            if (dlg.isChoosedExit()) {
                return false;
            }
            if (dlg.isChoosedFreenet05()) {
                frostSettings.setValue("freenetVersion", "5");
            } else if (dlg.isChoosedFreenet07()) {
                frostSettings.setValue("freenetVersion", "7");
            } else {
                return false;
            }
            freenetVersion = frostSettings.getIntValue("freenetVersion");
        }
        if (freenetVersion != 5 && freenetVersion != 7) {
            MiscToolkit.showMessage(this.language.getString("Core.init.UnsupportedFreenetVersionBody") + ": " + freenetVersion, 0, this.language.getString("Core.init.UnsupportedFreenetVersionTitle"));
            return false;
        }
        String nodesUnparsed = frostSettings.getValue("availableNodes");
        ArrayList<String> nodes = new ArrayList<String>();
        if (nodesUnparsed == null) {
            String converted = new String(frostSettings.getValue("nodeAddress") + ":" + frostSettings.getValue("nodePort"));
            nodes.add(converted.trim());
            frostSettings.setValue("availableNodes", converted.trim());
        } else {
            String[] _nodes;
            for (String element : _nodes = nodesUnparsed.split(",")) {
                nodes.add(element);
            }
        }
        if (nodes.size() == 0) {
            MiscToolkit.showMessage("Not a single Freenet node configured. You need at least one.", 0, "ERROR: No Freenet nodes are configured.");
            return false;
        }
        if (freenetVersion == 7 && nodes.size() > 1 && frostSettings.getBoolValue("fcp2.usePersistence")) {
            MiscToolkit.showMessage("Persistence is not possible with more than 1 node. Persistence disabled.", 0, "Warning: Persistence is not possible");
            frostSettings.setValue("fcp2.usePersistence", false);
        }
        try {
            FcpHandler.initializeFcp(nodes, freenetVersion);
        }
        catch (UnsupportedOperationException ex) {
            MiscToolkit.showMessage(ex.getMessage(), 0, this.language.getString("Core.init.UnsupportedFreenetVersionTitle"));
            return false;
        }
        System.setSecurityManager(new FrostSecurityManager());
        Core.setFreenetOnline(false);
        if (Frost.isOfflineMode()) {
            return true;
        }
        boolean runningOnTestnet = false;
        try {
            List<String> nodeInfo = FcpHandler.inst().getNodeInfo();
            if (nodeInfo != null) {
                Core.setFreenetOnline(true);
                if (FcpHandler.isFreenet07()) {
                    for (String val : nodeInfo) {
                        if (!val.startsWith("Testnet") || val.indexOf("true") <= 0) continue;
                        runningOnTestnet = true;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in initializeConnectivity", e);
        }
        if (runningOnTestnet) {
            MiscToolkit.showMessage(this.language.getString("Core.init.TestnetWarningBody"), 2, this.language.getString("Core.init.TestnetWarningTitle"));
        }
        if (!Core.isFreenetOnline()) {
            MiscToolkit.showMessage(this.language.getString("Core.init.NodeNotRunningBody"), 2, this.language.getString("Core.init.NodeNotRunningTitle"));
        } else {
            FcpHandler.inst().goneOnline();
        }
        return true;
    }

    public static void setFreenetOnline(boolean v) {
        freenetIsOnline = v;
    }

    public static boolean isFreenetOnline() {
        return freenetIsOnline;
    }

    public static FrostCrypt getCrypto() {
        return crypto;
    }

    public static void schedule(TimerTask task, long delay) {
        Core.getInstance().timer.schedule(task, delay);
    }

    public static void schedule(TimerTask task, long delay, long period) {
        Core.getInstance().timer.schedule(task, delay, period);
    }

    public static Core getInstance() {
        if (instance == null) {
            instance = new Core();
        }
        return instance;
    }

    private void showFirstStartupDialog() {
        FirstStartupDialog startdlg = new FirstStartupDialog();
        boolean exitChoosed = startdlg.startDialog();
        if (exitChoosed) {
            System.exit(1);
        }
        frostSettings.setValue("migrate.version", 2);
        frostSettings.setValue("freenetVersion", startdlg.getFreenetVersion());
        if (startdlg.getOwnHostAndPort() != null) {
            frostSettings.setValue("availableNodes", startdlg.getOwnHostAndPort());
        } else if (startdlg.getFreenetVersion() == 5) {
            frostSettings.setValue("availableNodes", "127.0.0.1:8481");
        } else {
            frostSettings.setValue("availableNodes", "127.0.0.1:9481");
        }
    }

    private long compactStorage(Splashscreen splashscreen, AbstractFrostStorage storage) throws Exception {
        splashscreen.setText("Compacting storage file '" + storage.getStorageFilename() + "'...");
        return storage.compactStorage();
    }

    public void initialize() throws Exception {
        Splashscreen splashscreen = new Splashscreen(frostSettings.getBoolValue("disableSplashScreen"));
        splashscreen.setVisible(true);
        splashscreen.setText(this.language.getString("Splashscreen.message.1"));
        splashscreen.setProgress(20);
        new Logging(frostSettings);
        StringBuilder sb = new StringBuilder();
        sb.append("***** Starting Frost " + this.getClass().getPackage().getSpecificationVersion() + " *****\n");
        for (String s : Frost.getEnvironmentInformation()) {
            sb.append(s).append("\n");
        }
        logger.severe(sb.toString());
        sb = null;
        Startup.startupCheck(frostSettings);
        if (frostSettings.getIntValue("freenetVersion") == 0) {
            this.showFirstStartupDialog();
        }
        if (frostSettings.getIntValue("migrate.version") < 2) {
            String errText = "Error: You must update this Frost version from version 11-Dec-2007 !!!";
            logger.log(Level.SEVERE, "Error: You must update this Frost version from version 11-Dec-2007 !!!");
            System.out.println("Error: You must update this Frost version from version 11-Dec-2007 !!!");
            System.exit(8);
        }
        boolean compactTables = frostSettings.getBoolValue("perst.compactStorages");
        try {
            if (compactTables) {
                long savedBytes = 0L;
                savedBytes += this.compactStorage(splashscreen, IndexSlotsStorage.inst());
                savedBytes += this.compactStorage(splashscreen, FrostFilesStorage.inst());
                savedBytes += this.compactStorage(splashscreen, IdentitiesStorage.inst());
                savedBytes += this.compactStorage(splashscreen, SharedFilesCHKKeyStorage.inst());
                savedBytes += this.compactStorage(splashscreen, MessageStorage.inst());
                savedBytes += this.compactStorage(splashscreen, MessageContentStorage.inst());
                savedBytes += this.compactStorage(splashscreen, FileListStorage.inst());
                NumberFormat nf = NumberFormat.getInstance();
                logger.warning("Finished compact of storages, released " + nf.format(savedBytes += this.compactStorage(splashscreen, ArchiveMessageStorage.inst())) + " bytes.");
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error compacting perst storages", ex);
            ex.printStackTrace();
            MiscToolkit.showMessage("Error compacting perst storages, compact did not complete: " + ex.getMessage(), 0, "Error compacting perst storages");
            throw ex;
        }
        frostSettings.setValue("perst.compactStorages", false);
        IndexSlotsStorage.inst().initStorage();
        SharedFilesCHKKeyStorage.inst().initStorage();
        FrostFilesStorage.inst().initStorage();
        MessageStorage.inst().initStorage();
        MessageContentStorage.inst().initStorage();
        ArchiveMessageStorage.inst().initStorage();
        IdentitiesStorage.inst().initStorage();
        FileListStorage.inst().initStorage();
        splashscreen.setText(this.language.getString("Splashscreen.message.2"));
        splashscreen.setProgress(40);
        CheckHtmlIntegrity chi = new CheckHtmlIntegrity();
        isHelpHtmlSecure = chi.scanZipFile("help/help.zip");
        chi = null;
        splashscreen.setText(this.language.getString("Splashscreen.message.3"));
        splashscreen.setProgress(60);
        if (!this.initializeConnectivity()) {
            System.exit(1);
        }
        Core.getIdentities().initialize(Core.isFreenetOnline());
        String title = FcpHandler.isFreenet05() ? "Frost@Freenet 0.5" : (FcpHandler.isFreenet07() ? "Frost@Freenet 0.7" : "Frost");
        if (!Core.isFreenetOnline()) {
            title = title + " (offline mode)";
        }
        this.mainFrame = new MainFrame(frostSettings, title);
        this.getBoardsManager().initialize();
        this.getFileTransferManager().initialize();
        UnsentMessagesManager.initialize();
        splashscreen.setText(this.language.getString("Splashscreen.message.4"));
        splashscreen.setProgress(70);
        if (frostSettings.getBoolValue("showSystrayIcon")) {
            try {
                JSysTrayIcon.createInstance(0, title, title);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Could not create systray icon.", t);
            }
        }
        this.mainFrame.initialize();
        CleanUp.runExpirationTasks(splashscreen, MainFrame.getInstance().getTofTreeModel().getAllBoards());
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                Core.this.mainFrame.showStartupMessages();
            }
        });
        this.mainFrame.postInitialize();
        splashscreen.setText(this.language.getString("Splashscreen.message.5"));
        splashscreen.setProgress(80);
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                Core.this.mainFrame.setVisible(true);
            }
        });
        splashscreen.closeMe();
        this.initializeTasks(this.mainFrame);
    }

    public FileTransferManager getFileTransferManager() {
        if (this.fileTransferManager == null) {
            this.fileTransferManager = FileTransferManager.inst();
        }
        return this.fileTransferManager;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    private BoardsManager getBoardsManager() {
        if (this.boardsManager == null) {
            this.boardsManager = new BoardsManager(frostSettings);
            this.boardsManager.setMainFrame(this.mainFrame);
        }
        return this.boardsManager;
    }

    private void initializeTasks(MainFrame mainframe) {
        TimerTask cleaner = new TimerTask(){

            public void run() {
                logger.info("freeing memory");
                System.gc();
            }
        };
        long gcMinutes = 10L;
        this.timer.schedule(cleaner, 600000L, 600000L);
        cleaner = null;
        StorageManager saver = new StorageManager(frostSettings, this);
        saver.addAutoSavable(this.getBoardsManager().getTofTree());
        saver.addAutoSavable(this.getFileTransferManager());
        saver.addAutoSavable(new IdentityAutoBackupTask());
        saver.addExitSavable(new IdentityAutoBackupTask());
        saver.addExitSavable(this.getBoardsManager().getTofTree());
        saver.addExitSavable(this.getFileTransferManager());
        saver.addExitSavable(frostSettings);
        saver.addExitSavable(IndexSlotsStorage.inst());
        saver.addExitSavable(SharedFilesCHKKeyStorage.inst());
        saver.addExitSavable(FrostFilesStorage.inst());
        saver.addExitSavable(MessageStorage.inst());
        saver.addExitSavable(MessageContentStorage.inst());
        saver.addExitSavable(ArchiveMessageStorage.inst());
        saver.addExitSavable(IdentitiesStorage.inst());
        saver.addExitSavable(FileListStorage.inst());
        mainframe.startTickerThread();
        FileAttachmentUploadThread.getInstance().start();
        this.getFileTransferManager().startTickers();
        if (Core.isFreenetOnline() && !frostSettings.getBoolValue("disableFilesharing")) {
            Thread t = new Thread(){

                public void run() {
                    Mixed.wait(10000);
                    FileSharingManager.startFileSharing();
                }
            };
            t.start();
        }
    }

    public static FrostIdentities getIdentities() {
        if (identities == null) {
            identities = new FrostIdentities();
        }
        return identities;
    }

    private void initializeLanguage() {
        if (Frost.getCmdLineLocaleFileName() != null) {
            File f = new File(Frost.getCmdLineLocaleFileName());
            Language.initializeWithFile(f);
        } else if (Frost.getCmdLineLocaleName() != null) {
            Language.initializeWithName(Frost.getCmdLineLocaleName());
        } else {
            String lang = frostSettings.getValue("locale");
            String langIsExternal = frostSettings.getValue("localeExternal");
            if (lang == null || lang.length() == 0 || lang.equals("default")) {
                frostSettings.setValue("locale", "default");
                Language.initializeWithName(null);
            } else {
                boolean isExternal = langIsExternal != null && langIsExternal.length() != 0 && langIsExternal.equals("true");
                Language.initializeWithName(lang, isExternal);
            }
        }
        this.language = Language.getInstance();
    }

    public void dispatchEvent(FrostEvent frostEvent) {
        this.dispatcher.dispatchEvent(frostEvent);
    }

    public static boolean isHelpHtmlSecure() {
        return isHelpHtmlSecure;
    }

    private class EventDispatcher {
        private EventDispatcher() {
        }

        public void dispatchEvent(FrostEvent frostEvent) {
            switch (frostEvent.getId()) {
                case 0: {
                    this.dispatchStorageErrorEvent((StorageErrorEvent)frostEvent);
                    break;
                }
                default: {
                    logger.severe("Unknown FrostEvent received. Id: '" + frostEvent.getId() + "'");
                }
            }
        }

        public void dispatchStorageErrorEvent(StorageErrorEvent errorEvent) {
            StringWriter stringWriter = new StringWriter();
            errorEvent.getException().printStackTrace(new PrintWriter(stringWriter));
            if (Core.this.mainFrame != null) {
                JDialogWithDetails.showErrorDialog(Core.this.mainFrame, Core.this.language.getString("Saver.AutoTask.title"), errorEvent.getMessage(), stringWriter.toString());
            }
            System.exit(3);
        }
    }
}

