/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.garret.perst.IPersistent;
import org.garret.perst.IterableIterator;
import org.garret.perst.MultidimensionalComparator;
import org.garret.perst.MultidimensionalIndex;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentCollection;
import org.garret.perst.PersistentIterator;
import org.garret.perst.Storage;
import org.garret.perst.impl.ReflectionMultidimensionalComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KDTree<T extends IPersistent>
extends PersistentCollection<T>
implements MultidimensionalIndex<T> {
    KDTreeNode root;
    int nMembers;
    MultidimensionalComparator<T> comparator;
    static final int OK = 0;
    static final int NOT_FOUND = 1;
    static final int TRUNCATE = 2;

    private KDTree() {
    }

    KDTree(Storage storage, MultidimensionalComparator<T> comparator) {
        super(storage);
        this.comparator = comparator;
    }

    KDTree(Storage storage, Class cls, String[] fieldNames) {
        super(storage);
        this.comparator = new ReflectionMultidimensionalComparator(storage, cls, fieldNames);
    }

    @Override
    public MultidimensionalComparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public boolean add(T obj) {
        this.modify();
        if (this.root == null) {
            this.root = new KDTreeNode<T>(obj);
        } else {
            this.root.insert(obj, this.comparator, 0);
        }
        ++this.nMembers;
        return true;
    }

    @Override
    public boolean remove(IPersistent obj) {
        if (this.root == null) {
            return false;
        }
        int result = this.root.remove(obj, this.comparator, 0);
        if (result == 1) {
            return false;
        }
        this.modify();
        if (result == 2) {
            this.root = null;
        }
        --this.nMembers;
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(null, null);
    }

    @Override
    public IterableIterator<T> iterator(T pattern) {
        return this.iterator(pattern, pattern);
    }

    @Override
    public IterableIterator<T> iterator(T low, T high) {
        return new KDTreeIterator(this, low, high);
    }

    @Override
    public ArrayList<T> queryByExample(T pattern) {
        return this.queryByExample(pattern, pattern);
    }

    @Override
    public ArrayList<T> queryByExample(T low, T high) {
        IterableIterator<T> i = this.iterator(low, high);
        ArrayList list = new ArrayList();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    @Override
    public Object[] toArray() {
        return this.queryByExample(null, null).toArray();
    }

    @Override
    public <E> E[] toArray(E[] arr) {
        return this.queryByExample(null, null).toArray(arr);
    }

    @Override
    public int size() {
        return this.nMembers;
    }

    @Override
    public void clear() {
        if (this.root != null) {
            this.root.deallocate();
            this.modify();
            this.root = null;
            this.nMembers = 0;
        }
    }

    @Override
    public boolean contains(T member) {
        IterableIterator<T> i = this.iterator(member);
        while (i.hasNext()) {
            if (i.next() != member) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deallocate() {
        if (this.root != null) {
            this.root.deallocate();
        }
        super.deallocate();
    }

    int compareAllComponents(T pattern, T obj) {
        int n = this.comparator.getNumberOfDimensions();
        int result = 0;
        for (int i = 0; i < n; ++i) {
            int diff = this.comparator.compare(pattern, obj, i);
            if (diff == 2) {
                return diff;
            }
            if (diff == -1) {
                if (result == 1) {
                    return 3;
                }
                result = -1;
                continue;
            }
            if (diff != 1) continue;
            if (result == -1) {
                return 3;
            }
            result = 1;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KDTreeIterator
    extends IterableIterator<T>
    implements PersistentIterator {
        Stack<KDTreeNode<T>> stack;
        int nDims;
        T high;
        T low;
        KDTreeNode<T> curr;
        KDTreeNode<T> next;
        int currLevel;
        final /* synthetic */ KDTree this$0;

        KDTreeIterator(T low, T high) {
            this.this$0 = var1_1;
            this.low = low;
            this.high = high;
            this.nDims = var1_1.comparator.getNumberOfDimensions();
            this.stack = new Stack();
            this.getMin(var1_1.root);
        }

        private boolean getMin(KDTreeNode<T> node) {
            if (node != null) {
                while (true) {
                    int diff;
                    node.load();
                    this.stack.push(node);
                    int n = diff = this.low == null ? -2 : this.this$0.comparator.compare(this.low, node.obj, (this.stack.size() - 1) % this.nDims);
                    if (diff == 1 || node.left == null) break;
                    node = node.left;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (!this.stack.empty()) {
                int result;
                KDTreeNode node = this.stack.pop();
                if (node == null) continue;
                if (!(node.deleted || this.low != null && (result = this.this$0.compareAllComponents(this.low, node.obj)) != -1 && result != 0 || this.high != null && (result = this.this$0.compareAllComponents(this.high, node.obj)) != 1 && result != 0)) {
                    this.next = node;
                    this.currLevel = this.stack.size();
                }
                if (node.right != null && (this.high == null || this.this$0.comparator.compare(this.high, node.obj, this.stack.size() % this.nDims) != -1)) {
                    this.stack.push(null);
                    if (!this.getMin(node.right)) {
                        this.stack.pop();
                    }
                }
                if (this.next == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = null;
            return this.curr.obj;
        }

        @Override
        public int nextOid() {
            return this.next().getOid();
        }

        @Override
        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            this.curr.modify();
            this.curr.obj = (IPersistent)this.this$0.comparator.cloneField(this.curr.obj, this.currLevel % this.nDims);
            this.curr.deleted = true;
            this.curr = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KDTreeNode<T extends IPersistent>
    extends Persistent {
        KDTreeNode left;
        KDTreeNode right;
        T obj;
        boolean deleted;

        KDTreeNode(T obj) {
            this.obj = obj;
        }

        private KDTreeNode() {
        }

        @Override
        public boolean recursiveLoading() {
            return false;
        }

        void insert(T ins, MultidimensionalComparator<T> comparator, int level) {
            this.load();
            int diff = comparator.compare(ins, this.obj, level % comparator.getNumberOfDimensions());
            if (diff == 0 && this.deleted) {
                this.obj.deallocate();
                this.modify();
                this.obj = ins;
                this.deleted = false;
            } else if (diff != 1) {
                if (this.left == null) {
                    this.modify();
                    this.left = new KDTreeNode<T>(ins);
                } else {
                    this.left.insert(ins, comparator, level + 1);
                }
            } else if (this.right == null) {
                this.modify();
                this.right = new KDTreeNode<T>(ins);
            } else {
                this.right.insert(ins, comparator, level + 1);
            }
        }

        int remove(T rem, MultidimensionalComparator<T> comparator, int level) {
            int result;
            this.load();
            if (this.obj == rem) {
                if (this.left == null && this.right == null) {
                    this.deallocate();
                    return 2;
                }
                this.modify();
                this.obj = (IPersistent)comparator.cloneField(this.obj, level % comparator.getNumberOfDimensions());
                this.deleted = true;
                return 0;
            }
            int diff = comparator.compare(rem, this.obj, level % comparator.getNumberOfDimensions());
            if (diff != 1 && this.left != null) {
                result = this.left.remove(rem, comparator, level + 1);
                if (result == 2) {
                    this.modify();
                    this.left = null;
                    return 0;
                }
                if (result == 0) {
                    return 0;
                }
            }
            if (diff != -1 && this.right != null) {
                result = this.right.remove(rem, comparator, level + 1);
                if (result == 2) {
                    this.modify();
                    this.right = null;
                    return 0;
                }
                if (result == 0) {
                    return 0;
                }
            }
            return 1;
        }

        @Override
        public void deallocate() {
            this.load();
            if (this.deleted) {
                this.obj.deallocate();
            }
            if (this.left != null) {
                this.left.deallocate();
            }
            if (this.right != null) {
                this.right.deallocate();
            }
            super.deallocate();
        }
    }
}

