/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.garret.perst.Assert;
import org.garret.perst.FieldIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.IterableIterator;
import org.garret.perst.Key;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreePage;
import org.garret.perst.impl.ByteBuffer;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.StorageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BtreeMultiFieldIndex<T extends IPersistent>
extends Btree<T>
implements FieldIndex<T> {
    String className;
    String[] fieldName;
    int[] types;
    transient Class cls;
    transient Field[] fld;

    BtreeMultiFieldIndex() {
    }

    BtreeMultiFieldIndex(Class cls, String[] fieldName, boolean unique) {
        this.cls = cls;
        this.unique = unique;
        this.fieldName = fieldName;
        this.className = ClassDescriptor.getClassName(cls);
        this.locateFields();
        this.type = 21;
        this.types = new int[fieldName.length];
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = BtreeMultiFieldIndex.checkType(this.fld[i].getType());
        }
    }

    private final void locateFields() {
        this.fld = new Field[this.fieldName.length];
        for (int i = 0; i < this.fieldName.length; ++i) {
            this.fld[i] = ClassDescriptor.locateField(this.cls, this.fieldName[i]);
            if (this.fld[i] != null) continue;
            throw new StorageError(20, this.className + "." + this.fieldName[i]);
        }
    }

    @Override
    public Class getIndexedClass() {
        return this.cls;
    }

    @Override
    public Field[] getKeyFields() {
        return this.fld;
    }

    @Override
    public void onLoad() {
        this.cls = ClassDescriptor.loadClass(this.getStorage(), this.className);
        this.locateFields();
    }

    @Override
    int compareByteArrays(byte[] key, byte[] item, int offs, int lengtn) {
        int o1 = 0;
        int o2 = offs;
        byte[] a1 = key;
        byte[] a2 = item;
        for (int i = 0; i < this.fld.length && o1 < key.length; ++i) {
            int diff = 0;
            switch (this.types[i]) {
                case 0: 
                case 1: {
                    diff = a1[o1++] - a2[o2++];
                    break;
                }
                case 3: {
                    diff = Bytes.unpack2(a1, o1) - Bytes.unpack2(a2, o2);
                    o1 += 2;
                    o2 += 2;
                    break;
                }
                case 2: {
                    diff = (char)Bytes.unpack2(a1, o1) - (char)Bytes.unpack2(a2, o2);
                    o1 += 2;
                    o2 += 2;
                    break;
                }
                case 4: 
                case 10: 
                case 14: {
                    int i1 = Bytes.unpack4(a1, o1);
                    int i2 = Bytes.unpack4(a2, o2);
                    diff = i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
                    o1 += 4;
                    o2 += 4;
                    break;
                }
                case 5: 
                case 9: {
                    long l1 = Bytes.unpack8(a1, o1);
                    long l2 = Bytes.unpack8(a2, o2);
                    diff = l1 < l2 ? -1 : (l1 == l2 ? 0 : 1);
                    o1 += 8;
                    o2 += 8;
                    break;
                }
                case 6: {
                    float f1 = Float.intBitsToFloat(Bytes.unpack4(a1, o1));
                    float f2 = Float.intBitsToFloat(Bytes.unpack4(a2, o2));
                    diff = f1 < f2 ? -1 : (f1 == f2 ? 0 : 1);
                    o1 += 4;
                    o2 += 4;
                    break;
                }
                case 7: {
                    double d1 = Double.longBitsToDouble(Bytes.unpack8(a1, o1));
                    double d2 = Double.longBitsToDouble(Bytes.unpack8(a2, o2));
                    diff = d1 < d2 ? -1 : (d1 == d2 ? 0 : 1);
                    o1 += 8;
                    o2 += 8;
                    break;
                }
                case 8: {
                    int len;
                    int len1 = Bytes.unpack4(a1, o1);
                    int len2 = Bytes.unpack4(a2, o2);
                    o1 += 4;
                    o2 += 4;
                    int n = len = len1 < len2 ? len1 : len2;
                    while (--len >= 0) {
                        diff = (char)Bytes.unpack2(a1, o1) - (char)Bytes.unpack2(a2, o2);
                        if (diff != 0) {
                            return diff;
                        }
                        o1 += 2;
                        o2 += 2;
                    }
                    diff = len1 - len2;
                    break;
                }
                case 21: {
                    int len;
                    int len1 = Bytes.unpack4(a1, o1);
                    int len2 = Bytes.unpack4(a2, o2);
                    o1 += 4;
                    o2 += 4;
                    int n = len = len1 < len2 ? len1 : len2;
                    while (--len >= 0) {
                        if ((diff = a1[o1++] - a2[o2++]) == 0) continue;
                        return diff;
                    }
                    diff = len1 - len2;
                    break;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    String convertString(Object s) {
        return (String)s;
    }

    @Override
    Object unpackByteArrayKey(Page pg, int pos) {
        int offs = 4 + BtreePage.getKeyStrOffs(pg, pos);
        byte[] data = pg.data;
        Object[] values = new Object[this.fld.length];
        for (int i = 0; i < this.fld.length; ++i) {
            Object v = null;
            switch (this.types[i]) {
                case 0: {
                    v = data[offs++] != 0;
                    break;
                }
                case 1: {
                    v = new Byte(data[offs++]);
                    break;
                }
                case 3: {
                    v = new Short(Bytes.unpack2(data, offs));
                    offs += 2;
                    break;
                }
                case 2: {
                    v = new Character((char)Bytes.unpack2(data, offs));
                    offs += 2;
                    break;
                }
                case 4: {
                    v = new Integer(Bytes.unpack4(data, offs));
                    offs += 4;
                    break;
                }
                case 10: {
                    int oid = Bytes.unpack4(data, offs);
                    v = oid == 0 ? null : ((StorageImpl)this.getStorage()).lookupObject(oid, null);
                    offs += 4;
                    break;
                }
                case 5: {
                    v = new Long(Bytes.unpack8(data, offs));
                    offs += 8;
                    break;
                }
                case 14: {
                    v = this.fld[i].getType().getEnumConstants()[Bytes.unpack4(data, offs)];
                    offs += 4;
                    break;
                }
                case 9: {
                    long msec = Bytes.unpack8(data, offs);
                    v = msec == -1L ? null : new Date(msec);
                    offs += 8;
                    break;
                }
                case 6: {
                    v = new Float(Float.intBitsToFloat(Bytes.unpack4(data, offs)));
                    offs += 4;
                    break;
                }
                case 7: {
                    v = new Double(Double.longBitsToDouble(Bytes.unpack8(data, offs)));
                    offs += 8;
                    break;
                }
                case 8: {
                    int len = Bytes.unpack4(data, offs);
                    offs += 4;
                    char[] sval = new char[len];
                    for (int j = 0; j < len; ++j) {
                        sval[j] = (char)Bytes.unpack2(data, offs);
                        offs += 2;
                    }
                    v = new String(sval);
                    break;
                }
                case 21: {
                    int len = Bytes.unpack4(data, offs);
                    byte[] bval = new byte[len];
                    System.arraycopy(data, offs += 4, bval, 0, len);
                    offs += len;
                    break;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
            values[i] = v;
        }
        return values;
    }

    private Key extractKey(IPersistent obj) {
        try {
            ByteBuffer buf = new ByteBuffer();
            int dst = 0;
            block17: for (int i = 0; i < this.fld.length; ++i) {
                Field f = this.fld[i];
                switch (this.types[i]) {
                    case 0: {
                        buf.extend(dst + 1);
                        buf.arr[dst++] = (byte)(f.getBoolean(obj) ? 1 : 0);
                        continue block17;
                    }
                    case 1: {
                        buf.extend(dst + 1);
                        buf.arr[dst++] = f.getByte(obj);
                        continue block17;
                    }
                    case 3: {
                        buf.extend(dst + 2);
                        Bytes.pack2(buf.arr, dst, f.getShort(obj));
                        dst += 2;
                        continue block17;
                    }
                    case 2: {
                        buf.extend(dst + 2);
                        Bytes.pack2(buf.arr, dst, (short)f.getChar(obj));
                        dst += 2;
                        continue block17;
                    }
                    case 4: {
                        buf.extend(dst + 4);
                        Bytes.pack4(buf.arr, dst, f.getInt(obj));
                        dst += 4;
                        continue block17;
                    }
                    case 10: {
                        IPersistent p = (IPersistent)f.get(obj);
                        buf.extend(dst + 4);
                        if (p != null) {
                            if (!p.isPersistent()) {
                                this.getStorage().makePersistent(p);
                            }
                            Bytes.pack4(buf.arr, dst, p.getOid());
                        } else {
                            Bytes.pack4(buf.arr, dst, 0);
                        }
                        dst += 4;
                        continue block17;
                    }
                    case 5: {
                        buf.extend(dst + 8);
                        Bytes.pack8(buf.arr, dst, f.getLong(obj));
                        dst += 8;
                        continue block17;
                    }
                    case 9: {
                        Date d = (Date)f.get(obj);
                        buf.extend(dst + 8);
                        Bytes.pack8(buf.arr, dst, d == null ? -1L : d.getTime());
                        dst += 8;
                        continue block17;
                    }
                    case 6: {
                        buf.extend(dst + 4);
                        Bytes.pack4(buf.arr, dst, Float.floatToIntBits(f.getFloat(obj)));
                        dst += 4;
                        continue block17;
                    }
                    case 7: {
                        buf.extend(dst + 8);
                        Bytes.pack8(buf.arr, dst, Double.doubleToLongBits(f.getDouble(obj)));
                        dst += 8;
                        continue block17;
                    }
                    case 14: {
                        buf.extend(dst + 4);
                        Bytes.pack4(buf.arr, dst, ((Enum)f.get(obj)).ordinal());
                        dst += 4;
                        continue block17;
                    }
                    case 8: {
                        int len;
                        buf.extend(dst + 4);
                        String str = this.convertString(f.get(obj));
                        if (str != null) {
                            len = str.length();
                            Bytes.pack4(buf.arr, dst, len);
                            buf.extend((dst += 4) + len * 2);
                            for (int j = 0; j < len; ++j) {
                                Bytes.pack2(buf.arr, dst, (short)str.charAt(j));
                                dst += 2;
                            }
                            continue block17;
                        }
                        Bytes.pack4(buf.arr, dst, 0);
                        dst += 4;
                        continue block17;
                    }
                    case 21: {
                        int len;
                        buf.extend(dst + 4);
                        byte[] arr = (byte[])f.get(obj);
                        if (arr != null) {
                            len = arr.length;
                            Bytes.pack4(buf.arr, dst, len);
                            buf.extend((dst += 4) + len);
                            System.arraycopy(arr, 0, buf.arr, dst, len);
                            dst += len;
                            continue block17;
                        }
                        Bytes.pack4(buf.arr, dst, 0);
                        dst += 4;
                        continue block17;
                    }
                    default: {
                        Assert.failed("Invalid type");
                    }
                }
            }
            return new Key(buf.toArray());
        }
        catch (Exception x) {
            throw new StorageError(17, x);
        }
    }

    private Key convertKey(Key key) {
        if (key == null) {
            return null;
        }
        if (key.type != 30) {
            throw new StorageError(9);
        }
        Object[] values = (Object[])key.oval;
        ByteBuffer buf = new ByteBuffer();
        int dst = 0;
        block15: for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            switch (this.types[i]) {
                case 0: {
                    buf.extend(dst + 1);
                    buf.arr[dst++] = (byte)((Boolean)v != false ? 1 : 0);
                    continue block15;
                }
                case 1: {
                    buf.extend(dst + 1);
                    buf.arr[dst++] = ((Number)v).byteValue();
                    continue block15;
                }
                case 3: {
                    buf.extend(dst + 2);
                    Bytes.pack2(buf.arr, dst, ((Number)v).shortValue());
                    dst += 2;
                    continue block15;
                }
                case 2: {
                    buf.extend(dst + 2);
                    Bytes.pack2(buf.arr, dst, v instanceof Number ? ((Number)v).shortValue() : (short)((Character)v).charValue());
                    dst += 2;
                    continue block15;
                }
                case 4: {
                    buf.extend(dst + 4);
                    Bytes.pack4(buf.arr, dst, ((Number)v).intValue());
                    dst += 4;
                    continue block15;
                }
                case 10: {
                    buf.extend(dst + 4);
                    Bytes.pack4(buf.arr, dst, v == null ? 0 : ((IPersistent)v).getOid());
                    dst += 4;
                    continue block15;
                }
                case 5: {
                    buf.extend(dst + 8);
                    Bytes.pack8(buf.arr, dst, ((Number)v).longValue());
                    dst += 8;
                    continue block15;
                }
                case 9: {
                    buf.extend(dst + 8);
                    Bytes.pack8(buf.arr, dst, v == null ? -1L : ((Date)v).getTime());
                    dst += 8;
                    continue block15;
                }
                case 6: {
                    buf.extend(dst + 4);
                    Bytes.pack4(buf.arr, dst, Float.floatToIntBits(((Number)v).floatValue()));
                    dst += 4;
                    continue block15;
                }
                case 7: {
                    buf.extend(dst + 8);
                    Bytes.pack8(buf.arr, dst, Double.doubleToLongBits(((Number)v).doubleValue()));
                    dst += 8;
                    continue block15;
                }
                case 14: {
                    buf.extend(dst + 4);
                    Bytes.pack4(buf.arr, dst, ((Enum)v).ordinal());
                    dst += 4;
                    continue block15;
                }
                case 8: {
                    int len;
                    buf.extend(dst + 4);
                    if (v != null) {
                        String str = this.convertString(v);
                        len = str.length();
                        Bytes.pack4(buf.arr, dst, len);
                        buf.extend((dst += 4) + len * 2);
                        for (int j = 0; j < len; ++j) {
                            Bytes.pack2(buf.arr, dst, (short)str.charAt(j));
                            dst += 2;
                        }
                        continue block15;
                    }
                    Bytes.pack4(buf.arr, dst, 0);
                    dst += 4;
                    continue block15;
                }
                case 21: {
                    int len;
                    buf.extend(dst + 4);
                    if (v != null) {
                        byte[] arr = (byte[])v;
                        len = arr.length;
                        Bytes.pack4(buf.arr, dst, len);
                        buf.extend((dst += 4) + len);
                        System.arraycopy(arr, 0, buf.arr, dst, len);
                        dst += len;
                        continue block15;
                    }
                    Bytes.pack4(buf.arr, dst, 0);
                    dst += 4;
                    continue block15;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
        }
        return new Key(buf.toArray(), key.inclusion != 0);
    }

    @Override
    public boolean put(T obj) {
        return super.put(this.extractKey((IPersistent)obj), obj);
    }

    @Override
    public T set(T obj) {
        return super.set(this.extractKey((IPersistent)obj), obj);
    }

    @Override
    public void remove(T obj) {
        super.remove(this.extractKey((IPersistent)obj), obj);
    }

    @Override
    public T remove(Key key) {
        return super.remove(this.convertKey(key));
    }

    @Override
    public boolean containsObject(T obj) {
        Key key = this.extractKey((IPersistent)obj);
        if (this.unique) {
            return super.get(key) != null;
        }
        IPersistent[] mbrs = this.get(key, key);
        for (int i = 0; i < mbrs.length; ++i) {
            if (mbrs[i] != obj) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(T obj) {
        Key key = this.extractKey((IPersistent)obj);
        if (this.unique) {
            return super.get(key) != null;
        }
        IPersistent[] mbrs = this.get(key, key);
        for (int i = 0; i < mbrs.length; ++i) {
            if (!mbrs[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void append(T obj) {
        throw new StorageError(8);
    }

    public T[] get(Key from, Key till) {
        ArrayList list = new ArrayList();
        if (this.root != 0) {
            BtreePage.find((StorageImpl)this.getStorage(), this.root, this.convertKey(from), this.convertKey(till), this, this.height, list);
        }
        return list.toArray((IPersistent[])Array.newInstance(this.cls, list.size()));
    }

    public T[] getPrefix(String prefix) {
        throw new StorageError(9);
    }

    public T[] prefixSearch(String key) {
        throw new StorageError(9);
    }

    public T[] toPersistentArray() {
        IPersistent[] arr = (IPersistent[])Array.newInstance(this.cls, this.nElems);
        if (this.root != 0) {
            BtreePage.traverseForward((StorageImpl)this.getStorage(), this.root, this.type, this.height, arr, 0);
        }
        return arr;
    }

    @Override
    public T get(Key key) {
        return (T)super.get(this.convertKey(key));
    }

    @Override
    public IterableIterator<T> iterator(Key from, Key till, int order) {
        return super.iterator(this.convertKey(from), this.convertKey(till), order);
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(Key from, Key till, int order) {
        return super.entryIterator(this.convertKey(from), this.convertKey(till), order);
    }

    @Override
    public IterableIterator<T> queryByExample(T obj) {
        Key key = this.extractKey((IPersistent)obj);
        return this.iterator(key, key, 0);
    }

    @Override
    public IterableIterator<T> select(String predicate) {
        QueryImpl query = new QueryImpl(this.getStorage());
        return query.select(this.cls, this.iterator(), predicate);
    }

    @Override
    public boolean isCaseInsensitive() {
        return false;
    }
}

