/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.Point;
import java.awt.Toolkit;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import mseries.Calendar.MDateOutOfRangeException;
import mseries.Calendar.MMonthEvent;
import mseries.Calendar.MMonthListener;

public class MMonth {
    private Calendar today;
    private Calendar currentDate;
    private Point currentPoint;
    private int calMonth;
    private Calendar startOfMonth;
    private Calendar date;
    protected Vector listeners = new Vector();
    private Calendar minC;
    private Calendar maxC;
    private Toolkit tk;
    int offset;
    int firstDay = 1;
    private Date minDate;
    private Date maxDate;

    public MMonth(Date min, Date max) {
        this.minDate = min;
        this.maxDate = max;
        this.init();
    }

    public MMonth() {
        this.init();
    }

    private void init() {
        this.today = Calendar.getInstance();
        this.today.setTime(new Date());
        this.currentDate = Calendar.getInstance();
        this.currentDate.setTime(new Date());
        this.startOfMonth = Calendar.getInstance();
        this.minC = Calendar.getInstance();
        this.maxC = Calendar.getInstance();
        this.currentPoint = new Point(0, 0);
        this.tk = Toolkit.getDefaultToolkit();
        if (this.minDate == null) {
            this.minC.set(1900, 0, 1, 0, 0, 0);
        } else {
            this.minC.setTime(this.minDate);
        }
        if (this.maxDate == null) {
            this.maxC.set(2037, 11, 31, 23, 59, 59);
        } else {
            this.maxC.setTime(this.maxDate);
        }
        this.setFirstDay(1);
    }

    public void setFirstDay(int first) {
        if (first < 1 || first > 7) {
            return;
        }
        this.firstDay = first;
        try {
            this.setDate(this.getCurrentDate());
        }
        catch (MDateOutOfRangeException mDateOutOfRangeException) {
            // empty catch block
        }
        this.notifyListeners(new MMonthEvent(this, 5, this.currentDate));
    }

    public int getFirstDay() {
        return this.firstDay;
    }

    protected void setDMY(Date inDate) throws MDateOutOfRangeException {
        int h = this.currentDate.get(11);
        int m = this.currentDate.get(12);
        int s = this.currentDate.get(13);
        Calendar newC = Calendar.getInstance();
        newC.setTime(inDate);
        newC.set(11, h);
        newC.set(12, m);
        newC.set(13, s);
        this.setDate(newC.getTime());
    }

    public void setDate(Date inDate) throws MDateOutOfRangeException {
        int col;
        long currentInMillis = 0L;
        long startInMillis = 0L;
        if (MMonth.compDates(inDate, this.minC) < 0 || MMonth.compDates(inDate, this.maxC) > 0) {
            throw new MDateOutOfRangeException(inDate);
        }
        this.currentDate.setTime(inDate);
        currentInMillis = inDate.getTime();
        this.calMonth = this.currentDate.get(2);
        this.startOfMonth.setTime(inDate);
        this.startOfMonth.set(5, 1);
        int startDay = this.startOfMonth.get(7);
        int x = this.firstDay - startDay;
        if (x > 0) {
            x -= 7;
        }
        this.startOfMonth.add(5, x);
        startInMillis = this.startOfMonth.getTime().getTime();
        Double daysD = new Double((double)(currentInMillis - startInMillis) / 8.64E7 + 0.5);
        int daysI = daysD.intValue();
        if (startInMillis < 0L && currentInMillis > 0L) {
            ++daysI;
        }
        int row = Math.abs(daysI / 7);
        this.currentPoint.x = col = daysI - row * 7;
        this.currentPoint.y = row;
        this.notifyListeners(new MMonthEvent(this, 0, this.currentDate));
    }

    public void setMinimum(Date min) {
        if (MMonth.compDates(min, this.maxC) < 0) {
            this.minC.setTime(min);
            this.notifyListeners(new MMonthEvent(this, 2, this.minC));
        }
    }

    public Date getMinimum() {
        return this.minC.getTime();
    }

    public void setMaximum(Date max) {
        if (MMonth.compDates(max, this.minC) > 0) {
            this.maxC.setTime(max);
            this.notifyListeners(new MMonthEvent(this, 3, this.maxC));
        }
    }

    public Date getMaximum() {
        return this.maxC.getTime();
    }

    public void addToMin(int increment) throws MDateOutOfRangeException {
        this.addToM(increment);
    }

    private void addToM(int increment) throws MDateOutOfRangeException {
        Calendar currVal = (Calendar)this.minC.clone();
        int day = this.currentDate.get(5);
        int hour = this.currentDate.get(11);
        int minute = this.currentDate.get(12);
        int second = this.currentDate.get(13);
        currVal.add(2, increment);
        currVal.set(5, day);
        currVal.set(11, hour);
        currVal.set(12, minute);
        currVal.set(13, second);
        int day2 = currVal.get(5);
        if (MMonth.compDates(currVal, this.currentDate) == 0) {
            return;
        }
        if (day != day2) {
            currVal.set(5, 1);
            currVal.add(5, -1);
        }
        this.setDate(currVal.getTime());
    }

    public Date getCurrentDate() {
        return this.currentDate.getTime();
    }

    public Point getCurrentPoint() {
        return this.currentPoint;
    }

    public void setCurrentDate(int row, int col) throws MDateOutOfRangeException {
        Calendar value = (Calendar)this.getValueAt(row, col);
        if (MMonth.compDates(value, this.minC) < 0 || MMonth.compDates(value, this.maxC) > 0) {
            this.tk.beep();
            throw new MDateOutOfRangeException(value.getTime());
        }
        this.currentDate = value;
        this.currentPoint.x = col;
        this.currentPoint.y = row;
        this.notifyListeners(new MMonthEvent(this, 1, this.currentDate));
    }

    public int getMonth() {
        return this.calMonth;
    }

    public int getColumnCount() {
        return 7;
    }

    public int getRowCount() {
        return 6;
    }

    public Object getValueAt(int r, int c) {
        this.offset = r * 7 + c;
        this.date = (Calendar)this.startOfMonth.clone();
        this.date.add(5, this.offset);
        return this.date;
    }

    protected Date getAsDate(int r, int c) {
        Calendar cal = (Calendar)this.getValueAt(r, c);
        return cal.getTime();
    }

    public void addMMonthListener(MMonthListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeMMonthListener(MMonthListener listener) {
        this.listeners.removeElement(listener);
    }

    private void notifyListeners(MMonthEvent event) {
        Vector list = (Vector)this.listeners.clone();
        for (int i = 0; i < list.size(); ++i) {
            MMonthListener l = (MMonthListener)this.listeners.elementAt(i);
            l.dataChanged(event);
        }
    }

    public boolean isInRange(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return this.isInRange(c);
    }

    public boolean isInRange(Calendar date) {
        return MMonth.compDates(date, this.minC) >= 0 && MMonth.compDates(date, this.maxC) <= 0;
    }

    public void exitEvent() {
        this.notifyListeners(new MMonthEvent(this, 4, this.currentDate));
    }

    public void lostFocus() {
        this.notifyListeners(new MMonthEvent(this, 7, this.currentDate));
    }

    public boolean isCellEditable(int r, int c) {
        return false;
    }

    private static int compDates(Calendar d1, Calendar d2) {
        int day1 = d1.get(5);
        int month1 = d1.get(2);
        int year1 = d1.get(1);
        int day2 = d2.get(5);
        int month2 = d2.get(2);
        int year2 = d2.get(1);
        if (year1 != year2) {
            return year1 - year2;
        }
        if (month1 != month2) {
            return month1 - month2;
        }
        if (day1 != day2) {
            return day1 - day2;
        }
        return 0;
    }

    protected static int compDates(Date d1, Calendar c2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime((Date)d1.clone());
        return MMonth.compDates(c1, c2);
    }

    public boolean isCurrentDate(int d, int w) {
        Calendar date = (Calendar)this.getValueAt(d, w);
        return MMonth.compDates(date, this.today) == 0;
    }
}

