
#include "cmdlib.h"
#include <stdio.h>
#include <setjmp.h>


// offsets are allways multiplied by 4 before using
typedef int	gofs_t;				// offset in global data block
typedef struct function_s function_t;

typedef enum {ev_void, ev_string, ev_float, ev_vector, ev_entity, ev_field, ev_function, ev_pointer, ev_bad = -1} etype_t;


#define	MAX_PARMS	8


typedef struct statement_s
{
	unsigned short	op;
	short	a,b,c;
} dstatement_t;

typedef struct
{
	unsigned short	type;		// if DEF_SAVEGLOBGAL bit is set
								// the variable needs to be saved in savegames
	unsigned short	ofs;
	int			s_name;
} ddef_t;
#define	DEF_SAVEGLOBGAL	(1<<15)

#define	MAX_PARMS	8

typedef struct
{
	int		first_statement;	// negative numbers are builtins
	int		parm_start;
	int		locals;				// total ints of parms + locals
	
	int		profile;		// runtime
	
	int		s_name;
	int		s_file;			// source file defined in
	
	int		numparms;
	byte	parm_size[MAX_PARMS];
} dfunction_t;


#define	PROG_VERSION	6
typedef struct
{
	int		version;
	int		crc;			// check of header file
	
	int		ofs_statements;
	int		numstatements;	// statement 0 is an error

	int		ofs_globaldefs;
	int		numglobaldefs;
	
	int		ofs_fielddefs;
	int		numfielddefs;
	
	int		ofs_functions;
	int		numfunctions;	// function 0 is an empty
	
	int		ofs_strings;
	int		numstrings;		// first string is a null string

	int		ofs_globals;
	int		numglobals;
	
	int		entityfields;
} dprograms_t;




//============================================================================

// pr_loc.h -- program local defs

#define	MAX_ERRORS		10

#define	MAX_NAME		64		// chars long

#define	MAX_REGS		16384

//=============================================================================
typedef struct type_s
{
	etype_t			type;
	struct def_s	*def;		// a def that points to this type
	struct type_s	*next;
// function types are more complex
	struct type_s	*aux_type;	// return type or field type
	int				num_parms;	// -1 = variable args
	struct type_s	*parm_types[MAX_PARMS];	// only [num_parms] allocated
	//char			parm_names[MAX_PARMS][MAX_NAME];
} type_t;

extern char *typenames[];


typedef struct def_s
{
	type_t		*type;
	char		*name;
	struct def_s	*next;
	gofs_t		ofs;
	struct def_s	*scope;	// function the var was defined in, or NULL
	int	constant;	// 1 when a declaration included "= immediate"
	int save;
	etype_t		cast;	// used for type casting
	char		*s_file; // used for reclaration info
	int			line; // "   "
	// FrikaC: newtest

	struct def_s *tempnext;
	// FrikaC: newtest end
} def_t;


#define	OFS_NULL		0
#define	OFS_RETURN		1
#define	OFS_PARM0		4		// leave 3 ofs for each parm to hold vectors
#define	OFS_PARM1		7
#define	OFS_PARM2		10
#define	OFS_PARM3		13
#define	OFS_PARM4		16
#define	RESERVED_OFS	28




#define	G_FLOAT(o) (pr_globals[o])
#define	G_INT(o) (*(int *)&pr_globals[o])
#define	G_VECTOR(o) (&pr_globals[o])
#define	G_STRING(o) (strings + *(string_t *)&pr_globals[o])
#define	G_FUNCTION(o) (*(func_t *)&pr_globals[o])

//=============================================================================

#define	MAX_STRINGS		500000
#define	MAX_GLOBALS		16384
#define	MAX_FIELDS		1024
#define	MAX_STATEMENTS	65536
#define	MAX_FUNCTIONS	8192

#define	MAX_SOUNDS		1024
#define	MAX_MODELS		1024
#define	MAX_FILES		1024
#define	MAX_DATA_PATH	64
//=============================================================================
typedef int	func_t;
typedef int	string_t;

typedef union eval_s
{
	string_t			string;
	float				_float;
	float				vector[3];
	func_t				function;
	int					_int;
	union eval_s		*ptr;
} eval_t;	

extern	int	type_size[8];
extern	def_t	*def_for_type[8];

extern	type_t	type_void, type_string, type_float, type_vector, type_entity, type_field, type_function, type_pointer, type_floatfield;

extern	def_t	def_void, def_string, def_float, def_vector, def_entity, def_field, def_function, def_pointer;

struct function_s
{
	int					builtin;	// if non 0, call an internal function
	int					code;		// first statement
	char				*file;		// source file with definition
	int					file_line;
	struct def_s		*def;
	int					parm_ofs[MAX_PARMS];	// allways contiguous, right?
};


//
// output generated by prog parsing
//
typedef struct
{
	char		*memory;
	int		max_memory;
	int		current_memory;
	type_t		*types;

	def_t		def_head;	// unused head of linked list
	def_t		*def_tail;	// add new defs after this and move it

	int		size_fields;
} pr_info_t;

typedef struct
{
	char		*name;
	char		*opname;
	float		priority;
	boolean	right_associative;
	def_t		*type_a, *type_b, *type_c;
} opcode_t;

extern	char	strings[MAX_STRINGS];
extern	int		strofs;

extern	dstatement_t	statements[MAX_STATEMENTS];
extern	int			numstatements;
extern	int			statement_linenums[MAX_STATEMENTS];

extern	dfunction_t	functions[MAX_FUNCTIONS];
extern	int			numfunctions;

extern	float		pr_globals[MAX_REGS];
extern	int			numpr_globals;

extern	char		pr_immediate_string[2048];
extern	int			pr_immediate_strlen;

extern	char		precache_sounds[MAX_SOUNDS][MAX_DATA_PATH];
extern	int			precache_sounds_block[MAX_SOUNDS];
extern	int			numsounds;

extern	char		precache_models[MAX_MODELS][MAX_DATA_PATH];
extern	int			precache_models_block[MAX_SOUNDS];
extern	int			nummodels;

extern	char		precache_files[MAX_FILES][MAX_DATA_PATH];
extern	int			precache_files_block[MAX_SOUNDS];
extern	int			numfiles;


// actual opcodes
enum {
	OP2_DONE,
	OP2_MUL_F,
	OP2_MUL_V,
	OP2_MUL_FV,
	OP2_MUL_VF,
	OP2_DIV_F,
	OP2_ADD_F,
	OP2_ADD_V,
	OP2_SUB_F,
	OP2_SUB_V,
	
	OP2_EQ_F,
	OP2_EQ_V,
	OP2_EQ_S,
	OP2_EQ_E,
	OP2_EQ_FNC,
	
	OP2_NE_F,
	OP2_NE_V,
	OP2_NE_S,
	OP2_NE_E,
	OP2_NE_FNC,
	
	OP2_LE,
	OP2_GE,
	OP2_LT,
	OP2_GT,

	OP2_LOAD_F,
	OP2_LOAD_V,
	OP2_LOAD_S,
	OP2_LOAD_ENT,
	OP2_LOAD_FLD,
	OP2_LOAD_FNC,

	OP2_ADDRESS,

	OP2_STORE_F,
	OP2_STORE_V,
	OP2_STORE_S,
	OP2_STORE_ENT,
	OP2_STORE_FLD,
	OP2_STORE_FNC,

	OP2_STOREP_F,
	OP2_STOREP_V,
	OP2_STOREP_S,
	OP2_STOREP_ENT,
	OP2_STOREP_FLD,
	OP2_STOREP_FNC,

	OP2_RETURN,
	OP2_NOT_F,
	OP2_NOT_V,
	OP2_NOT_S,
	OP2_NOT_ENT,
	OP2_NOT_FNC,
	OP2_IF,
	OP2_IFNOT,
	OP2_CALL0,
	OP2_CALL1,
	OP2_CALL2,
	OP2_CALL3,
	OP2_CALL4,
	OP2_CALL5,
	OP2_CALL6,
	OP2_CALL7,
	OP2_CALL8,
	OP2_STATE,
	OP2_GOTO,
	OP2_AND,
	OP2_OR,
	
	OP2_BITAND,
	OP2_BITOR
};

