/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.fop.pdf.PDFObject;

public class PDFText
extends PDFObject {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String text;

    public static final byte[] escapeByteArray(byte[] data) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(data.length);
        bout.write(40);
        int i = 0;
        while (i < data.length) {
            byte b = data[i];
            switch (b) {
                case 10: {
                    bout.write(92);
                    bout.write(110);
                    break;
                }
                case 13: {
                    bout.write(92);
                    bout.write(114);
                    break;
                }
                case 9: {
                    bout.write(92);
                    bout.write(116);
                    break;
                }
                case 8: {
                    bout.write(92);
                    bout.write(98);
                    break;
                }
                case 12: {
                    bout.write(92);
                    bout.write(102);
                    break;
                }
                case 92: {
                    bout.write(92);
                    bout.write(92);
                    break;
                }
                case 40: {
                    bout.write(92);
                    bout.write(40);
                    break;
                }
                case 41: {
                    bout.write(92);
                    bout.write(41);
                    break;
                }
                default: {
                    bout.write(b);
                }
            }
            ++i;
        }
        bout.write(41);
        return bout.toByteArray();
    }

    public static final String escapeString(String s) {
        if (s == null || s.length() == 0) {
            return "()";
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append("(");
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            PDFText.escapeStringChar(c, sb);
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static final void escapeStringChar(char c, StringBuffer target) {
        if (c > '\u007f') {
            target.append("\\");
            target.append(Integer.toOctalString(c));
        } else {
            switch (c) {
                case '\n': {
                    target.append("\\n");
                    break;
                }
                case '\r': {
                    target.append("\\r");
                    break;
                }
                case '\t': {
                    target.append("\\t");
                    break;
                }
                case '\b': {
                    target.append("\\b");
                    break;
                }
                case '\f': {
                    target.append("\\f");
                    break;
                }
                case '\\': {
                    target.append("\\\\");
                    break;
                }
                case '(': {
                    target.append("\\(");
                    break;
                }
                case ')': {
                    target.append("\\)");
                    break;
                }
                default: {
                    target.append(c);
                }
            }
        }
    }

    public static final String escapeText(String text) {
        return PDFText.escapeText(text, true);
    }

    public static final String escapeText(String text, boolean hexMode) {
        if (text != null && text.length() > 0) {
            if (hexMode) {
                byte[] uniBytes;
                try {
                    uniBytes = text.getBytes("UnicodeBig");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new CascadingRuntimeException("Incompatible VM", uee);
                }
                return PDFText.toHex(uniBytes);
            }
            StringBuffer result = new StringBuffer(text.length() * 2);
            result.append("(");
            int l = text.length();
            result.append("\\376\\377");
            int i = 0;
            while (i < l) {
                char ch = text.charAt(i);
                int high = (ch & 0xFF00) >>> 8;
                int low = ch & 0xFF;
                result.append("\\");
                result.append(Integer.toOctalString(high));
                result.append("\\");
                result.append(Integer.toOctalString(low));
                ++i;
            }
            result.append(")");
            return result.toString();
        }
        return "()";
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public static final String toHex(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        sb.append("<");
        int i = 0;
        while (i < data.length) {
            sb.append(DIGITS[data[i] >>> 4 & 0xF]);
            sb.append(DIGITS[data[i] & 0xF]);
            ++i;
        }
        sb.append(">");
        return sb.toString();
    }

    protected String toPDFString() {
        if (this.getText() == null) {
            throw new IllegalArgumentException("The text of this PDFText must not be empty");
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getObjectID());
        sb.append("(");
        sb.append(PDFText.escapeText(this.getText()));
        sb.append(")");
        sb.append("\nendobj\n");
        return sb.toString();
    }

    public static final byte[] toUTF16(String text) {
        try {
            return text.getBytes("UnicodeBig");
        }
        catch (UnsupportedEncodingException uee) {
            throw new CascadingRuntimeException("Incompatible VM", uee);
        }
    }

    public static final String toUnicodeHex(char c) {
        byte[] uniBytes;
        StringBuffer buf = new StringBuffer(4);
        try {
            char[] a = new char[]{c};
            uniBytes = new String(a).getBytes("UnicodeBigUnmarked");
        }
        catch (UnsupportedEncodingException uee) {
            throw new CascadingRuntimeException("Incompatible VM", uee);
        }
        int i = 0;
        while (i < uniBytes.length) {
            buf.append(DIGITS[uniBytes[i] >>> 4 & 0xF]);
            buf.append(DIGITS[uniBytes[i] & 0xF]);
            ++i;
        }
        return buf.toString();
    }
}

