/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.parser.UnitProcessor;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.extensions.svg.SVGUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.XMLImage;
import org.apache.fop.image.analyser.ImageReader;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGReader
implements ImageReader {
    public static final String SVG_MIME_TYPE = "image/svg+xml";
    private boolean batik = true;

    static /* synthetic */ boolean access$0(SVGReader $0) {
        return $0.batik;
    }

    public String getMimeType() {
        return SVG_MIME_TYPE;
    }

    private FopImage.ImageInfo loadImage(String uri, InputStream bis, FOUserAgent ua) {
        if (this.batik) {
            try {
                Loader loader = new Loader();
                return loader.getImage(uri, bis, ua);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.batik = false;
                return null;
            }
        }
        return null;
    }

    public FopImage.ImageInfo verifySignature(String uri, InputStream fis, FOUserAgent ua) throws IOException {
        FopImage.ImageInfo info;
        block2: {
            info = this.loadImage(uri, fis, ua);
            if (info == null) break block2;
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        return info;
    }

    class Loader {
        Loader() {
        }

        private FopImage.ImageInfo getImage(String uri, InputStream fis, FOUserAgent ua) {
            try {
                int length = 5;
                fis.mark(length);
                byte[] b = new byte[length];
                fis.read(b);
                String start = new String(b);
                fis.reset();
                if (start.equals("<?xml")) {
                    InputStream input = fis;
                    fis = new InputStream(input){
                        private final /* synthetic */ InputStream val$input;
                        {
                            this.val$input = val$input;
                        }

                        public int available() throws IOException {
                            return this.val$input.available();
                        }

                        public void close() throws IOException {
                        }

                        public void mark(int rl) {
                            this.val$input.mark(rl);
                        }

                        public boolean markSupported() {
                            return this.val$input.markSupported();
                        }

                        public int read() throws IOException {
                            return this.val$input.read();
                        }

                        public int read(byte[] b) throws IOException {
                            return this.val$input.read(b);
                        }

                        public int read(byte[] b, int off, int len) throws IOException {
                            return this.val$input.read(b, off, len);
                        }

                        public void reset() throws IOException {
                            this.val$input.reset();
                        }

                        public long skip(long n) throws IOException {
                            return this.val$input.skip(n);
                        }
                    };
                }
                FopImage.ImageInfo info = new FopImage.ImageInfo();
                info.mimeType = SVGReader.this.getMimeType();
                info.str = "http://www.w3.org/2000/svg";
                length = fis.available();
                fis.mark(length + 1);
                SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLImage.getParserName());
                SVGDocument doc = factory.createSVGDocument(uri, fis);
                info.data = doc;
                SVGSVGElement e = doc.getRootElement();
                SVGUserAgent userAg = new SVGUserAgent(ua, new AffineTransform());
                BridgeContext ctx = new BridgeContext((UserAgent)userAg);
                UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)ctx, (Element)e);
                String s = e.getAttributeNS(null, "width");
                if (s.length() == 0) {
                    s = "100%";
                }
                info.width = (int)UnitProcessor.svgHorizontalLengthToUserSpace((String)s, (String)"width", (UnitProcessor.Context)uctx);
                s = e.getAttributeNS(null, "height");
                if (s.length() == 0) {
                    s = "100%";
                }
                info.height = (int)UnitProcessor.svgVerticalLengthToUserSpace((String)s, (String)"height", (UnitProcessor.Context)uctx);
                return info;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                try {
                    fis.reset();
                }
                catch (IOException iOException) {}
                SVGReader.this.batik = false;
                return null;
            }
            catch (Exception exception) {
                try {
                    fis.reset();
                }
                catch (IOException iOException) {}
                return null;
            }
        }
    }
}

