/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.BMPReader;
import org.apache.fop.image.analyser.EPSReader;
import org.apache.fop.image.analyser.GIFReader;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.image.analyser.JPEGReader;
import org.apache.fop.image.analyser.PNGReader;
import org.apache.fop.image.analyser.SVGReader;
import org.apache.fop.image.analyser.TIFFReader;
import org.apache.fop.image.analyser.XMLReader;

public class ImageReaderFactory {
    private static ArrayList formats = new ArrayList();

    static {
        ImageReaderFactory.registerFormat(new JPEGReader());
        ImageReaderFactory.registerFormat(new BMPReader());
        ImageReaderFactory.registerFormat(new GIFReader());
        ImageReaderFactory.registerFormat(new PNGReader());
        ImageReaderFactory.registerFormat(new TIFFReader());
        ImageReaderFactory.registerFormat(new EPSReader());
        ImageReaderFactory.registerFormat(new SVGReader());
        ImageReaderFactory.registerFormat(new XMLReader());
    }

    public static FopImage.ImageInfo make(String uri, InputStream in, FOUserAgent ua) {
        try {
            int count = 0;
            while (count < formats.size()) {
                ImageReader reader = (ImageReader)formats.get(count);
                FopImage.ImageInfo info = reader.verifySignature(uri, in, ua);
                if (info != null) {
                    return info;
                }
                ++count;
            }
        }
        catch (IOException ex) {
            ua.getLogger().error("Error while recovering Image Informations (" + uri + ")", ex);
        }
        return null;
    }

    public static void registerFormat(ImageReader reader) {
        formats.add(reader);
    }
}

