/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFCmapEntry;
import org.apache.fop.fonts.truetype.TTFFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TTFReader
extends AbstractLogEnabled {
    public Document constructFontXML(TTFFile ttf, String fontName, String className, String resource, String file, boolean isCid, String ttcName) {
        Document doc;
        this.getLogger().info("Creating xml font file...");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            this.getLogger().error("Can't create DOM implementation", e);
            return null;
        }
        Element root = doc.createElement("font-metrics");
        doc.appendChild(root);
        if (isCid) {
            root.setAttribute("type", "TYPE0");
        } else {
            root.setAttribute("type", "TRUETYPE");
        }
        Element el = doc.createElement("font-name");
        root.appendChild(el);
        String s = this.stripWhiteSpace(ttf.getPostScriptName());
        if (fontName != null) {
            el.appendChild(doc.createTextNode(this.stripWhiteSpace(fontName)));
        } else {
            el.appendChild(doc.createTextNode(s));
        }
        el = doc.createElement("embed");
        root.appendChild(el);
        if (file != null && ttf.isEmbeddable()) {
            el.setAttribute("file", file);
        }
        if (resource != null && ttf.isEmbeddable()) {
            el.setAttribute("class", resource);
        }
        el = doc.createElement("cap-height");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getCapHeight())));
        el = doc.createElement("x-height");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getXHeight())));
        el = doc.createElement("ascender");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getLowerCaseAscent())));
        el = doc.createElement("descender");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getLowerCaseDescent())));
        Element bbox = doc.createElement("bbox");
        root.appendChild(bbox);
        int[] bb = ttf.getFontBBox();
        String[] names = new String[]{"left", "bottom", "right", "top"};
        int i = 0;
        while (i < names.length) {
            el = doc.createElement(names[i]);
            bbox.appendChild(el);
            el.appendChild(doc.createTextNode(String.valueOf(bb[i])));
            ++i;
        }
        el = doc.createElement("flags");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getFlags())));
        el = doc.createElement("stemv");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(ttf.getStemV()));
        el = doc.createElement("italicangle");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(ttf.getItalicAngle()));
        if (ttcName != null) {
            el = doc.createElement("ttc-name");
            root.appendChild(el);
            el.appendChild(doc.createTextNode(ttcName));
        }
        el = doc.createElement("subtype");
        root.appendChild(el);
        if (isCid) {
            el.appendChild(doc.createTextNode("TYPE0"));
            this.generateDOM4MultiByteExtras(root, ttf, isCid);
        } else {
            el.appendChild(doc.createTextNode("TRUETYPE"));
            this.generateDOM4SingleByteExtras(root, ttf, isCid);
        }
        this.generateDOM4Kerning(root, ttf, isCid);
        return doc;
    }

    private void displayUsage() {
        this.getLogger().info(" java org.apache.fop.fonts.apps.TTFReader [options] fontfile.ttf xmlfile.xml");
        this.getLogger().info(" where options can be:");
        this.getLogger().info("-d <DEBUG|INFO>");
        this.getLogger().info("     Set debug level (default: INFO).");
        this.getLogger().info("-enc ansi");
        this.getLogger().info("     With this option you create a WinAnsi encoded font.");
        this.getLogger().info("     The default is to create a CID keyed font.");
        this.getLogger().info("     If you're not going to use characters outside the");
        this.getLogger().info("     pdfencoding range (almost the same as iso-8889-1)");
        this.getLogger().info("     you can add this option.");
        this.getLogger().info("-ttcname <fontname>");
        this.getLogger().info("     If you're reading data from a TrueType Collection");
        this.getLogger().info("     (.ttc file) you must specify which font from the");
        this.getLogger().info("     collection you will read metrics from. If you read");
        this.getLogger().info("     from a .ttc file without this option, the fontnames");
        this.getLogger().info("      will be listed for you.");
        this.getLogger().info(" -fn <fontname>");
        this.getLogger().info("     default is to use the fontname in the .ttf file, but");
        this.getLogger().info("     you can override that name to make sure that the");
        this.getLogger().info("     embedded font is used (if you're embedding fonts)");
        this.getLogger().info("     instead of installed fonts when viewing documents ");
        this.getLogger().info("     with Acrobat Reader.");
    }

    private String escapeString(String str) {
        StringBuffer esc = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\\') {
                esc.append("\\\\");
            } else {
                esc.append(str.charAt(i));
            }
            ++i;
        }
        return esc.toString();
    }

    private void generateDOM4Kerning(Element parent, TTFFile ttf, boolean isCid) {
        Document doc = parent.getOwnerDocument();
        Iterator iterator = isCid ? ttf.getKerning().keySet().iterator() : ttf.getAnsiKerning().keySet().iterator();
        while (iterator.hasNext()) {
            Integer kpx1 = (Integer)iterator.next();
            Element el = doc.createElement("kerning");
            el.setAttribute("kpx1", kpx1.toString());
            parent.appendChild(el);
            Element el2 = null;
            Map h2 = isCid ? (Map)ttf.getKerning().get(kpx1) : (Map)ttf.getAnsiKerning().get(kpx1);
            Iterator enum2 = h2.keySet().iterator();
            while (enum2.hasNext()) {
                Integer kpx2 = (Integer)enum2.next();
                if (!isCid && kpx2 >= 256) continue;
                el2 = doc.createElement("pair");
                el2.setAttribute("kpx2", kpx2.toString());
                Integer val = (Integer)h2.get(kpx2);
                el2.setAttribute("kern", val.toString());
                el.appendChild(el2);
            }
        }
    }

    private void generateDOM4MultiByteExtras(Element parent, TTFFile ttf, boolean isCid) {
        Document doc = parent.getOwnerDocument();
        Element mel = doc.createElement("multibyte-extras");
        parent.appendChild(mel);
        Element el = doc.createElement("cid-type");
        mel.appendChild(el);
        el.appendChild(doc.createTextNode("CIDFontType2"));
        el = doc.createElement("default-width");
        mel.appendChild(el);
        el.appendChild(doc.createTextNode("0"));
        el = doc.createElement("bfranges");
        mel.appendChild(el);
        ListIterator e = ttf.getCMaps().listIterator();
        while (e.hasNext()) {
            TTFCmapEntry ce = (TTFCmapEntry)e.next();
            Element el2 = doc.createElement("bf");
            el.appendChild(el2);
            el2.setAttribute("us", String.valueOf(ce.getUnicodeStart()));
            el2.setAttribute("ue", String.valueOf(ce.getUnicodeEnd()));
            el2.setAttribute("gi", String.valueOf(ce.getGlyphStartIndex()));
        }
        el = doc.createElement("cid-widths");
        el.setAttribute("start-index", "0");
        mel.appendChild(el);
        int[] wx = ttf.getWidths();
        int i = 0;
        while (i < wx.length) {
            Element wxel = doc.createElement("wx");
            wxel.setAttribute("w", String.valueOf(wx[i]));
            el.appendChild(wxel);
            ++i;
        }
    }

    private void generateDOM4SingleByteExtras(Element parent, TTFFile ttf, boolean isCid) {
        Document doc = parent.getOwnerDocument();
        Element sel = doc.createElement("singlebyte-extras");
        parent.appendChild(sel);
        Element el = doc.createElement("encoding");
        sel.appendChild(el);
        el.appendChild(doc.createTextNode(ttf.getCharSetName()));
        el = doc.createElement("first-char");
        sel.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getFirstChar())));
        el = doc.createElement("last-char");
        sel.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getLastChar())));
        Element widths = doc.createElement("widths");
        sel.appendChild(widths);
        short i = ttf.getFirstChar();
        while (i <= ttf.getLastChar()) {
            el = doc.createElement("char");
            widths.appendChild(el);
            el.setAttribute("idx", String.valueOf(i));
            el.setAttribute("wdt", String.valueOf(ttf.getCharWidth(i)));
            i = (short)(i + 1);
        }
    }

    public TTFFile loadTTF(String fileName, String fontName) throws IOException {
        TTFFile ttfFile = new TTFFile();
        this.setupLogger(ttfFile);
        this.getLogger().info("Reading " + fileName + "...");
        FontFileReader reader = new FontFileReader(fileName);
        boolean supported = ttfFile.readFont(reader, fontName);
        if (!supported) {
            return null;
        }
        return ttfFile;
    }

    public static void main(String[] args) {
        block18: {
            String enc;
            String embFile = null;
            String embResource = null;
            String className = null;
            String fontName = null;
            String ttcName = null;
            boolean isCid = true;
            HashMap options = new HashMap();
            String[] arguments = TTFReader.parseArguments(options, args);
            int level = 1;
            if (options.get("-d") != null) {
                String lev = (String)options.get("-d");
                if (lev.equals("DEBUG")) {
                    level = 0;
                } else if (lev.equals("INFO")) {
                    level = 1;
                }
            }
            ConsoleLogger log = new ConsoleLogger(level);
            TTFReader app = new TTFReader();
            app.enableLogging(log);
            log.info("TTF Reader v1.1.4");
            if (options.get("-enc") != null && "ansi".equals(enc = (String)options.get("-enc"))) {
                isCid = false;
            }
            if (options.get("-ttcname") != null) {
                ttcName = (String)options.get("-ttcname");
            }
            if (options.get("-ef") != null) {
                embFile = (String)options.get("-ef");
            }
            if (options.get("-er") != null) {
                embResource = (String)options.get("-er");
            }
            if (options.get("-fn") != null) {
                fontName = (String)options.get("-fn");
            }
            if (options.get("-cn") != null) {
                className = (String)options.get("-cn");
            }
            if (arguments.length != 2 || options.get("-h") != null || options.get("-help") != null || options.get("--help") != null) {
                app.displayUsage();
            } else {
                try {
                    TTFFile ttf = app.loadTTF(arguments[0], ttcName);
                    if (ttf == null) break block18;
                    Document doc = app.constructFontXML(ttf, fontName, className, embResource, embFile, isCid, ttcName);
                    if (isCid) {
                        log.info("Creating CID encoded metrics");
                    } else {
                        log.info("Creating WinAnsi encoded metrics");
                    }
                    if (doc != null) {
                        app.writeFontXML(doc, arguments[1]);
                    }
                    if (ttf.isEmbeddable()) {
                        log.info("This font contains no embedding license restrictions");
                        break block18;
                    }
                    log.info("** Note: This font contains license retrictions for\n         embedding. This font shouldn't be embedded.");
                }
                catch (Exception e) {
                    log.error("Error while building XML font metrics file", e);
                    System.exit(-1);
                }
            }
        }
    }

    private static String[] parseArguments(Map options, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    options.put(args[i], args[i + 1]);
                    ++i;
                } else {
                    options.put(args[i], "");
                }
            } else {
                arguments.add(args[i]);
            }
            ++i;
        }
        return arguments.toArray(new String[0]);
    }

    private String stripWhiteSpace(String s) {
        char[] ch = new char[s.length()];
        s.getChars(0, s.length(), ch, 0);
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < ch.length) {
            if (ch[i] != ' ' && ch[i] != '\r' && ch[i] != '\n' && ch[i] != '\t') {
                stb.append(ch[i]);
            }
            ++i;
        }
        return stb.toString();
    }

    public void writeFontXML(Document doc, String target) throws TransformerException {
        this.getLogger().info("Writing xml font file " + target + "...");
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(new File(target)));
    }
}

