/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.MutableFont;
import org.apache.fop.fonts.Typeface;

public abstract class CustomFont
extends Typeface
implements FontDescriptor,
MutableFont {
    private String fontName = null;
    private String embedFileName = null;
    private String embedResourceName = null;
    private int capHeight = 0;
    private int xHeight = 0;
    private int ascender = 0;
    private int descender = 0;
    private int[] fontBBox = new int[4];
    private int flags = 4;
    private int stemV = 0;
    private int italicAngle = 0;
    private int missingWidth = 0;
    private FontType fontType = FontType.TYPE1;
    private int firstChar = 0;
    private int lastChar = 255;
    private Map kerning = new HashMap();
    private boolean useKerning = true;

    public int getAscender() {
        return this.ascender;
    }

    public int getAscender(int size) {
        return size * this.ascender;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public int getCapHeight(int size) {
        return size * this.capHeight;
    }

    public int getDescender() {
        return this.descender;
    }

    public int getDescender(int size) {
        return size * this.descender;
    }

    public String getEmbedFileName() {
        return this.embedFileName;
    }

    public String getEmbedResourceName() {
        return this.embedResourceName;
    }

    public int getFirstChar() {
        return 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getFontBBox() {
        return this.fontBBox;
    }

    public String getFontName() {
        return this.fontName;
    }

    public FontType getFontType() {
        return this.fontType;
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    public final Map getKerningInfo() {
        if (this.isKerningEnabled()) {
            return this.kerning;
        }
        return Collections.EMPTY_MAP;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    public int getStemV() {
        return this.stemV;
    }

    public int getXHeight(int size) {
        return size * this.xHeight;
    }

    public final boolean hasKerningInfo() {
        return this.isKerningEnabled() & this.kerning.isEmpty();
    }

    public abstract boolean isEmbeddable();

    public boolean isKerningEnabled() {
        return this.useKerning;
    }

    public void putKerningEntry(Integer key, Map value) {
        this.kerning.put(key, value);
    }

    public void setAscender(int ascender) {
        this.ascender = ascender;
    }

    public void setCapHeight(int capHeight) {
        this.capHeight = capHeight;
    }

    public void setDescender(int descender) {
        this.descender = descender;
    }

    public void setEmbedFileName(String path) {
        this.embedFileName = path;
    }

    public void setEmbedResourceName(String name) {
        this.embedResourceName = name;
    }

    public void setFirstChar(int index) {
        this.firstChar = index;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setFontBBox(int[] bbox) {
        this.fontBBox = bbox;
    }

    public void setFontName(String name) {
        this.fontName = name;
    }

    public void setFontType(FontType fontType) {
        this.fontType = fontType;
    }

    public void setItalicAngle(int italicAngle) {
        this.italicAngle = italicAngle;
    }

    public void setKerningEnabled(boolean enabled) {
        this.useKerning = enabled;
    }

    public void setLastChar(int index) {
        this.lastChar = index;
    }

    public void setMissingWidth(int width) {
        this.missingWidth = width;
    }

    public void setStemV(int stemV) {
        this.stemV = stemV;
    }

    public void setXHeight(int xHeight) {
        this.xHeight = xHeight;
    }
}

