/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTree;
import org.apache.fop.area.AreaTreeControl;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.fo.FOInputHandler;
import org.apache.fop.fo.FOTreeControl;
import org.apache.fop.fo.FOTreeEvent;
import org.apache.fop.fo.FOTreeListener;
import org.apache.fop.fo.extensions.Bookmarks;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.layout.LayoutStrategy;
import org.xml.sax.SAXException;

public class Document
implements FOTreeControl,
FOTreeListener,
AreaTreeControl {
    private Driver driver;
    private Map usedFonts;
    private Map triplets;
    private Map fonts;
    private LayoutStrategy layoutStrategy = null;
    public AreaTree areaTree;
    public AreaTreeModel atModel;
    private Bookmarks bookmarks = null;
    private Set idReferences = new HashSet();
    public FOInputHandler foInputHandler;

    public Document(Driver driver) {
        this.driver = driver;
        this.triplets = new HashMap();
        this.fonts = new HashMap();
        this.usedFonts = new HashMap();
    }

    public void addFontProperties(String name, String family, String style, int weight) {
        String key = Document.createFontKey(family, style, weight);
        this.triplets.put(key, name);
    }

    public void addMetrics(String name, FontMetrics metrics) {
        this.fonts.put(name, metrics);
    }

    public static String createFontKey(String family, String style, int weight) {
        return String.valueOf(family) + "," + style + "," + weight;
    }

    public String findAdjustWeight(String family, String style, int weight) {
        String key;
        String f = null;
        int newWeight = weight;
        if (newWeight < 400) {
            while (f == null && newWeight > 0) {
                key = Document.createFontKey(family, style, newWeight -= 100);
                f = (String)this.triplets.get(key);
            }
        } else if (newWeight == 500) {
            key = Document.createFontKey(family, style, 400);
            f = (String)this.triplets.get(key);
        } else if (newWeight > 500) {
            while (f == null && newWeight < 1000) {
                key = Document.createFontKey(family, style, newWeight += 100);
                f = (String)this.triplets.get(key);
            }
            newWeight = weight;
            while (f == null && newWeight > 400) {
                key = Document.createFontKey(family, style, newWeight -= 100);
                f = (String)this.triplets.get(key);
            }
        }
        if (f == null) {
            key = Document.createFontKey(family, style, 400);
            f = (String)this.triplets.get(key);
        }
        return f;
    }

    public void foDocumentComplete(FOTreeEvent event) throws SAXException {
        try {
            this.areaTree.endDocument();
            this.driver.getRenderer().stopRenderer();
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    public void foPageSequenceComplete(FOTreeEvent event) throws FOPException {
        PageSequence pageSeq = event.getPageSequence();
        this.areaTree.addBookmarksToAreaTree();
        this.layoutStrategy.format(pageSeq, this.areaTree);
    }

    public String fontLookup(String family, String style, int weight) {
        String key = Document.createFontKey(family, style, weight);
        String f = (String)this.triplets.get(key);
        if (f == null) {
            f = this.findAdjustWeight(family, style, weight);
            if (f == null) {
                key = Document.createFontKey("any", style, weight);
                f = (String)this.triplets.get(key);
            }
            if (f == null) {
                f = this.findAdjustWeight(family, style, weight);
            }
            if (f == null) {
                f = (String)this.triplets.get("any,normal,400");
            }
        }
        this.usedFonts.put(f, this.fonts.get(f));
        return f;
    }

    public AreaTree getAreaTree() {
        return this.areaTree;
    }

    public Bookmarks getBookmarks() {
        return this.bookmarks;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public FOInputHandler getFOInputHandler() {
        return this.foInputHandler;
    }

    public Map getFonts() {
        return Collections.unmodifiableMap(this.fonts);
    }

    public Set getIDReferences() {
        return this.idReferences;
    }

    public LayoutStrategy getLayoutStrategy() {
        return this.layoutStrategy;
    }

    public Logger getLogger() {
        return this.getDriver().getLogger();
    }

    public FontMetrics getMetricsFor(String fontName) {
        this.usedFonts.put(fontName, this.fonts.get(fontName));
        return (FontMetrics)this.fonts.get(fontName);
    }

    public Map getUsedFonts() {
        return this.usedFonts;
    }

    public FOUserAgent getUserAgent() {
        return this.getDriver().getUserAgent();
    }

    public boolean hasFont(String family, String style, int weight) {
        String key = Document.createFontKey(family, style, weight);
        return this.triplets.containsKey(key);
    }

    public boolean isSetupValid() {
        return this.triplets.containsKey("any,normal,400");
    }

    public void setBookmarks(Bookmarks bookmarks) {
        this.bookmarks = bookmarks;
    }

    public void setLayoutStrategy(LayoutStrategy ls) {
        this.layoutStrategy = ls;
    }
}

