/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.filemode;

import freemind.main.FreeMindMain;
import freemind.modes.NodeAdapter;
import freemind.modes.filemode.FileEdgeModel;
import java.awt.Color;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;

public class FileNodeModel
extends NodeAdapter {
    private File file;
    private Color color;

    public FileNodeModel(File file, FreeMindMain frame) {
        super(frame);
        this.setEdge(new FileEdgeModel(this, this.getFrame()));
        this.file = file;
        this.setFolded(!file.isFile());
    }

    public String getStyle() {
        return "fork";
    }

    File getFile() {
        return this.file;
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = this.isLeaf() ? Color.BLACK : Color.GRAY;
        }
        return this.color;
    }

    public String toString() {
        String name = this.file.getName();
        if (name.equals("")) {
            name = "Root";
        }
        return name;
    }

    public boolean hasChildren() {
        return !this.file.isFile() || this.children != null && !this.children.isEmpty();
    }

    public ListIterator childrenFolded() {
        if (!this.isRoot() && (this.isFolded() || this.isLeaf())) {
            return Collections.EMPTY_LIST.listIterator();
        }
        return this.childrenUnfolded();
    }

    public ListIterator childrenUnfolded() {
        if (this.children != null) {
            return this.children.listIterator();
        }
        try {
            String[] files = this.file.list();
            if (files != null) {
                this.children = new LinkedList();
                String path = this.file.getPath();
                for (int i = 0; i < files.length; ++i) {
                    File childFile = new File(path, files[i]);
                    if (childFile.isHidden()) continue;
                    this.insert(new FileNodeModel(childFile, this.getFrame()), 0);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return this.children != null ? this.children.listIterator() : Collections.EMPTY_LIST.listIterator();
    }

    public boolean isLeaf() {
        return this.file.isFile();
    }

    public String getLink() {
        return this.file.toString();
    }
}

