/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.MenuItemEnabledListener;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.FreemindAction;
import freemind.controller.actions.generated.instance.HookNodeAction;
import freemind.controller.actions.generated.instance.NodeListMember;
import freemind.controller.actions.generated.instance.NodeListMemberType;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookFactory;
import freemind.extensions.HookInstanciationMethod;
import freemind.extensions.NodeHook;
import freemind.extensions.PermanentNodeHook;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.xml.bind.JAXBException;

public class NodeHookAction
extends FreemindAction
implements ActorXml,
MenuItemEnabledListener {
    String _hookName;
    ModeController controller;
    private static Logger logger;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$HookNodeAction;

    public ModeController getController() {
        return this.controller;
    }

    public NodeHookAction(String hookName, ModeController controller) {
        super(hookName, (Icon)null, null);
        this._hookName = hookName;
        this.controller = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent arg0) {
        this.controller.getFrame().setWaitingCursor(true);
        this.invoke(this.controller.getSelected(), this.controller.getSelecteds());
        this.controller.getFrame().setWaitingCursor(false);
    }

    public void addHook(MindMapNode focussed, List selecteds, String hookName) {
        HookNodeAction doAction = this.createHookNodeAction(focussed, selecteds, hookName);
        XmlAction undoAction = null;
        try {
            undoAction = this.controller.getActionXmlFactory().createCompoundAction();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        if (this.getInstanciationMethod(hookName).isPermanent()) {
            undoAction = this.createHookNodeAction(focussed, selecteds, hookName);
        }
        if (this.getInstanciationMethod(hookName).isUndoable()) {
            this.getController().getActionFactory().startTransaction((String)this.getValue("Name"));
            this.getController().getActionFactory().executeAction(new ActionPair(doAction, undoAction));
            this.getController().getActionFactory().endTransaction((String)this.getValue("Name"));
        } else {
            this.invoke(focussed, selecteds, hookName);
        }
    }

    public void invoke(MindMapNode focussed, List selecteds) {
        this.addHook(focussed, selecteds, this._hookName);
    }

    private void invoke(MindMapNode focussed, List selecteds, String hookName) {
        logger.finest("invoke(selecteds) called.");
        HookInstanciationMethod instMethod = this.getInstanciationMethod(hookName);
        Collection destinationNodes = instMethod.getDestinationNodes(this.controller, focussed, selecteds);
        MindMapNode adaptedFocussedNode = instMethod.getCenterNode(this.controller, focussed, selecteds);
        if (instMethod.isAlreadyPresent(this.controller, hookName, adaptedFocussedNode, destinationNodes)) {
            Iterator i = destinationNodes.iterator();
            block0: while (i.hasNext()) {
                MindMapNode currentDestinationNode = (MindMapNode)i.next();
                Iterator j = currentDestinationNode.getActivatedHooks().iterator();
                while (j.hasNext()) {
                    PermanentNodeHook hook = (PermanentNodeHook)j.next();
                    if (!hook.getName().equals(hookName)) continue;
                    currentDestinationNode.removeHook(hook);
                    continue block0;
                }
            }
        } else {
            Iterator it = destinationNodes.iterator();
            while (it.hasNext()) {
                MindMapNode currentDestinationNode = (MindMapNode)it.next();
                NodeHook hook = this.controller.createNodeHook(hookName, currentDestinationNode, this.controller.getMap());
                logger.finest("created hook " + hookName);
                currentDestinationNode.invokeHook(hook);
                if (!(hook instanceof PermanentNodeHook)) continue;
                PermanentNodeHook permHook = (PermanentNodeHook)hook;
                logger.finest("This is a permanent hook " + hookName);
                if (currentDestinationNode == adaptedFocussedNode) {
                    permHook.onReceiveFocusHook();
                }
                this.controller.nodeChanged(currentDestinationNode);
            }
            this.finishInvocation(focussed, selecteds, adaptedFocussedNode, destinationNodes);
        }
    }

    private void finishInvocation(MindMapNode focussed, List selecteds, MindMapNode adaptedFocussedNode, Collection destinationNodes) {
        if (focussed.getViewer() != null) {
            this.getController().getView().selectAsTheOnlyOneSelected(focussed.getViewer());
            this.getController().getView().scrollNodeToVisible(focussed.getViewer());
            Iterator i = selecteds.iterator();
            while (i.hasNext()) {
                MindMapNode node = (MindMapNode)i.next();
                if (node.getViewer() == null) continue;
                this.getController().getView().makeTheSelected(node.getViewer());
            }
        }
    }

    private HookInstanciationMethod getInstanciationMethod(String hookName) {
        HookFactory factory = this.getHookFactory();
        HookInstanciationMethod instMethod = factory.getInstanciationMethod(hookName);
        return instMethod;
    }

    private HookFactory getHookFactory() {
        HookFactory factory = this.controller.getFrame().getHookFactory();
        return factory;
    }

    public boolean isEnabled(JMenuItem item, Action action) {
        HookFactory factory = this.getHookFactory();
        Object baseClass = factory.getPluginBaseClass(this._hookName);
        if (baseClass != null && baseClass instanceof MenuItemEnabledListener) {
            MenuItemEnabledListener listener = (MenuItemEnabledListener)baseClass;
            return listener.isEnabled(item, this);
        }
        MindMapNode focussed = this.controller.getSelected();
        List selecteds = this.controller.getSelecteds();
        HookInstanciationMethod instMethod = this.getInstanciationMethod(this._hookName);
        Collection destinationNodes = instMethod.getDestinationNodes(this.controller, focussed, selecteds);
        MindMapNode adaptedFocussedNode = instMethod.getCenterNode(this.controller, focussed, selecteds);
        boolean isActionSelected = instMethod.isAlreadyPresent(this.controller, this._hookName, adaptedFocussedNode, destinationNodes);
        this.setSelected(item, isActionSelected);
        return true;
    }

    public HookNodeAction createHookNodeAction(MindMapNode focussed, List selecteds, String hookName) {
        try {
            HookNodeAction hookNodeAction = this.getController().getActionXmlFactory().createHookNodeAction();
            hookNodeAction.setNode(focussed.getObjectId(this.getController()));
            hookNodeAction.setHookName(hookName);
            Iterator i = selecteds.iterator();
            while (i.hasNext()) {
                MindMapNode node = (MindMapNode)i.next();
                NodeListMember nodeListMember = this.getController().getActionXmlFactory().createNodeListMember();
                nodeListMember.setNode(node.getObjectId(this.getController()));
                hookNodeAction.getNodeListMember().add(nodeListMember);
            }
            return hookNodeAction;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void act(XmlAction action) {
        if (action instanceof HookNodeAction) {
            HookNodeAction hookNodeAction = (HookNodeAction)action;
            NodeAdapter selected = this.getController().getNodeFromID(hookNodeAction.getNode());
            Vector<NodeAdapter> selecteds = new Vector<NodeAdapter>();
            Iterator i = hookNodeAction.getNodeListMember().iterator();
            while (i.hasNext()) {
                NodeListMemberType node = (NodeListMemberType)i.next();
                selecteds.add(this.getController().getNodeFromID(node.getNode()));
            }
            this.invoke(selected, selecteds, hookNodeAction.getHookName());
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$HookNodeAction == null ? (class$freemind$controller$actions$generated$instance$HookNodeAction = NodeHookAction.class$("freemind.controller.actions.generated.instance.HookNodeAction")) : class$freemind$controller$actions$generated$instance$HookNodeAction;
    }

    public String getHookName() {
        return this._hookName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

