/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.Controller;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.FreemindAction;
import freemind.controller.actions.generated.instance.NodeBackgroundColorFormatAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.actions.NodeGeneralAction;
import freemind.modes.actions.SingleNodeOperation;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import javax.xml.bind.JAXBException;

public class NodeBackgroundColorAction
extends FreemindAction
implements ActorXml {
    private final ModeController controller;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$NodeBackgroundColorFormatAction;

    public NodeBackgroundColorAction(ModeController controller) {
        super("node_background_color", (String)null, controller);
        this.controller = controller;
        this.addActor(this);
    }

    public void actionPerformed(ActionEvent e) {
        Color color = Controller.showCommonJColorChooserDialog(this.controller.getView().getSelected(), this.controller.getText("choose_node_background_color"), this.controller.getSelected().getBackgroundColor());
        if (color == null) {
            return;
        }
        ListIterator it = this.controller.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.setNodeBackgroundColor(selected, color);
        }
    }

    public void setNodeBackgroundColor(MindMapNode node, Color color) {
        try {
            NodeBackgroundColorFormatAction doAction = this.createNodeBackgroundColorFormatAction(node, color);
            NodeBackgroundColorFormatAction undoAction = this.createNodeBackgroundColorFormatAction(node, node.getBackgroundColor());
            this.controller.getActionFactory().startTransaction(this.getClass().getName());
            this.controller.getActionFactory().executeAction(new ActionPair(doAction, undoAction));
            this.controller.getActionFactory().endTransaction(this.getClass().getName());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public NodeBackgroundColorFormatAction createNodeBackgroundColorFormatAction(MindMapNode node, Color color) throws JAXBException {
        NodeBackgroundColorFormatAction nodeAction = this.controller.getActionXmlFactory().createNodeBackgroundColorFormatAction();
        nodeAction.setNode(node.getObjectId(this.controller));
        nodeAction.setColor(Tools.colorToXml(color));
        return nodeAction;
    }

    public void act(XmlAction action) {
        NodeAdapter node;
        Color oldColor;
        NodeBackgroundColorFormatAction nodeColorAction;
        Color color;
        if (action instanceof NodeBackgroundColorFormatAction && !Tools.safeEquals(color = Tools.xmlToColor((nodeColorAction = (NodeBackgroundColorFormatAction)action).getColor()), oldColor = (node = this.controller.getNodeFromID(nodeColorAction.getNode())).getBackgroundColor())) {
            node.setBackgroundColor(color);
            this.controller.nodeChanged(node);
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$NodeBackgroundColorFormatAction == null ? (class$freemind$controller$actions$generated$instance$NodeBackgroundColorFormatAction = NodeBackgroundColorAction.class$("freemind.controller.actions.generated.instance.NodeBackgroundColorFormatAction")) : class$freemind$controller$actions$generated$instance$NodeBackgroundColorFormatAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RemoveNodeBackgroundColorAction
    extends NodeGeneralAction {
        private final ModeController controller;

        public RemoveNodeBackgroundColorAction(final ModeController controller) {
            super(controller, "remove_node_background_color", (String)null);
            this.controller = controller;
            this.setSingleNodeOperation(new SingleNodeOperation(){

                public void apply(MindMapMapModel map, MindMapNodeModel node) {
                    controller.setNodeBackgroundColor(node, null);
                }
            });
        }
    }
}

