/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class FindAction
extends AbstractAction {
    private final ModeController controller;
    private ArrayList findNodesUnfoldedByLastFind;
    private MindMapNode findFromNode;
    private String findWhat;
    private boolean findCaseSensitive;
    private LinkedList findNodeQueue;

    public String getFindWhat() {
        return this.findWhat;
    }

    public String getFindFromText() {
        return ((Object)this.findFromNode).toString();
    }

    public FindAction(ModeController controller) {
        super(controller.getText("find"), new ImageIcon(controller.getController().getResource("images/filefind.png")));
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        String what = JOptionPane.showInputDialog(this.controller.getView().getSelected(), (Object)this.controller.getText("find_what"));
        if (what == null || what.equals("")) {
            return;
        }
        boolean found = this.find(this.controller.getSelected(), what, false);
        this.controller.getView().repaint();
        if (!found) {
            this.controller.getController().informationMessage(this.controller.getText("no_found_from").replaceAll("\\$1", what).replaceAll("\\$2", this.getFindFromText()), this.controller.getView().getSelected());
        }
    }

    public boolean find(MindMapNode node, String what, boolean caseSensitive) {
        this.findNodesUnfoldedByLastFind = new ArrayList();
        LinkedList<MindMapNode> nodes = new LinkedList<MindMapNode>();
        nodes.addFirst(node);
        this.findFromNode = node;
        if (!caseSensitive) {
            what = what.toLowerCase();
        }
        return this.find(nodes, what, caseSensitive);
    }

    private boolean find(LinkedList nodes, String what, boolean caseSensitive) {
        boolean thereWereNodesToBeFolded;
        boolean bl = thereWereNodesToBeFolded = !this.findNodesUnfoldedByLastFind.isEmpty();
        if (!this.findNodesUnfoldedByLastFind.isEmpty()) {
            ListIterator i = this.findNodesUnfoldedByLastFind.listIterator(this.findNodesUnfoldedByLastFind.size());
            while (i.hasPrevious()) {
                MindMapNode node = (MindMapNode)i.previous();
                try {
                    this.controller.setFolded(node, true);
                }
                catch (Exception e) {}
            }
            this.findNodesUnfoldedByLastFind = new ArrayList();
        }
        while (!nodes.isEmpty()) {
            MindMapNode node = (MindMapNode)nodes.removeFirst();
            ListIterator i = node.childrenUnfolded();
            while (i.hasNext()) {
                nodes.addLast(i.next());
            }
            String nodeText = caseSensitive ? ((Object)node).toString() : ((Object)node).toString().toLowerCase();
            if (nodeText.indexOf(what) < 0) continue;
            this.displayNode(node, this.findNodesUnfoldedByLastFind);
            this.centerNode(node);
            this.findWhat = what;
            this.findCaseSensitive = caseSensitive;
            this.findNodeQueue = nodes;
            return true;
        }
        this.centerNode(this.findFromNode);
        return false;
    }

    public void displayNode(MindMapNode node, ArrayList nodesUnfoldedByDisplay) {
        Object[] path = this.controller.getMap().getPathToRoot(node);
        for (int i = 0; i < path.length - 1; ++i) {
            MindMapNode nodeOnPath = (MindMapNode)path[i];
            if (!nodeOnPath.isFolded()) continue;
            if (nodesUnfoldedByDisplay != null) {
                nodesUnfoldedByDisplay.add(nodeOnPath);
            }
            this.controller.setFolded(nodeOnPath, false);
        }
    }

    public boolean findNext() {
        if (this.findWhat != null) {
            return this.find(this.findNodeQueue, this.findWhat, this.findCaseSensitive);
        }
        return false;
    }

    private void centerNode(MindMapNode node) {
        this.controller.centerNode(node);
    }

    public static class FindNextAction
    extends AbstractAction {
        private final ModeController controller;
        private final FindAction find;

        public FindNextAction(ModeController controller, FindAction find) {
            super(controller.getText("find_next"));
            this.controller = controller;
            this.find = find;
        }

        public void actionPerformed(ActionEvent e) {
            String what = this.find.getFindWhat();
            if (what == null) {
                this.controller.getController().informationMessage(this.controller.getText("no_previous_find"), this.controller.getView().getSelected());
                return;
            }
            boolean found = this.find.findNext();
            this.controller.getView().repaint();
            if (!found) {
                this.controller.getController().informationMessage(this.controller.getText("no_more_found_from").replaceAll("\\$1", what).replaceAll("\\$2", this.find.getFindFromText()), this.controller.getView().getSelected());
            }
        }
    }
}

